/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.InlineSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.AbstractInlinedValueProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.Profile;

public final class InlinedExactClassProfile
extends AbstractInlinedValueProfile {
    private static final InlinedExactClassProfile DISABLED;
    private final InlineSupport.ReferenceField<Class<?>> cachedValue;

    private InlinedExactClassProfile() {
        this.cachedValue = null;
    }

    private InlinedExactClassProfile(InlineSupport.InlineTarget target) {
        super(target);
        this.cachedValue = target.getReference(1, Class.class);
    }

    public <T> T profile(Node node, T value) {
        int localState;
        if (this.state != null && (localState = this.state.get(node)) != 2) {
            Class<?> c2;
            if (localState == 1 && value != null && (c2 = this.cachedValue.get(node)) != null) {
                if (CompilerDirectives.inCompiledCode()) {
                    if (CompilerDirectives.isExact(value, c2)) {
                        return (T)CompilerDirectives.castExact(value, c2);
                    }
                } else if (value.getClass() == c2) {
                    return value;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (localState == 0 && value != null) {
                this.cachedValue.set(node, value.getClass());
                this.state.set(node, 1);
            } else {
                this.cachedValue.set(node, Object.class);
                this.state.set(node, 2);
            }
        }
        return value;
    }

    Class<?> getCachedValue(Node node) {
        return this.cachedValue.get(node);
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(InlinedExactClassProfile.class, this.isUninitialized(node), this.isGeneric(node), String.format("value == %s", this.getCachedValue(node)));
    }

    public static InlinedExactClassProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2), @InlineSupport.RequiredField(value=InlineSupport.ReferenceField.class, type=Class.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedExactClassProfile(target);
        }
        return InlinedExactClassProfile.getUncached();
    }

    public static InlinedExactClassProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedExactClassProfile profile;
        DISABLED = profile = new InlinedExactClassProfile();
    }
}

