/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.InlineSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.AbstractInlinedValueProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.IntValueProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.Profile;

public final class InlinedFloatValueProfile
extends AbstractInlinedValueProfile {
    private static final InlinedFloatValueProfile DISABLED;
    private final InlineSupport.IntField cachedValue;

    private InlinedFloatValueProfile() {
        this.cachedValue = null;
    }

    private InlinedFloatValueProfile(InlineSupport.InlineTarget target) {
        super(target);
        this.cachedValue = target.getPrimitive(1, InlineSupport.IntField.class);
    }

    public float profile(Node node, float value) {
        int localState;
        if (this.state != null && (localState = this.state.get(node)) != 2) {
            int v2;
            if (localState == 1 && (v2 = this.cachedValue.get(node)) == Float.floatToRawIntBits(value)) {
                if (CompilerDirectives.inCompiledCode()) {
                    return Float.intBitsToFloat(v2);
                }
                return value;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (localState == 0) {
                this.cachedValue.set(node, Float.floatToRawIntBits(value));
                this.state.set(node, 1);
            } else {
                this.state.set(node, 2);
            }
        }
        return value;
    }

    float getCachedValue(Node node) {
        return Float.intBitsToFloat(this.cachedValue.get(node));
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(IntValueProfile.class, this.isUninitialized(node), this.isGeneric(node), String.format("value == (float)%s", this.cachedValue));
    }

    public static InlinedFloatValueProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedFloatValueProfile(target);
        }
        return InlinedFloatValueProfile.getUncached();
    }

    public static InlinedFloatValueProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedFloatValueProfile profile;
        DISABLED = profile = new InlinedFloatValueProfile();
    }
}

