/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.InlineSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.Profile;

public final class InlinedLoopConditionProfile
extends InlinedProfile {
    private static final InlinedLoopConditionProfile DISABLED;
    private final InlineSupport.LongField trueCount;
    private final InlineSupport.IntField falseCount;
    static final int MAX_VALUE = 0x3FFFFFFF;

    private InlinedLoopConditionProfile() {
        this.trueCount = null;
        this.falseCount = null;
    }

    private InlinedLoopConditionProfile(InlineSupport.InlineTarget target) {
        this.trueCount = target.getPrimitive(0, InlineSupport.LongField.class);
        this.falseCount = target.getPrimitive(1, InlineSupport.IntField.class);
    }

    public boolean profile(Node node, boolean condition) {
        if (this.trueCount == null) {
            return condition;
        }
        long trueCountLocal = this.trueCount.get(node);
        int falseCountLocal = this.falseCount.get(node);
        if (trueCountLocal == 0L && condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            if (condition) {
                if (trueCountLocal < Long.MAX_VALUE) {
                    this.trueCount.set(node, trueCountLocal + 1L);
                }
            } else if (falseCountLocal < Integer.MAX_VALUE) {
                this.falseCount.set(node, falseCountLocal + 1);
            }
            return condition;
        }
        if (this != DISABLED) {
            return CompilerDirectives.injectBranchProbability(InlinedLoopConditionProfile.calculateProbability(trueCountLocal, falseCountLocal), condition);
        }
        return condition;
    }

    public void profileCounted(Node node, long length) {
        long trueCountLocal;
        if (HostCompilerDirectives.inInterpreterFastPath() && this != DISABLED && (trueCountLocal = this.trueCount.get(node) + length) >= 0L) {
            this.trueCount.set(node, trueCountLocal);
            int falseCountLocal = this.falseCount.get(node);
            if (falseCountLocal < Integer.MAX_VALUE) {
                this.falseCount.set(node, falseCountLocal + 1);
            }
        }
    }

    public boolean inject(Node node, boolean condition) {
        if (CompilerDirectives.inCompiledCode() && this != DISABLED) {
            return CompilerDirectives.injectBranchProbability(InlinedLoopConditionProfile.calculateProbability(this.trueCount.get(node), this.falseCount.get(node)), condition);
        }
        return condition;
    }

    private static double calculateProbability(long trueCountLocal, int falseCountLocal) {
        if (falseCountLocal == 0 && trueCountLocal == 0L) {
            return 0.0;
        }
        return (double)trueCountLocal / (double)(trueCountLocal + (long)falseCountLocal);
    }

    public boolean wasTrue(Node node) {
        return this.getTrueCount(node) != 0L;
    }

    public boolean wasFalse(Node node) {
        return this.getFalseCount(node) != 0;
    }

    @Override
    public void disable(Node node) {
        if (this.trueCount == null) {
            return;
        }
        if (this.trueCount.get(node) == 0L) {
            this.trueCount.set(node, 1L);
        }
        if (this.falseCount.get(node) == 0) {
            this.falseCount.set(node, 1);
        }
    }

    @Override
    public void reset(Node node) {
        if (this.trueCount == null) {
            return;
        }
        this.trueCount.set(node, 0L);
        this.falseCount.set(node, 0);
    }

    long getTrueCount(Node node) {
        if (this.trueCount == null) {
            return Integer.MAX_VALUE;
        }
        return this.trueCount.get(node);
    }

    int getFalseCount(Node node) {
        if (this.trueCount == null) {
            return Integer.MAX_VALUE;
        }
        return this.falseCount.get(node);
    }

    boolean isGeneric(Node node) {
        if (this.trueCount == null) {
            return true;
        }
        return this.getTrueCount(node) != 0L && this.getFalseCount(node) != 0;
    }

    boolean isUninitialized(Node node) {
        if (this.trueCount == null) {
            return false;
        }
        return this.getTrueCount(node) == 0L && this.getFalseCount(node) == 0;
    }

    @Override
    public String toString(Node node) {
        if (this.trueCount == null) {
            return this.toStringDisabled();
        }
        long t2 = this.trueCount.get(node);
        int f2 = this.falseCount.get(node);
        long sum = t2 + (long)f2;
        String details = String.format("trueProbability=%s (trueCount=%s, falseCount=%s)", (double)t2 / (double)sum, t2, f2);
        return this.toString(ConditionProfile.class, sum == 0L, false, details);
    }

    public static InlinedLoopConditionProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.LongField.class), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedLoopConditionProfile(target);
        }
        return InlinedLoopConditionProfile.getUncached();
    }

    public static InlinedLoopConditionProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedLoopConditionProfile profile;
        DISABLED = profile = new InlinedLoopConditionProfile();
    }
}

