/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;

public abstract class SourceSection {
    final Source source;

    SourceSection(Source source) {
        assert (source != null);
        this.source = source;
    }

    public abstract boolean isAvailable();

    abstract boolean isValid();

    public abstract boolean hasLines();

    public abstract boolean hasColumns();

    public abstract boolean hasCharIndex();

    public final Source getSource() {
        return this.source;
    }

    public abstract int getStartLine();

    public abstract int getStartColumn();

    public abstract int getEndLine();

    public abstract int getEndColumn();

    public abstract int getCharIndex();

    public abstract int getCharLength();

    public abstract int getCharEndIndex();

    public abstract CharSequence getCharacters();

    public final String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("SourceSection(source=").append(this.getSource().getName());
        if (this.isAvailable()) {
            if (this.hasLines()) {
                b2.append(" [").append(this.getStartLine());
                if (this.hasColumns()) {
                    b2.append(':').append(this.getStartColumn());
                }
                b2.append(" - ").append(this.getEndLine());
                if (this.hasColumns()) {
                    b2.append(':').append(this.getEndColumn());
                }
                b2.append("]");
            }
            if (this.hasCharIndex()) {
                b2.append(", index=").append(this.getCharIndex());
                b2.append(", length=").append(this.getCharLength());
            }
            if (this.isValid()) {
                if (this.source.hasCharacters()) {
                    b2.append(", characters=").append(this.getCharacters().toString().replaceAll("\\n", "\\\\n"));
                } else {
                    b2.append(", characters not known");
                }
            } else {
                b2.append(", valid=false");
            }
        } else {
            b2.append(" available=false");
        }
        b2.append(")");
        return b2.toString();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

