/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import java.util.ArrayList;
import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.ArrayUtils;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.DecodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.Encodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.IndexOfCodePointSetFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TSCodeRange;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringOps;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;

final class IndexOfCodePointSet {
    private static final int[] EMPTY_RANGES = new int[0];
    private static final int[] ASCII_RANGE = new int[]{0, 127};
    private static final int[] LATIN_RANGE = new int[]{0, 255};
    private static final int[] BMP_WITHOUT_SURROGATES = new int[]{0, 55295, 57344, 65535};
    private static final int[] ALL_WITHOUT_SURROGATES = new int[]{0, 55295, 57344, 0x10FFFF};
    private static final int[] ALL = new int[]{0, 0x10FFFF};
    private static final int TABLE_SIZE = 16;

    IndexOfCodePointSet() {
    }

    static IndexOfNode[] fromRanges(int[] ranges, TruffleString.Encoding encoding) {
        IndexOfCodePointSet.checkRangesArray(ranges, encoding);
        return IndexOfCodePointSet.extractIndexOfNodes(ranges, encoding);
    }

    static void checkRangesArray(int[] ranges, TruffleString.Encoding encoding) {
        if ((ranges.length & 1) != 0) {
            throw new IllegalArgumentException("ranges must have an even number of elements");
        }
        int maxCodePoint = Encodings.maxCodePoint(encoding);
        int lastHi = -2;
        for (int i2 = 0; i2 < ranges.length; i2 += 2) {
            int lo = ranges[i2];
            int hi = ranges[i2 + 1];
            IndexOfCodePointSet.checkIllegalCodepoint(lo, maxCodePoint);
            IndexOfCodePointSet.checkIllegalCodepoint(hi, maxCodePoint);
            if (lo > hi) {
                throw new IllegalArgumentException(String.format("range [0x%x - 0x%x] out of order", lo, hi));
            }
            if (lo == lastHi + 1) {
                throw new IllegalArgumentException(String.format("ranges [0x%x - 0x%x] and [0x%x - 0x%x] are directly adjacent and must be merged into one", ranges[i2 - 2], lastHi, lo, hi));
            }
            if (lastHi >= lo) {
                throw new IllegalArgumentException("ranges are not sorted");
            }
            lastHi = hi;
        }
    }

    private static IndexOfNode[] extractIndexOfNodes(int[] ranges, TruffleString.Encoding encoding) {
        if (encoding == TruffleString.Encoding.US_ASCII || encoding == TruffleString.Encoding.ISO_8859_1 || encoding == TruffleString.Encoding.BYTES || IndexOfCodePointSet.getMax(ranges) <= 127) {
            return IndexOfCodePointSet.extractIndexOfNodes1ByteEncoding(ranges);
        }
        if (encoding == TruffleString.Encoding.UTF_8) {
            IndexOfNode[] indexOfNodeArray;
            IndexOfRangesNode nonAscii;
            if (IndexOfCodePointSet.isSingleValue(ranges)) {
                int codepoint = IndexOfCodePointSet.getMin(ranges);
                byte[] encoded = Encodings.utf8Encode(codepoint);
                int codeRange = Encodings.isUTF16Surrogate(codepoint) ? TSCodeRange.getBrokenMultiByte() : TSCodeRange.getValidMultiByte();
                int codepointLength = Encodings.isUTF16Surrogate(codepoint) ? encoded.length : 1;
                return new IndexOfNode[]{IndexOfCodePointSetFactory.IndexOfStringNodeGen.create(TSCodeRange.getBrokenMultiByte(), TruffleString.createFromByteArray(encoded, encoded.length, 0, TruffleString.Encoding.UTF_8, codepointLength, codeRange))};
            }
            IndexOfNode ascii = IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.get7Bit(), ranges, ASCII_RANGE);
            if (ascii.codeEquals(nonAscii = IndexOfCodePointSetFactory.IndexOfRangesNodeGen.create(TSCodeRange.getBrokenMultiByte(), ranges))) {
                IndexOfNode[] indexOfNodeArray2 = new IndexOfNode[1];
                indexOfNodeArray = indexOfNodeArray2;
                indexOfNodeArray2[0] = nonAscii;
            } else {
                IndexOfNode[] indexOfNodeArray3 = new IndexOfNode[2];
                indexOfNodeArray3[0] = ascii;
                indexOfNodeArray = indexOfNodeArray3;
                indexOfNodeArray3[1] = nonAscii;
            }
            return indexOfNodeArray;
        }
        ArrayList<IndexOfNode> nodes = new ArrayList<IndexOfNode>();
        nodes.add(IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.get7Bit(), ranges, ASCII_RANGE));
        IndexOfCodePointSet.addOrReplaceLast(nodes, IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.get8Bit(), ranges, LATIN_RANGE));
        IndexOfCodePointSet.addOrReplaceLast(nodes, IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.get16Bit(), ranges, BMP_WITHOUT_SURROGATES));
        if (encoding == TruffleString.Encoding.UTF_16) {
            if (!Arrays.equals(IndexOfCodePointSet.intersect(ranges, BMP_WITHOUT_SURROGATES), ranges)) {
                if (IndexOfCodePointSet.isSingleValue(ranges)) {
                    int codepoint = IndexOfCodePointSet.getMin(ranges);
                    if (Encodings.isUTF16Surrogate(codepoint)) {
                        IndexOfCodePointSet.addOrReplaceLast(nodes, IndexOfCodePointSetFactory.IndexOfAnyValueNodeGen.create(TSCodeRange.getBrokenMultiByte(), new int[]{codepoint}));
                    } else {
                        assert (codepoint > 65535);
                        byte[] encoded = Encodings.utf16Encode(codepoint);
                        IndexOfCodePointSet.addOrReplaceLast(nodes, IndexOfCodePointSetFactory.IndexOfStringNodeGen.create(TSCodeRange.getBrokenMultiByte(), TruffleString.createFromByteArray(encoded, encoded.length >> 1, 1, TruffleString.Encoding.UTF_16, 1, TSCodeRange.getValidMultiByte())));
                    }
                } else {
                    IndexOfCodePointSet.addOrReplaceLast(nodes, IndexOfCodePointSetFactory.IndexOfRangesNodeGen.create(TSCodeRange.getBrokenMultiByte(), ranges));
                }
            }
        } else if (encoding == TruffleString.Encoding.UTF_32) {
            IndexOfCodePointSet.addOrReplaceLast(nodes, IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.getValidFixedWidth(), ranges, ALL_WITHOUT_SURROGATES));
            IndexOfCodePointSet.addOrReplaceLast(nodes, IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.getBrokenFixedWidth(), ranges, ALL));
        } else {
            throw new UnsupportedOperationException();
        }
        return (IndexOfNode[])nodes.toArray(IndexOfNode[]::new);
    }

    private static void addOrReplaceLast(ArrayList<IndexOfNode> nodes, IndexOfNode node) {
        if (nodes.get(nodes.size() - 1).codeEquals(node)) {
            assert (TSCodeRange.isMoreRestrictiveThan(nodes.get((int)(nodes.size() - 1)).maxCodeRange, node.maxCodeRange));
            nodes.remove(nodes.size() - 1);
        }
        nodes.add(node);
    }

    private static void checkIllegalCodepoint(int c2, int maxCodePoint) {
        if (Integer.toUnsignedLong(c2) > (long)maxCodePoint) {
            throw new IllegalArgumentException(String.format("illegal codepoint value 0x%x", c2));
        }
    }

    private static IndexOfNode[] extractIndexOfNodes1ByteEncoding(int[] ranges) {
        IndexOfNode[] indexOfNodeArray;
        IndexOfNode latin;
        IndexOfNode ascii = IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.get7Bit(), ranges, ASCII_RANGE);
        if (ascii.codeEquals(latin = IndexOfCodePointSet.extractIndexOfNodeFixedWidth(TSCodeRange.get8Bit(), ranges, LATIN_RANGE))) {
            IndexOfNode[] indexOfNodeArray2 = new IndexOfNode[1];
            indexOfNodeArray = indexOfNodeArray2;
            indexOfNodeArray2[0] = latin;
        } else {
            IndexOfNode[] indexOfNodeArray3 = new IndexOfNode[2];
            indexOfNodeArray3[0] = ascii;
            indexOfNodeArray = indexOfNodeArray3;
            indexOfNodeArray3[1] = latin;
        }
        return indexOfNodeArray;
    }

    private static int[] intersect(int[] rangesA, int[] rangesB) {
        if (IndexOfCodePointSet.isEmpty(rangesA) || IndexOfCodePointSet.getMin(rangesB) <= IndexOfCodePointSet.getMin(rangesA) && IndexOfCodePointSet.getHi(rangesB, 0) >= IndexOfCodePointSet.getMax(rangesA)) {
            return rangesA;
        }
        if (IndexOfCodePointSet.size(rangesB) == 1) {
            return IndexOfCodePointSet.intersectSingleRange(rangesA, rangesB[0], rangesB[1]);
        }
        assert (IndexOfCodePointSet.size(rangesB) == 2);
        return IndexOfCodePointSet.intersectTwoRanges(rangesA, rangesB[0], rangesB[1], rangesB[2], rangesB[3]);
    }

    private static int[] intersectSingleRange(int[] ranges, int lo, int hi) {
        int size = IndexOfCodePointSet.size(ranges);
        int iLo = IndexOfCodePointSet.findFirstIntersection(ranges, lo, 0);
        int iHi = IndexOfCodePointSet.findLastIntersection(ranges, hi, size - 1);
        if (iHi < iLo) {
            return EMPTY_RANGES;
        }
        int[] intersection = Arrays.copyOfRange(ranges, iLo << 1, iHi + 1 << 1);
        intersection[0] = Math.max(intersection[0], lo);
        intersection[intersection.length - 1] = Math.min(intersection[intersection.length - 1], hi);
        return intersection;
    }

    private static int findFirstIntersection(int[] ranges, int lo, int startIndex) {
        int iLo;
        for (iLo = startIndex; iLo < IndexOfCodePointSet.size(ranges) && IndexOfCodePointSet.getHi(ranges, iLo) < lo; ++iLo) {
        }
        return iLo;
    }

    private static int findLastIntersection(int[] ranges, int hi, int startIndex) {
        int iHi;
        for (iHi = startIndex; iHi >= 0 && IndexOfCodePointSet.getLo(ranges, iHi) > hi; --iHi) {
        }
        return iHi;
    }

    private static int[] intersectTwoRanges(int[] ranges, int lo0, int hi0, int lo1, int hi1) {
        int size1;
        if (hi1 < IndexOfCodePointSet.getMin(ranges) || lo0 > IndexOfCodePointSet.getMax(ranges)) {
            return EMPTY_RANGES;
        }
        int size = IndexOfCodePointSet.size(ranges);
        int iLo0 = IndexOfCodePointSet.findFirstIntersection(ranges, lo0, 0);
        int iLo1 = IndexOfCodePointSet.findFirstIntersection(ranges, lo1, 0);
        int iHi0 = IndexOfCodePointSet.findLastIntersection(ranges, hi0, size - 1);
        int iHi1 = IndexOfCodePointSet.findLastIntersection(ranges, hi1, size - 1);
        int size0 = Math.max(0, iHi0 + 1 - iLo0);
        int intersectionSize = size0 + (size1 = Math.max(0, iHi1 + 1 - iLo1));
        if (intersectionSize == 0) {
            return EMPTY_RANGES;
        }
        int[] intersection = new int[intersectionSize << 1];
        System.arraycopy(ranges, iLo0 << 1, intersection, 0, size0 << 1);
        System.arraycopy(ranges, iLo1 << 1, intersection, size0 << 1, size1 << 1);
        if (size0 != 0) {
            intersection[0] = Math.max(intersection[0], lo0);
            intersection[(size0 << 1) - 1] = Math.min(intersection[(size0 << 1) - 1], hi0);
        }
        if (size1 != 0) {
            intersection[size0 << 1] = Math.max(intersection[size0 << 1], lo1);
            intersection[intersection.length - 1] = Math.min(intersection[intersection.length - 1], hi1);
        }
        return intersection;
    }

    private static IndexOfNode extractIndexOfNodeFixedWidth(int maxCodeRange, int[] ranges, int[] bounds) {
        int[] intersection = IndexOfCodePointSet.intersect(ranges, bounds);
        if (intersection.length == 0) {
            return IndexOfCodePointSetFactory.NoMatchNodeGen.create(maxCodeRange);
        }
        if (Arrays.equals(intersection, bounds)) {
            return IndexOfCodePointSetFactory.AnyMatchNodeGen.create(maxCodeRange);
        }
        int valueCount = IndexOfCodePointSet.valueCount(intersection);
        if (valueCount <= 4) {
            return IndexOfCodePointSetFactory.IndexOfAnyValueNodeGen.create(maxCodeRange, IndexOfCodePointSet.toValues(intersection, valueCount));
        }
        if (IndexOfCodePointSet.size(intersection) <= 2) {
            return IndexOfCodePointSetFactory.IndexOfAnyRangeNodeGen.create(maxCodeRange, intersection);
        }
        if (IndexOfCodePointSet.getMax(intersection) <= 255) {
            byte[] tables = IndexOfCodePointSet.generateTable(intersection);
            if (tables != null) {
                return IndexOfCodePointSetFactory.IndexOfTableNodeGen.create(maxCodeRange, tables);
            }
            return IndexOfBitSetNode.fromRanges(maxCodeRange, intersection);
        }
        return IndexOfCodePointSetFactory.IndexOfRangesNodeGen.create(maxCodeRange, intersection);
    }

    private static boolean isEmpty(int[] ranges) {
        return ranges.length == 0;
    }

    private static int size(int[] ranges) {
        return ranges.length >> 1;
    }

    private static int getLo(int[] ranges, int i2) {
        return ranges[i2 << 1];
    }

    private static int getHi(int[] ranges, int i2) {
        return ranges[(i2 << 1) + 1];
    }

    private static int getMin(int[] ranges) {
        return ranges[0];
    }

    private static int getMax(int[] ranges) {
        return ranges[ranges.length - 1];
    }

    private static boolean isSingleValue(int[] ranges) {
        return ranges.length == 2 && ranges[0] == ranges[1];
    }

    private static int valueCount(int[] ranges) {
        int count = 0;
        for (int i2 = 0; i2 < ranges.length; i2 += 2) {
            count += ranges[i2 + 1] - ranges[i2] + 1;
        }
        return count;
    }

    private static boolean contains(int[] ranges, int v2) {
        for (int i2 = 0; i2 < ranges.length; i2 += 2) {
            if (ranges[i2] > v2 || v2 > ranges[i2 + 1]) continue;
            return true;
        }
        return false;
    }

    private static int[] toValues(int[] ranges, int valueCount) {
        int[] values = new int[valueCount];
        int index = 0;
        for (int i2 = 0; i2 < ranges.length; i2 += 2) {
            int j2 = ranges[i2];
            while (j2 <= ranges[i2 + 1]) {
                values[index++] = j2++;
            }
        }
        return values;
    }

    private static byte[] generateTable(int[] ranges) {
        assert (IndexOfCodePointSet.getMax(ranges) <= 255);
        char[] bitSet = new char[16];
        for (int i2 = 0; i2 < ranges.length; i2 += 2) {
            IndexOfCodePointSet.setRange(bitSet, ranges[i2], ranges[i2 + 1]);
        }
        char[] uniqueValues = new char[16];
        int nUniqueValues = 0;
        for (char c2 : bitSet) {
            if (c2 == '\u0000' || ArrayUtils.indexOf(uniqueValues, 0, uniqueValues.length, c2) >= 0) continue;
            uniqueValues[nUniqueValues++] = c2;
        }
        if (nUniqueValues <= 8) {
            return IndexOfCodePointSet.generateTableDirectMapping(ranges, bitSet, uniqueValues, nUniqueValues);
        }
        return IndexOfCodePointSet.generateTableTryDecomposition(ranges, bitSet, uniqueValues, nUniqueValues);
    }

    private static byte[] generateTableDirectMapping(int[] ranges, char[] bitSet, char[] uniqueValues, int nUniqueValues) {
        byte[] tables = new byte[32];
        for (int upperNibble = 0; upperNibble < 16; ++upperNibble) {
            byte uniqueBit;
            if (bitSet[upperNibble] == '\u0000') continue;
            tables[upperNibble] = uniqueBit = (byte)(1 << ArrayUtils.indexOf(uniqueValues, 0, nUniqueValues, bitSet[upperNibble]));
            for (int lowerNibble = 0; lowerNibble < 16; ++lowerNibble) {
                if ((bitSet[upperNibble] & 1 << lowerNibble) == 0) continue;
                int n2 = 16 + lowerNibble;
                tables[n2] = (byte)(tables[n2] | uniqueBit);
            }
        }
        IndexOfCodePointSet.verifyTable(ranges, tables);
        return tables;
    }

    private static byte[] generateTableTryDecomposition(int[] ranges, char[] bitSet, char[] uniqueValues, int nUniqueValues) {
        assert (nUniqueValues > 8);
        byte[] tables = new byte[32];
        CompositeBitSet[] bitSets = new CompositeBitSet[nUniqueValues];
        for (int i2 = 0; i2 < nUniqueValues; ++i2) {
            bitSets[i2] = new CompositeBitSet();
        }
        int nComponents = nUniqueValues;
        ArrayList<CompositeBitSet> components = new ArrayList<CompositeBitSet>();
        for (int i3 = 0; i3 < bitSets.length; ++i3) {
            char cur = uniqueValues[i3];
            char compositeValue = '\u0000';
            components.clear();
            for (int j2 = 0; j2 < bitSets.length; ++j2) {
                if (j2 == i3 || (cur | uniqueValues[j2]) != cur) continue;
                compositeValue = (char)(compositeValue | uniqueValues[j2]);
                components.add(bitSets[j2]);
            }
            if (compositeValue != cur) continue;
            bitSets[i3].components = (CompositeBitSet[])components.toArray(CompositeBitSet[]::new);
            --nComponents;
        }
        if (nComponents > 8) {
            return null;
        }
        byte uniqueBit = 1;
        for (int i4 = 0; i4 < bitSets.length; ++i4) {
            CompositeBitSet cbs = bitSets[i4];
            if (cbs.components != null) continue;
            assert (uniqueBit != 0);
            cbs.uniqueBit = uniqueBit;
            for (int lowerNibble = 0; lowerNibble < 16; ++lowerNibble) {
                if ((uniqueValues[i4] & 1 << lowerNibble) == 0) continue;
                int n2 = 16 + lowerNibble;
                tables[n2] = (byte)(tables[n2] | uniqueBit);
            }
            uniqueBit = (byte)(uniqueBit << 1);
        }
        for (CompositeBitSet cbs : bitSets) {
            if (cbs.components == null) continue;
            for (CompositeBitSet component : cbs.components) {
                cbs.uniqueBit = (byte)(cbs.uniqueBit | component.uniqueBit);
            }
        }
        for (int upperNibble = 0; upperNibble < 16; ++upperNibble) {
            if (bitSet[upperNibble] == '\u0000') continue;
            tables[upperNibble] = bitSets[ArrayUtils.indexOf((char[])uniqueValues, (int)0, (int)nUniqueValues, (char[])new char[]{bitSet[upperNibble]})].uniqueBit;
        }
        IndexOfCodePointSet.verifyTable(ranges, tables);
        return tables;
    }

    private static void setRange(char[] bitSet, int lo, int hi) {
        int wordIndexLo = lo >> 4;
        int wordIndexHi = hi >> 4;
        char rangeLo = (char)(65535 << (lo & 0xF));
        char rangeHi = (char)(65535 >>> 15 - (hi & 0xF));
        if (wordIndexLo == wordIndexHi) {
            int n2 = wordIndexLo;
            bitSet[n2] = (char)(bitSet[n2] | (char)(rangeLo & rangeHi));
            return;
        }
        int n3 = wordIndexLo;
        bitSet[n3] = (char)(bitSet[n3] | rangeLo);
        for (int i2 = wordIndexLo + 1; i2 < wordIndexHi; ++i2) {
            bitSet[i2] = 65535;
        }
        int n4 = wordIndexHi;
        bitSet[n4] = (char)(bitSet[n4] | rangeHi);
    }

    private static void verifyTable(int[] expectedRanges, byte[] tables) {
        assert (IndexOfCodePointSet.verifyTableInner(expectedRanges, tables));
    }

    private static boolean verifyTableInner(int[] expectedRanges, byte[] tables) {
        for (int i2 = 0; i2 <= 255; ++i2) {
            assert (IndexOfCodePointSet.contains(expectedRanges, i2) == ((tables[i2 >>> 4 & 0xF] & tables[16 + (i2 & 0xF)]) != 0));
        }
        return true;
    }

    static abstract class IndexOfNode
    extends Node {
        final byte maxCodeRange;

        IndexOfNode(int maxCodeRange) {
            assert (TSCodeRange.isCodeRange(maxCodeRange));
            this.maxCodeRange = (byte)maxCodeRange;
        }

        abstract int execute(Node var1, Object var2, int var3, int var4, int var5, int var6, int var7, int var8, TruffleString.Encoding var9);

        @Specialization
        int doWithConditionProfile(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached InlinedBranchProfile branchProfile) {
            branchProfile.enter(this);
            return this.runSearch(location, arrayA, offsetA, lengthA, strideA, codeRangeA, fromIndex, toIndex, encoding);
        }

        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        boolean codeEquals(IndexOfNode other) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        IndexOfNode shallowCopy() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        final byte getMaxCodeRange() {
            return this.maxCodeRange;
        }

        final boolean isFast() {
            return this instanceof OptimizedIndexOfNode;
        }
    }

    static abstract class IndexOfStringNode
    extends OptimizedIndexOfNode {
        final TruffleString str;

        IndexOfStringNode(int maxCodeRange, TruffleString string) {
            super(maxCodeRange);
            this.str = string;
        }

        @Override
        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            return TStringOps.indexOfStringWithOrMaskWithStride(location, arrayA, offsetA, lengthA, strideA, this.str.data(), this.str.offset(), this.str.length(), this.str.stride(), fromIndex, toIndex, null);
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof IndexOfStringNode && this.str.equals(((IndexOfStringNode)other).str);
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.IndexOfStringNodeGen.create(this.maxCodeRange, this.str);
        }
    }

    static abstract class IndexOfRangesNode
    extends ScalarIndexOfNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final int[] ranges;

        IndexOfRangesNode(int maxCodeRange, int[] ranges) {
            super(maxCodeRange);
            this.ranges = ranges;
        }

        @Override
        boolean match(int c2) {
            return IndexOfRangesNode.rangesContain(this.ranges, c2);
        }

        static boolean rangesContain(int[] ranges, int c2) {
            int fromIndex = 0;
            int toIndex = (ranges.length >>> 1) - 1;
            while (fromIndex <= toIndex) {
                int mid = fromIndex + toIndex >>> 1;
                if (c2 < ranges[mid << 1]) {
                    toIndex = mid - 1;
                    continue;
                }
                if (c2 > ranges[(mid << 1) + 1]) {
                    fromIndex = mid + 1;
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof IndexOfRangesNode && Arrays.equals(this.ranges, ((IndexOfRangesNode)other).ranges);
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.IndexOfRangesNodeGen.create(this.maxCodeRange, this.ranges);
        }
    }

    static abstract class IndexOfAnyValueNode
    extends OptimizedIndexOfNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final int[] values;

        IndexOfAnyValueNode(int maxCodeRange, int[] values) {
            super(maxCodeRange);
            this.values = values;
        }

        @Override
        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            return TStringOps.indexOfAnyInt(location, arrayA, offsetA, strideA, fromIndex, toIndex, this.values);
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof IndexOfAnyValueNode && Arrays.equals(this.values, ((IndexOfAnyValueNode)other).values);
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.IndexOfAnyValueNodeGen.create(this.maxCodeRange, this.values);
        }
    }

    static abstract class NoMatch
    extends OptimizedIndexOfNode {
        NoMatch(int maxCodeRange) {
            super(maxCodeRange);
        }

        @Override
        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            return -1;
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof NoMatch;
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.NoMatchNodeGen.create(this.maxCodeRange);
        }
    }

    static abstract class AnyMatch
    extends OptimizedIndexOfNode {
        AnyMatch(int maxCodeRange) {
            super(maxCodeRange);
        }

        @Override
        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            return fromIndex;
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof AnyMatch;
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.AnyMatchNodeGen.create(this.maxCodeRange);
        }
    }

    static abstract class IndexOfAnyRangeNode
    extends OptimizedIndexOfNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final int[] ranges;

        IndexOfAnyRangeNode(int maxCodeRange, int[] ranges) {
            super(maxCodeRange);
            this.ranges = ranges;
        }

        @Override
        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            return TStringOps.indexOfAnyIntRange(location, arrayA, offsetA, strideA, fromIndex, toIndex, this.ranges);
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof IndexOfAnyRangeNode && Arrays.equals(this.ranges, ((IndexOfAnyRangeNode)other).ranges);
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.IndexOfAnyRangeNodeGen.create(this.maxCodeRange, this.ranges);
        }
    }

    static abstract class IndexOfTableNode
    extends OptimizedIndexOfNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final byte[] tables;

        IndexOfTableNode(int maxCodeRange, byte[] tables) {
            super(maxCodeRange);
            assert (tables.length == 32);
            this.tables = tables;
        }

        @Override
        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            return TStringOps.indexOfTable(location, arrayA, offsetA, strideA, fromIndex, toIndex, this.tables);
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof IndexOfTableNode && Arrays.equals(this.tables, ((IndexOfTableNode)other).tables);
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.IndexOfTableNodeGen.create(this.maxCodeRange, this.tables);
        }
    }

    static abstract class IndexOfBitSetNode
    extends ScalarIndexOfNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final long[] bitSet;

        IndexOfBitSetNode(int maxCodeRange, long[] bitSet) {
            super(maxCodeRange);
            this.bitSet = bitSet;
        }

        @Override
        boolean match(int codepoint) {
            int wordIndex = codepoint >> 6;
            return wordIndex < this.bitSet.length && (this.bitSet[wordIndex] & 1L << (codepoint & 0x3F)) != 0L;
        }

        @Override
        boolean codeEquals(IndexOfNode other) {
            return other instanceof IndexOfBitSetNode && Arrays.equals(this.bitSet, ((IndexOfBitSetNode)other).bitSet);
        }

        @Override
        IndexOfNode shallowCopy() {
            return IndexOfCodePointSetFactory.IndexOfBitSetNodeGen.create(this.maxCodeRange, this.bitSet);
        }

        static IndexOfBitSetNode fromRanges(int maxCodeRange, int[] ranges) {
            assert (IndexOfCodePointSet.getMax(ranges) <= 255);
            long[] bitSet = new long[4];
            for (int i2 = 0; i2 < ranges.length; i2 += 2) {
                IndexOfBitSetNode.setRange(bitSet, ranges[i2], ranges[i2 + 1]);
            }
            return IndexOfCodePointSetFactory.IndexOfBitSetNodeGen.create(maxCodeRange, bitSet);
        }

        private static void setRange(long[] bitSet, int lo, int hi) {
            int wordIndexLo = lo >> 6;
            int wordIndexHi = hi >> 6;
            long rangeLo = -1L << lo;
            long rangeHi = -1L >>> 63 - (hi & 0x3F);
            if (wordIndexLo == wordIndexHi) {
                int n2 = wordIndexLo;
                bitSet[n2] = bitSet[n2] | rangeLo & rangeHi;
                return;
            }
            int n3 = wordIndexLo;
            bitSet[n3] = bitSet[n3] | rangeLo;
            for (int i2 = wordIndexLo + 1; i2 < wordIndexHi; ++i2) {
                bitSet[i2] = -1L;
            }
            int n4 = wordIndexHi;
            bitSet[n4] = bitSet[n4] | rangeHi;
        }
    }

    private static final class CompositeBitSet {
        private byte uniqueBit;
        private CompositeBitSet[] components;

        private CompositeBitSet() {
        }
    }

    static abstract class ScalarIndexOfNode
    extends IndexOfNode {
        ScalarIndexOfNode(int maxCodeRange) {
            super(maxCodeRange);
        }

        @Override
        int runSearch(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, TruffleString.Encoding encoding) {
            CompilerAsserts.partialEvaluationConstant(this);
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            int codepointLength = 1;
            for (int i2 = fromIndex; i2 < toIndex; i2 += codepointLength) {
                int codepoint;
                if (encoding == TruffleString.Encoding.US_ASCII || encoding == TruffleString.Encoding.ISO_8859_1 || encoding == TruffleString.Encoding.BYTES || TSCodeRange.isFixedWidth(codeRangeA)) {
                    codepoint = TStringOps.readValue(arrayA, offsetA, lengthA, strideA, i2);
                } else if (encoding == TruffleString.Encoding.UTF_8) {
                    if (TSCodeRange.isValid(codeRangeA)) {
                        int firstByte = TStringOps.readS0(arrayA, offsetA, lengthA, i2);
                        codepointLength = firstByte <= 127 ? 1 : Encodings.utf8CodePointLength(firstByte);
                        codepoint = Encodings.utf8DecodeValid(arrayA, offsetA, lengthA, i2);
                    } else {
                        codepointLength = Encodings.utf8GetCodePointLength(arrayA, offsetA, lengthA, i2, DecodingErrorHandler.DEFAULT);
                        codepoint = Encodings.utf8DecodeBroken(arrayA, offsetA, lengthA, i2, TruffleString.ErrorHandling.BEST_EFFORT);
                    }
                } else {
                    assert (encoding == TruffleString.Encoding.UTF_16);
                    if (TSCodeRange.isValid(codeRangeA)) {
                        codepointLength = Encodings.isUTF16HighSurrogate(TStringOps.readS1(arrayA, offsetA, lengthA, i2)) ? 2 : 1;
                        codepoint = Encodings.utf16DecodeValid(arrayA, offsetA, lengthA, i2);
                    } else {
                        codepointLength = Encodings.utf16BrokenGetCodePointByteLength(arrayA, offsetA, lengthA, i2, TruffleString.ErrorHandling.BEST_EFFORT) >> 1;
                        codepoint = Encodings.utf16DecodeBroken(arrayA, offsetA, lengthA, i2, TruffleString.ErrorHandling.BEST_EFFORT);
                    }
                }
                if (!this.match(codepoint)) continue;
                return i2;
            }
            return -1;
        }

        boolean match(int codepoint) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    static abstract class OptimizedIndexOfNode
    extends IndexOfNode {
        OptimizedIndexOfNode(int maxCodeRange) {
            super(maxCodeRange);
        }
    }
}

