/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TSCodeRange;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;

final class Stride {
    static final String STRIDE_CACHE_LIMIT = "3";
    static final int STRIDE_UNROLL = 3;

    Stride() {
    }

    static boolean isStride(int stride) {
        return 0 <= stride && stride <= 2;
    }

    static int fromCodeRange(int codeRange, TruffleString.Encoding encoding) {
        if (TStringGuards.isUTF16(encoding)) {
            return Stride.fromCodeRangeUTF16(codeRange);
        }
        if (TStringGuards.isUTF32(encoding)) {
            return Stride.fromCodeRangeUTF32(codeRange);
        }
        return 0;
    }

    static int fromCodeRangeAllowImprecise(int codeRange, TruffleString.Encoding encoding) {
        if (TStringGuards.isUTF16(encoding)) {
            return Stride.fromCodeRangeUTF16AllowImprecise(codeRange);
        }
        if (TStringGuards.isUTF32(encoding)) {
            return Stride.fromCodeRangeUTF32AllowImprecise(codeRange);
        }
        return 0;
    }

    static int fromCodeRangeUTF16(int codeRange) {
        return TSCodeRange.toStrideUTF16(codeRange);
    }

    static int fromCodeRangeUTF16AllowImprecise(int codeRange) {
        return TSCodeRange.toStrideUTF16AllowImprecise(codeRange);
    }

    static int fromCodeRangeUTF32(int codeRange) {
        return TSCodeRange.toStrideUTF32(codeRange);
    }

    static int fromCodeRangeUTF32AllowImprecise(int codeRange) {
        return TSCodeRange.toStrideUTF32AllowImprecise(codeRange);
    }
}

