/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractTruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.DecodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.Encodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.Stride;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.StringAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TSCodeRange;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringUnsafe;
import sun.misc.Unsafe;

final class TStringOps {
    TStringOps() {
    }

    static int readFromByteArray(byte[] array, int stride, int i2) {
        return TStringOps.readValue(array, 0, array.length >> stride, stride, i2);
    }

    static void writeToByteArray(byte[] array, int stride, int i2, int value) {
        TStringOps.writeValue(array, 0, array.length >> stride, stride, i2, value);
    }

    static int readValue(AbstractTruffleString a2, Object arrayA, int stride, int i2) {
        return TStringOps.readValue(arrayA, a2.offset(), a2.length(), stride, i2);
    }

    static int readS0(AbstractTruffleString a2, Object arrayA, int i2) {
        return TStringOps.readS0(arrayA, a2.offset(), a2.length(), i2);
    }

    static char readS1(AbstractTruffleString a2, Object arrayA, int i2) {
        return TStringOps.readS1(arrayA, a2.offset(), a2.length(), i2);
    }

    static int readS2(AbstractTruffleString a2, Object arrayA, int i2) {
        return TStringOps.readS2(arrayA, a2.offset(), a2.length(), i2);
    }

    static int readS0(Object array, int offset, int length, int i2) {
        return TStringOps.readValue(array, offset, length, 0, i2);
    }

    static char readS1(Object array, int offset, int length, int i2) {
        return (char)TStringOps.readValue(array, offset, length, 1, i2);
    }

    static int readS2(Object array, int offset, int length, int i2) {
        return TStringOps.readValue(array, offset, length, 2, i2);
    }

    static long readS3(Object array, int offset, int length) {
        long stubOffset;
        byte[] stubArray;
        if (TStringOps.isNativePointer(array)) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 3);
        return TStringOps.runReadS3Managed(stubArray, stubOffset);
    }

    static void writeS0(Object array, int offset, int length, int i2, byte value) {
        TStringOps.writeValue(array, offset, length, 0, i2, TStringOps.uInt(value));
    }

    static int readValue(Object array, int offset, int length, int stride, int i2) {
        long stubOffset;
        byte[] stubArray;
        if (TStringOps.isNativePointer(array)) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, i2);
        return TStringOps.readValue(stubArray, stubOffset, stride, i2);
    }

    private static void writeValue(Object array, int offset, int length, int stride, int i2, int value) {
        long stubOffset;
        byte[] stubArray;
        if (TStringOps.isNativePointer(array)) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, i2);
        TStringOps.writeValue(stubArray, stubOffset, stride, i2, value);
    }

    private static int readValueS0(byte[] array, long offset, int i2) {
        return TStringOps.readValue(array, offset, 0, i2);
    }

    private static int readValueS1(byte[] array, long offset, int i2) {
        return TStringOps.readValue(array, offset, 1, i2);
    }

    private static int readValueS2(byte[] array, long offset, int i2) {
        return TStringOps.readValue(array, offset, 2, i2);
    }

    private static int readValue(byte[] array, long offset, int stride, int i2) {
        switch (stride) {
            case 0: {
                return TStringOps.runReadS0Managed(array, offset + (long)i2);
            }
            case 1: {
                return TStringOps.runReadS1Managed(array, offset + ((long)i2 << 1));
            }
        }
        return TStringOps.runReadS2Managed(array, offset + ((long)i2 << 2));
    }

    private static void writeValue(byte[] array, long offset, int stride, int i2, int value) {
        switch (stride) {
            case 0: {
                TStringOps.runWriteS0Managed(array, offset + (long)i2, (byte)value);
                return;
            }
            case 1: {
                TStringOps.runWriteS1Managed(array, offset + ((long)i2 << 1), (char)value);
                return;
            }
        }
        TStringOps.runWriteS2Managed(array, offset + ((long)i2 << 2), value);
    }

    static int indexOfAnyByte(Node location, AbstractTruffleString a2, Object arrayA, int fromIndex, int toIndex, byte[] values) {
        assert (a2.stride() == 0);
        return TStringOps.indexOfAnyByteIntl(location, arrayA, a2.offset(), toIndex, fromIndex, values);
    }

    private static int indexOfAnyByteIntl(Node location, Object array, int offset, int length, int fromIndex, byte[] values) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, 0, fromIndex);
        switch (values.length) {
            case 1: {
                return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]));
            }
            case 2: {
                return TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]));
            }
            case 3: {
                return TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]), TStringOps.uInt(values[2]));
            }
            case 4: {
                return TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]), TStringOps.uInt(values[2]), TStringOps.uInt(values[3]));
            }
        }
        return TStringOps.runIndexOfAnyByte(location, stubArray, stubOffset, length, fromIndex, values);
    }

    static int indexOfAnyChar(Node location, AbstractTruffleString a2, Object arrayA, int stride, int fromIndex, int toIndex, char[] values) {
        assert (stride == 0 || stride == 1);
        return TStringOps.indexOfAnyCharIntl(location, arrayA, a2.offset(), toIndex, stride, fromIndex, values);
    }

    private static int indexOfAnyCharIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, char[] values) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        if (stride == 0) {
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        } else {
            assert (stride == 1);
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        }
        return TStringOps.runIndexOfAnyChar(location, stubArray, stubOffset, length, stride, fromIndex, values);
    }

    static int indexOfAnyInt(Node location, AbstractTruffleString a2, Object arrayA, int stride, int fromIndex, int toIndex, int[] values) {
        return TStringOps.indexOfAnyIntIntl(location, arrayA, a2.offset(), toIndex, stride, fromIndex, values);
    }

    static int indexOfAnyInt(Node location, Object arrayA, int offsetA, int stride, int fromIndex, int toIndex, int[] values) {
        return TStringOps.indexOfAnyIntIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, values);
    }

    private static int indexOfAnyIntIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int[] values) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        if (stride == 0) {
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        } else if (stride == 1) {
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        } else {
            assert (stride == 2);
            switch (values.length) {
                case 1: {
                    return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0]);
                }
                case 2: {
                    return TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0], values[1]);
                }
                case 3: {
                    return TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0], values[1], values[2]);
                }
                case 4: {
                    return TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                }
            }
        }
        return TStringOps.runIndexOfAnyInt(location, stubArray, stubOffset, length, stride, fromIndex, values);
    }

    static int indexOfAnyIntRange(Node location, Object arrayA, int offsetA, int stride, int fromIndex, int toIndex, int[] ranges) {
        return TStringOps.indexOfAnyIntRangeIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, ranges);
    }

    private static int indexOfAnyIntRangeIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int[] ranges) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        if (stride == 0) {
            if (ranges.length == 2) {
                return TStringOps.runIndexOfRange1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, ranges[0], ranges[1]);
            }
            if (ranges.length == 4) {
                return TStringOps.runIndexOfRange2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
            }
        } else if (stride == 1) {
            if (ranges.length == 2) {
                return TStringOps.runIndexOfRange1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, ranges[0], ranges[1]);
            }
            if (ranges.length == 4) {
                return TStringOps.runIndexOfRange2(location, stubArray, stubOffset, length, 1, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
            }
        } else {
            assert (stride == 2);
            if (ranges.length == 2) {
                return TStringOps.runIndexOfRange1(location, stubArray, stubOffset, length, 2, isNative, fromIndex, ranges[0], ranges[1]);
            }
            if (ranges.length == 4) {
                return TStringOps.runIndexOfRange2(location, stubArray, stubOffset, length, 2, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
            }
        }
        return TStringOps.runIndexOfAnyIntRange(location, stubArray, stubOffset, length, stride, fromIndex, ranges);
    }

    static int indexOfTable(Node location, Object arrayA, int offsetA, int stride, int fromIndex, int toIndex, byte[] tables) {
        return TStringOps.indexOfTableIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, tables);
    }

    private static int indexOfTableIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, byte[] tables) {
        long stubOffset;
        byte[] stubArray;
        assert (tables.length == 32);
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        if (stride == 0) {
            return TStringOps.runIndexOfTable(location, stubArray, stubOffset, length, 0, isNative, fromIndex, tables);
        }
        if (stride == 1) {
            return TStringOps.runIndexOfTable(location, stubArray, stubOffset, length, 1, isNative, fromIndex, tables);
        }
        assert (stride == 2);
        return TStringOps.runIndexOfTable(location, stubArray, stubOffset, length, 2, isNative, fromIndex, tables);
    }

    static int indexOfCodePointWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, int fromIndex, int toIndex, int codepoint) {
        return TStringOps.indexOfCodePointWithStrideIntl(location, arrayA, a2.offset(), toIndex, strideA, fromIndex, codepoint);
    }

    private static int indexOfCodePointWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        switch (stride) {
            case 0: {
                return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1);
            }
            case 1: {
                return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1);
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1);
    }

    static int indexOfCodePointWithOrMaskWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, int fromIndex, int toIndex, int codepoint, int maskA) {
        return TStringOps.indexOfCodePointWithMaskWithStrideIntl(location, arrayA, a2.offset(), toIndex, strideA, fromIndex, codepoint, maskA);
    }

    static int indexOfCodePointWithMaskWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1, int mask1) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        switch (stride) {
            case 0: {
                return (v1 ^ mask1) <= 255 ? TStringOps.runIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1, mask1) : -1;
            }
            case 1: {
                return (v1 ^ mask1) <= 65535 ? TStringOps.runIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1, mask1) : -1;
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1, mask1);
    }

    static int indexOf2ConsecutiveWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, int fromIndex, int toIndex, int v1, int v2) {
        return TStringOps.indexOf2ConsecutiveWithStrideIntl(location, arrayA, a2.offset(), toIndex, strideA, fromIndex, v1, v2);
    }

    private static int indexOf2ConsecutiveWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1, int v2) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        switch (stride) {
            case 0: {
                return (v1 | v2) <= 255 ? TStringOps.runIndexOf2ConsecutiveWithStride(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1, v2) : -1;
            }
            case 1: {
                return (v1 | v2) <= 65535 ? TStringOps.runIndexOf2ConsecutiveWithStride(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1, v2) : -1;
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOf2ConsecutiveWithStride(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1, v2);
    }

    private static int indexOf2ConsecutiveWithOrMaskWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1, int v2, int mask1, int mask2) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
        switch (stride) {
            case 0: {
                return (v1 ^ mask1 | v2 ^ mask2) <= 255 ? TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1, v2, mask1, mask2) : -1;
            }
            case 1: {
                return (v1 ^ mask1 | v2 ^ mask2) <= 65535 ? TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1, v2, mask1, mask2) : -1;
            }
        }
        assert (stride == 2);
        return TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1, v2, mask1, mask2);
    }

    static int indexOfStringWithOrMaskWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, AbstractTruffleString b2, Object arrayB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        return TStringOps.indexOfStringWithOrMaskWithStride(location, arrayA, a2.offset(), a2.length(), strideA, arrayB, b2.offset(), b2.length(), strideB, fromIndex, toIndex, maskB);
    }

    static int indexOfStringWithOrMaskWithStride(Node location, Object arrayA, int offsetA, int lengthA, int strideA, Object arrayB, int offsetB, int lengthB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        int mask1;
        int offsetMask = 0;
        assert (lengthB > 1);
        assert (lengthA >= lengthB);
        int max = toIndex - (lengthB - 2);
        int index = fromIndex;
        int b0 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 0);
        int b1 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 1);
        int mask0 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, 0);
        int n2 = mask1 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, 1);
        while (index < max - 1) {
            index = maskB == null ? TStringOps.indexOf2ConsecutiveWithStrideIntl(location, arrayA, offsetA, max, strideA, index, b0, b1) : TStringOps.indexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, offsetA, max, strideA, index, b0, b1, mask0, mask1);
            if (index < 0) {
                return -1;
            }
            if (lengthB == 2 || TStringOps.regionEqualsWithOrMaskWithStrideIntl(location, arrayA, offsetA, lengthA, strideA, index, arrayB, offsetB, lengthB, strideB, 0, maskB, lengthB)) {
                return index;
            }
            TStringConstants.truffleSafePointPoll(location, ++index);
        }
        return -1;
    }

    static int lastIndexOfCodePointWithOrMaskWithStride(Node location, AbstractTruffleString a2, Object arrayA, int stride, int fromIndex, int toIndex, int codepoint, int mask) {
        return TStringOps.lastIndexOfCodePointWithOrMaskWithStrideIntl(location, arrayA, a2.offset(), stride, fromIndex, toIndex, codepoint, mask);
    }

    private static int lastIndexOfCodePointWithOrMaskWithStrideIntl(Node location, Object array, int offset, int stride, int fromIndex, int toIndex, int codepoint, int mask) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, fromIndex, stride, toIndex);
        switch (stride) {
            case 0: {
                return TStringOps.runLastIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, 0, fromIndex, toIndex, codepoint, mask);
            }
            case 1: {
                return TStringOps.runLastIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, 1, fromIndex, toIndex, codepoint, mask);
            }
        }
        assert (stride == 2);
        return TStringOps.runLastIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, 2, fromIndex, toIndex, codepoint, mask);
    }

    static int lastIndexOf2ConsecutiveWithOrMaskWithStride(Node location, AbstractTruffleString a2, Object arrayA, int stride, int fromIndex, int toIndex, int v1, int v2, int mask1, int mask2) {
        return TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, a2.offset(), stride, fromIndex, toIndex, v1, v2, mask1, mask2);
    }

    private static int lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(Node location, Object array, int offset, int stride, int fromIndex, int toIndex, int v1, int v2, int mask1, int mask2) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegionIndex(stubArray, offset, fromIndex, stride, toIndex);
        switch (stride) {
            case 0: {
                return TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, 0, fromIndex, toIndex, v1, v2, mask1, mask2);
            }
            case 1: {
                return TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, 1, fromIndex, toIndex, v1, v2, mask1, mask2);
            }
        }
        assert (stride == 2);
        return TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, 2, fromIndex, toIndex, v1, v2, mask1, mask2);
    }

    static int lastIndexOfStringWithOrMaskWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, AbstractTruffleString b2, Object arrayB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        int offsetMask = 0;
        assert (b2.length() > 1);
        assert (a2.length() >= b2.length());
        int index = fromIndex;
        int b0 = TStringOps.readValue(b2, arrayB, strideB, b2.length() - 2);
        int b1 = TStringOps.readValue(b2, arrayB, strideB, b2.length() - 1);
        int mask0 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, b2.length(), strideB, b2.length() - 2);
        int mask1 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, b2.length(), strideB, b2.length() - 1);
        int toIndex2Consecutive = toIndex + b2.length() - 2;
        while (index > toIndex2Consecutive) {
            index = TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, a2.offset(), strideA, index, toIndex2Consecutive, b0, b1, mask0, mask1);
            if (index < 0) {
                return -1;
            }
            if (b2.length() == 2 || TStringOps.regionEqualsWithOrMaskWithStride(location, a2, arrayA, strideA, (index += 2) - b2.length(), b2, arrayB, strideB, 0, maskB, b2.length())) {
                return index - b2.length();
            }
            TStringConstants.truffleSafePointPoll(location, --index);
        }
        return -1;
    }

    static boolean regionEqualsWithOrMaskWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, int fromIndexA, AbstractTruffleString b2, Object arrayB, int strideB, int fromIndexB, byte[] maskB, int lengthCMP) {
        return TStringOps.regionEqualsWithOrMaskWithStrideIntl(location, arrayA, a2.offset(), a2.length(), strideA, fromIndexA, arrayB, b2.offset(), b2.length(), strideB, fromIndexB, maskB, lengthCMP);
    }

    private static boolean regionEqualsWithOrMaskWithStrideIntl(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int fromIndexA, Object arrayB, int offsetB, int lengthB, int strideB, int fromIndexB, byte[] maskB, int lengthCMP) {
        long stubOffsetB;
        byte[] stubArrayB;
        long stubOffsetA;
        byte[] stubArrayA;
        if (!TStringOps.rangeInBounds(fromIndexA, lengthCMP, lengthA) || !TStringOps.rangeInBounds(fromIndexB, lengthCMP, lengthB)) {
            return false;
        }
        boolean isNativeA = TStringOps.isNativePointer(arrayA);
        if (isNativeA) {
            stubArrayA = null;
            stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA) + (long)(fromIndexA << strideA);
        } else {
            stubArrayA = (byte[])arrayA;
            stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexA << strideA);
        }
        boolean isNativeB = TStringOps.isNativePointer(arrayB);
        if (isNativeB) {
            stubArrayB = null;
            stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB) + (long)(fromIndexB << strideB);
        } else {
            stubArrayB = (byte[])arrayB;
            stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexB << strideB);
        }
        TStringOps.validateRegion(stubArrayA, offsetA, lengthCMP, strideA);
        TStringOps.validateRegion(stubArrayB, offsetB, lengthCMP, strideB);
        int stubStride = TStringOps.stubStride(strideA, strideB);
        if (maskB == null) {
            return TStringOps.runRegionEqualsWithStride(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCMP, stubStride);
        }
        TStringOps.validateRegion(maskB, 0, lengthCMP, strideB);
        return TStringOps.runRegionEqualsWithOrMaskWithStride(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, maskB, lengthCMP, stubStride);
    }

    static int memcmpWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, AbstractTruffleString b2, Object arrayB, int strideB, int lengthCMP) {
        assert (lengthCMP <= a2.length());
        assert (lengthCMP <= b2.length());
        return TStringOps.memcmpWithStrideIntl(location, arrayA, a2.offset(), strideA, arrayB, b2.offset(), strideB, lengthCMP);
    }

    private static int memcmpWithStrideIntl(Node location, Object arrayA, int offsetA, int strideA, Object arrayB, int offsetB, int strideB, int lengthCMP) {
        long stubOffsetB;
        byte[] stubArrayB;
        long stubOffsetA;
        byte[] stubArrayA;
        if (lengthCMP == 0) {
            return 0;
        }
        boolean isNativeA = TStringOps.isNativePointer(arrayA);
        if (isNativeA) {
            stubArrayA = null;
            stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA);
        } else {
            stubArrayA = (byte[])arrayA;
            stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        boolean isNativeB = TStringOps.isNativePointer(arrayB);
        if (isNativeB) {
            stubArrayB = null;
            stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB);
        } else {
            stubArrayB = (byte[])arrayB;
            stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArrayA, offsetA, lengthCMP, strideA);
        TStringOps.validateRegion(stubArrayB, offsetB, lengthCMP, strideB);
        return TStringOps.runMemCmp(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCMP, TStringOps.stubStride(strideA, strideB));
    }

    static int memcmpBytesWithStride(Node location, AbstractTruffleString a2, Object arrayA, int strideA, AbstractTruffleString b2, Object arrayB, int strideB, int lengthCMP) {
        assert (lengthCMP <= a2.length());
        assert (lengthCMP <= b2.length());
        return TStringOps.memcmpBytesWithStrideIntl(location, arrayA, a2.offset(), strideA, arrayB, b2.offset(), strideB, lengthCMP);
    }

    private static int memcmpBytesWithStrideIntl(Node location, Object arrayA, int offsetA, int strideA, Object arrayB, int offsetB, int strideB, int lengthCMP) {
        int swappedResult;
        boolean swappedIsNativeB;
        boolean swappedIsNativeA;
        long swappedOffsetB;
        long swappedOffsetA;
        byte[] swappedArrayB;
        byte[] swappedArrayA;
        int swappedStrideB;
        int swappedStrideA;
        long stubOffsetB;
        byte[] stubArrayB;
        long stubOffsetA;
        byte[] stubArrayA;
        if (lengthCMP == 0) {
            return 0;
        }
        boolean isNativeA = TStringOps.isNativePointer(arrayA);
        if (isNativeA) {
            stubArrayA = null;
            stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA);
        } else {
            stubArrayA = (byte[])arrayA;
            stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        boolean isNativeB = TStringOps.isNativePointer(arrayB);
        if (isNativeB) {
            stubArrayB = null;
            stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB);
        } else {
            stubArrayB = (byte[])arrayB;
            stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArrayA, offsetA, lengthCMP, strideA);
        TStringOps.validateRegion(stubArrayB, offsetB, lengthCMP, strideB);
        if (strideA == strideB) {
            switch (strideA) {
                case 0: {
                    return TStringOps.runMemCmp(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCMP, 0);
                }
                case 1: {
                    return TStringOps.runMemCmpBytes(location, stubArrayA, stubOffsetA, 1, isNativeA, stubArrayB, stubOffsetB, 1, isNativeB, lengthCMP);
                }
            }
            assert (strideA == 2);
            return TStringOps.runMemCmpBytes(location, stubArrayA, stubOffsetA, 2, isNativeA, stubArrayB, stubOffsetB, 2, isNativeB, lengthCMP);
        }
        if (strideA < strideB) {
            swappedStrideA = strideB;
            swappedStrideB = strideA;
            swappedArrayA = stubArrayB;
            swappedArrayB = stubArrayA;
            swappedOffsetA = stubOffsetB;
            swappedOffsetB = stubOffsetA;
            swappedIsNativeA = isNativeB;
            swappedIsNativeB = isNativeA;
            swappedResult = -1;
        } else {
            swappedStrideA = strideA;
            swappedStrideB = strideB;
            swappedArrayA = stubArrayA;
            swappedArrayB = stubArrayB;
            swappedOffsetA = stubOffsetA;
            swappedOffsetB = stubOffsetB;
            swappedIsNativeA = isNativeA;
            swappedIsNativeB = isNativeB;
            swappedResult = 1;
        }
        if (swappedStrideA == 1) {
            assert (swappedStrideB == 0);
            return swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 1, swappedIsNativeA, swappedArrayB, swappedOffsetB, 0, swappedIsNativeB, lengthCMP);
        }
        assert (swappedStrideA == 2);
        if (swappedStrideB == 0) {
            return swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 2, swappedIsNativeA, swappedArrayB, swappedOffsetB, 0, swappedIsNativeB, lengthCMP);
        }
        assert (swappedStrideB == 1);
        return swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 2, swappedIsNativeA, swappedArrayB, swappedOffsetB, 1, swappedIsNativeB, lengthCMP);
    }

    static int hashCodeWithStride(Node location, AbstractTruffleString a2, Object arrayA, int stride) {
        int offset = a2.offset();
        int length = a2.length();
        return TStringOps.hashCodeWithStrideIntl(location, arrayA, offset, length, stride);
    }

    private static int hashCodeWithStrideIntl(Node location, Object array, int offset, int length, int stride) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, stride);
        switch (stride) {
            case 0: {
                return TStringOps.runHashCode(location, stubArray, stubOffset, length, 0, isNative);
            }
            case 1: {
                return TStringOps.runHashCode(location, stubArray, stubOffset, length, 1, isNative);
            }
        }
        assert (stride == 2);
        return TStringOps.runHashCode(location, stubArray, stubOffset, length, 2, isNative);
    }

    static Object arraycopyWithStrideCB(Node location, char[] arrayA, int offsetA, byte[] arrayB, int offsetB, int strideB, int lengthCPY) {
        TStringOps.validateRegion(arrayA, offsetA, lengthCPY);
        TStringOps.validateRegion(arrayB, offsetB, lengthCPY, strideB);
        int stubOffsetA = Unsafe.ARRAY_CHAR_BASE_OFFSET + offsetA;
        int stubOffsetB = Unsafe.ARRAY_BYTE_BASE_OFFSET + offsetB;
        TStringOps.runArrayCopy(location, arrayA, (long)stubOffsetA, arrayB, (long)stubOffsetB, lengthCPY, TStringOps.stubStride(1, strideB));
        return arrayB;
    }

    static Object arraycopyWithStrideIB(Node location, int[] arrayA, int offsetA, byte[] arrayB, int offsetB, int strideB, int lengthCPY) {
        TStringOps.validateRegion(arrayA, offsetA, lengthCPY);
        TStringOps.validateRegion(arrayB, offsetB, lengthCPY, strideB);
        int stubOffsetA = Unsafe.ARRAY_INT_BASE_OFFSET + offsetA;
        int stubOffsetB = Unsafe.ARRAY_BYTE_BASE_OFFSET + offsetB;
        TStringOps.runArrayCopy(location, arrayA, (long)stubOffsetA, arrayB, (long)stubOffsetB, lengthCPY, TStringOps.stubStride(2, strideB));
        return arrayB;
    }

    static Object arraycopyWithStride(Node location, Object arrayA, int offsetA, int strideA, int fromIndexA, Object arrayB, int offsetB, int strideB, int fromIndexB, int lengthCPY) {
        long stubOffsetB;
        byte[] stubArrayB;
        long stubOffsetA;
        byte[] stubArrayA;
        boolean isNativeA = TStringOps.isNativePointer(arrayA);
        if (isNativeA) {
            stubArrayA = null;
            stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA) + (long)(fromIndexA << strideA);
        } else {
            stubArrayA = (byte[])arrayA;
            stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexA << strideA);
        }
        boolean isNativeB = TStringOps.isNativePointer(arrayB);
        if (isNativeB) {
            stubArrayB = null;
            stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB) + (long)(fromIndexB << strideB);
        } else {
            stubArrayB = (byte[])arrayB;
            stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexB << strideB);
        }
        TStringOps.validateRegion(stubArrayA, offsetA, lengthCPY, strideA);
        TStringOps.validateRegion(stubArrayB, offsetB, lengthCPY, strideB);
        TStringOps.runArrayCopy(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCPY, TStringOps.stubStride(strideA, strideB));
        return stubArrayB;
    }

    static byte[] arraycopyOfWithStride(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int lengthB, int strideB) {
        byte[] dst = new byte[lengthB << strideB];
        TStringOps.arraycopyWithStride(location, arrayA, offsetA, strideA, 0, dst, 0, strideB, 0, lengthA);
        return dst;
    }

    static int calcStringAttributesLatin1(Node location, Object array, int offset, int length) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 0);
        return TStringOps.runCalcStringAttributesLatin1(location, stubArray, stubOffset, length, isNative);
    }

    static int calcStringAttributesBMP(Node location, Object array, int offset, int length) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 1);
        return TStringOps.runCalcStringAttributesBMP(location, stubArray, stubOffset, length, isNative);
    }

    static long calcStringAttributesUTF8(Node location, Object array, int offset, int length, boolean assumeValid, boolean isAtEnd, InlinedConditionProfile brokenProfile) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 0);
        if (assumeValid && !Encodings.isUTF8ContinuationByte(TStringOps.readS0(array, offset, length, 0)) && (isAtEnd || !Encodings.isUTF8ContinuationByte(TStringOps.readS0(array, offset, length + 1, length)))) {
            return TStringOps.runCalcStringAttributesUTF8(location, stubArray, stubOffset, length, isNative, true);
        }
        long attrs = TStringOps.runCalcStringAttributesUTF8(location, stubArray, stubOffset, length, isNative, false);
        if (brokenProfile.profile(location, TStringGuards.isBrokenMultiByte(StringAttributes.getCodeRange(attrs)))) {
            int codePointLength = 0;
            for (int i2 = 0; i2 < length; i2 += Encodings.utf8GetCodePointLength(array, offset, length, i2, DecodingErrorHandler.DEFAULT)) {
                TStringConstants.truffleSafePointPoll(location, ++codePointLength);
            }
            return StringAttributes.create(codePointLength, StringAttributes.getCodeRange(attrs));
        }
        return attrs;
    }

    static long calcStringAttributesUTF16C(Node location, char[] array, int offset, int length) {
        TStringOps.validateRegion(array, offset, length);
        int stubOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET + offset;
        return TStringOps.runCalcStringAttributesUTF16C(location, array, stubOffset, length);
    }

    static long calcStringAttributesUTF16(Node location, Object array, int offset, int length, boolean assumeValid) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 1);
        long attrs = assumeValid ? TStringOps.runCalcStringAttributesUTF16(location, stubArray, stubOffset, length, isNative, true) : TStringOps.runCalcStringAttributesUTF16(location, stubArray, stubOffset, length, isNative, false);
        if (assumeValid && length > 0) {
            if (Encodings.isUTF16LowSurrogate(TStringOps.readS1(array, offset, length, 0))) {
                attrs = StringAttributes.create(StringAttributes.getCodePointLength(attrs), TSCodeRange.getBrokenMultiByte());
            }
            if (Encodings.isUTF16HighSurrogate(TStringOps.readS1(array, offset, length, length - 1))) {
                attrs = StringAttributes.create(StringAttributes.getCodePointLength(attrs) + 1, TSCodeRange.getBrokenMultiByte());
            }
        }
        return attrs;
    }

    static int calcStringAttributesUTF32I(Node location, int[] array, int offset, int length) {
        TStringOps.validateRegion(array, offset, length);
        int stubOffset = Unsafe.ARRAY_INT_BASE_OFFSET + offset;
        return TStringOps.runCalcStringAttributesUTF32I(location, array, stubOffset, length);
    }

    static int calcStringAttributesUTF32(Node location, Object array, int offset, int length) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 2);
        return TStringOps.runCalcStringAttributesUTF32(location, stubArray, stubOffset, length, isNative);
    }

    static int codePointIndexToByteIndexUTF8Valid(Node location, Object array, int offset, int length, int index) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 0);
        return TStringOps.runCodePointIndexToByteIndexUTF8Valid(location, stubArray, stubOffset, length, index, isNative);
    }

    static int codePointIndexToByteIndexUTF16Valid(Node location, Object array, int offset, int length, int index) {
        long stubOffset;
        byte[] stubArray;
        boolean isNative = TStringOps.isNativePointer(array);
        if (isNative) {
            stubArray = null;
            stubOffset = (long)offset + TStringOps.nativePointer(array);
        } else {
            stubArray = (byte[])array;
            stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        TStringOps.validateRegion(stubArray, offset, length, 1);
        return TStringOps.runCodePointIndexToByteIndexUTF16Valid(location, stubArray, stubOffset, length, index, isNative);
    }

    private static int runReadS0Managed(byte[] array, long byteOffset) {
        return TStringOps.uInt(TStringUnsafe.getByteManaged(array, byteOffset));
    }

    private static int runReadS1Managed(byte[] array, long byteOffset) {
        return TStringUnsafe.getCharManaged(array, byteOffset);
    }

    private static int runReadS2Managed(byte[] array, long byteOffset) {
        return TStringUnsafe.getIntManaged(array, byteOffset);
    }

    private static long runReadS3Managed(byte[] array, long byteOffset) {
        return TStringUnsafe.getLongManaged(array, byteOffset);
    }

    private static void runWriteS0Managed(byte[] array, long byteOffset, byte value) {
        TStringUnsafe.putByteManaged(array, byteOffset, value);
    }

    private static void runWriteS1Managed(byte[] array, long byteOffset, char value) {
        TStringUnsafe.putCharManaged(array, byteOffset, value);
    }

    private static void runWriteS2Managed(byte[] array, long byteOffset, int value) {
        TStringUnsafe.putIntManaged(array, byteOffset, value);
    }

    private static int runIndexOfAnyByte(Node location, byte[] array, long offset, int length, int fromIndex, byte ... needle) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, 0, i2);
            for (int j2 = 0; j2 < needle.length; ++j2) {
                if (value == TStringOps.uInt(needle[j2])) {
                    return i2;
                }
                TStringConstants.truffleSafePointPoll(location, j2 + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyChar(Node location, byte[] array, long offset, int length, int stride, int fromIndex, char ... needle) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, stride, i2);
            for (int j2 = 0; j2 < needle.length; ++j2) {
                if (value == needle[j2]) {
                    return i2;
                }
                TStringConstants.truffleSafePointPoll(location, j2 + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyInt(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int ... needle) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, stride, i2);
            for (int j2 = 0; j2 < needle.length; ++j2) {
                if (value == needle[j2]) {
                    return i2;
                }
                TStringConstants.truffleSafePointPoll(location, j2 + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyIntRange(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int ... ranges) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            for (int j2 = 0; j2 < ranges.length; j2 += 2) {
                if (TStringOps.inRange(ranges[j2], ranges[j2 + 1], TStringOps.readValue(array, offset, stride, i2))) {
                    return i2;
                }
                TStringConstants.truffleSafePointPoll(location, j2 + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static boolean inRange(int lo, int hi, int v2) {
        return Integer.compareUnsigned(lo, v2) <= 0 && Integer.compareUnsigned(v2, hi) <= 0;
    }

    private static int runIndexOfAny1(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            if (TStringOps.readValue(array, offset, stride, i2) == v0) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfAny2(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, stride, i2);
            if (value == v0 || value == v1) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfAny3(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, stride, i2);
            if (value == v0 || value == v1 || value == v2) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfAny4(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2, int v3) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, stride, i2);
            if (value == v0 || value == v1 || value == v2 || value == v3) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfRange1(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            if (TStringOps.inRange(v0, v1, TStringOps.readValue(array, offset, stride, i2))) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfRange2(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2, int v3) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, stride, i2);
            if (TStringOps.inRange(v0, v1, value) || TStringOps.inRange(v2, v3, value)) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runIndexOfTable(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, byte[] tables) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            int value = TStringOps.readValue(array, offset, stride, i2);
            if (value <= 255 && TStringOps.performTableLookup(tables, value)) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static boolean performTableLookup(byte[] tables, int value) {
        int tableLo;
        int tableHi = TStringOps.uInt(tables[value >>> 4 & 0xF]);
        return (tableHi & (tableLo = TStringOps.uInt(tables[16 + (value & 0xF)]))) != 0;
    }

    private static int runIndexOfWithOrMaskWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int needle, int mask) {
        for (int i2 = fromIndex; i2 < length; ++i2) {
            if ((TStringOps.readValue(array, offset, stride, i2) | mask) == needle) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return -1;
    }

    private static int runLastIndexOfWithOrMaskWithStride(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int needle, int mask) {
        for (int i2 = fromIndex - 1; i2 >= toIndex; --i2) {
            if ((TStringOps.readValue(array, offset, stride, i2) | mask) == needle) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2);
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int c1, int c2) {
        for (int i2 = fromIndex + 1; i2 < length; ++i2) {
            if (TStringOps.readValue(array, offset, stride, i2 - 1) == c1 && TStringOps.readValue(array, offset, stride, i2) == c2) {
                return i2 - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i2);
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithOrMaskWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int c1, int c2, int mask1, int mask2) {
        for (int i2 = fromIndex + 1; i2 < length; ++i2) {
            if ((TStringOps.readValue(array, offset, stride, i2 - 1) | mask1) == c1 && (TStringOps.readValue(array, offset, stride, i2) | mask2) == c2) {
                return i2 - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i2);
        }
        return -1;
    }

    private static int runLastIndexOf2ConsecutiveWithOrMaskWithStride(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int c1, int c2, int mask1, int mask2) {
        for (int i2 = fromIndex - 1; i2 > toIndex; --i2) {
            if ((TStringOps.readValue(array, offset, stride, i2 - 1) | mask1) == c1 && (TStringOps.readValue(array, offset, stride, i2) | mask2) == c2) {
                return i2 - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i2);
        }
        return -1;
    }

    private static boolean runRegionEqualsWithStride(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int length, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i2 = 0; i2 < length; ++i2) {
            if (TStringOps.readValue(arrayA, offsetA, strideA, i2) != TStringOps.readValue(arrayB, offsetB, strideB, i2)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return true;
    }

    private static boolean runRegionEqualsWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, byte[] arrayMask, int lengthCMP, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i2 = 0; i2 < lengthCMP; ++i2) {
            if ((TStringOps.readValue(arrayA, offsetA, strideA, i2) | TStringOps.readFromByteArray(arrayMask, strideB, i2)) != TStringOps.readValue(arrayB, offsetB, strideB, i2)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return true;
    }

    private static int runMemCmp(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int lengthCMP, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i2 = 0; i2 < lengthCMP; ++i2) {
            int cmp = TStringOps.readValue(arrayA, offsetA, strideA, i2) - TStringOps.readValue(arrayB, offsetB, strideB, i2);
            if (cmp != 0) {
                return cmp;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return 0;
    }

    private static int runMemCmpBytes(Node location, byte[] arrayA, long offsetA, int strideA, boolean isNativeA, byte[] arrayB, long offsetB, int strideB, boolean isNativeB, int lengthCMP) {
        assert (strideA >= strideB);
        for (int i2 = 0; i2 < lengthCMP; ++i2) {
            int valueA = TStringOps.readValue(arrayA, offsetA, strideA, i2);
            int valueB = TStringOps.readValue(arrayB, offsetB, strideB, i2);
            for (int j2 = 0; j2 < 4; ++j2) {
                int cmp;
                if (TStringGuards.littleEndian()) {
                    cmp = (valueA & 0xFF) - (valueB & 0xFF);
                    valueA >>= 8;
                    valueB >>= 8;
                } else {
                    cmp = (valueA >> 24 & 0xFF) - (valueB >> 24 & 0xFF);
                    valueA <<= 8;
                    valueB <<= 8;
                }
                if (cmp == 0) continue;
                return cmp;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return 0;
    }

    private static int runHashCode(Node location, byte[] array, long offset, int length, int stride, boolean isNative) {
        int hash = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            hash = 31 * hash + TStringOps.readValue(array, offset, stride, i2);
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return hash;
    }

    private static void runArrayCopy(Node location, char[] stubArrayA, long stubOffsetA, byte[] stubArrayB, long stubOffsetB, int lengthCPY, int stubStride) {
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        int offsetA = (int)(stubOffsetA - (long)Unsafe.ARRAY_CHAR_BASE_OFFSET >> 1);
        for (int i2 = 0; i2 < lengthCPY; ++i2) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, strideB, i2, stubArrayA[offsetA + i2]);
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
    }

    private static void runArrayCopy(Node location, int[] stubArrayA, long stubOffsetA, byte[] stubArrayB, long stubOffsetB, int lengthCPY, int stubStride) {
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        int offsetA = (int)(stubOffsetA - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2);
        for (int i2 = 0; i2 < lengthCPY; ++i2) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, strideB, i2, stubArrayA[offsetA + i2]);
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
    }

    private static void runArrayCopy(Node location, byte[] stubArrayA, long stubOffsetA, boolean isNativeA, byte[] stubArrayB, long stubOffsetB, boolean isNativeB, int lengthCPY, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i2 = 0; i2 < lengthCPY; ++i2) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, strideB, i2, TStringOps.readValue(stubArrayA, stubOffsetA, strideA, i2));
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
    }

    private static int runCalcStringAttributesLatin1(Node location, byte[] array, long offset, int length, boolean isNative) {
        for (int i2 = 0; i2 < length; ++i2) {
            if (TStringOps.readValueS0(array, offset, i2) > 127) {
                return TSCodeRange.get8Bit();
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return TSCodeRange.get7Bit();
    }

    private static int runCalcStringAttributesBMP(Node location, byte[] array, long offset, int length, boolean isNative) {
        int i2;
        int codeRange = TSCodeRange.get7Bit();
        for (i2 = 0; i2 < length; ++i2) {
            if (TStringOps.readValueS1(array, offset, i2) > 127) {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return TSCodeRange.get7Bit();
        }
        while (i2 < length) {
            if (TStringOps.readValueS1(array, offset, i2) > 255) {
                return TSCodeRange.get16Bit();
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        return TSCodeRange.get8Bit();
    }

    private static int runCalcStringAttributesUTF32I(Node location, int[] array, long offset, int length) {
        return TStringOps.runCalcStringAttributesUTF32AnyArray(location, array, offset, length);
    }

    private static int runCalcStringAttributesUTF32(Node location, byte[] array, long offset, int length, boolean isNative) {
        return TStringOps.runCalcStringAttributesUTF32AnyArray(location, array, offset, length);
    }

    private static int readValueS2I(Object array, long offset, int i2) {
        if (array instanceof int[]) {
            return ((int[])array)[(int)(offset - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2) + i2];
        }
        return TStringOps.readValueS2((byte[])array, offset, i2);
    }

    private static int runCalcStringAttributesUTF32AnyArray(Node location, Object array, long offset, int length) {
        int value;
        int i2;
        int codeRange = TSCodeRange.get7Bit();
        for (i2 = 0; i2 < length; ++i2) {
            if (Integer.toUnsignedLong(TStringOps.readValueS2I(array, offset, i2)) > 127L) {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return TSCodeRange.get7Bit();
        }
        while (i2 < length) {
            if (Integer.toUnsignedLong(TStringOps.readValueS2I(array, offset, i2)) > 255L) {
                codeRange = TSCodeRange.get16Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        if (!TSCodeRange.is16Bit(codeRange)) {
            return TSCodeRange.get8Bit();
        }
        while (i2 < length) {
            value = TStringOps.readValueS2I(array, offset, i2);
            if (Integer.toUnsignedLong(value) > 65535L) {
                codeRange = TSCodeRange.getValidFixedWidth();
                break;
            }
            if (Encodings.isUTF16Surrogate(value)) {
                return TSCodeRange.getBrokenFixedWidth();
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        if (!TSCodeRange.isValid(codeRange)) {
            return TSCodeRange.get16Bit();
        }
        while (i2 < length) {
            value = TStringOps.readValueS2I(array, offset, i2);
            if (Integer.toUnsignedLong(value) > 0x10FFFFL || Encodings.isUTF16Surrogate(value)) {
                return TSCodeRange.getBrokenFixedWidth();
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        return TSCodeRange.getValidFixedWidth();
    }

    private static long runCalcStringAttributesUTF8(Node location, byte[] array, long offset, int length, boolean isNative, boolean assumeValid) {
        int i2;
        int codeRange = TSCodeRange.get7Bit();
        for (i2 = 0; i2 < length; ++i2) {
            if (TStringOps.readValueS0(array, offset, i2) > 127) {
                codeRange = TSCodeRange.getValidMultiByte();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        if (!TSCodeRange.isValidMultiByte(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }
        int nCodePoints = i2;
        if (assumeValid) {
            while (i2 < length) {
                if (!Encodings.isUTF8ContinuationByte(TStringOps.readValueS0(array, offset, i2))) {
                    ++nCodePoints;
                }
                TStringConstants.truffleSafePointPoll(location, i2 + 1);
                ++i2;
            }
            return StringAttributes.create(nCodePoints, TSCodeRange.getValidMultiByte());
        }
        int state = 0;
        while (i2 < length) {
            int b2 = TStringOps.readValueS0(array, offset, i2);
            if (!Encodings.isUTF8ContinuationByte(b2)) {
                ++nCodePoints;
            }
            byte type = Encodings.UTF_8_STATE_MACHINE[b2];
            state = Encodings.UTF_8_STATE_MACHINE[256 + state + type];
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        if (state != 0) {
            codeRange = TSCodeRange.getBrokenMultiByte();
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static long runCalcStringAttributesUTF16C(Node location, char[] array, long offset, int length) {
        return TStringOps.runCalcStringAttributesUTF16AnyArray(location, array, offset, length, false);
    }

    private static long runCalcStringAttributesUTF16(Node location, byte[] array, long offset, int length, boolean isNative, boolean assumeValid) {
        return TStringOps.runCalcStringAttributesUTF16AnyArray(location, array, offset, length, assumeValid);
    }

    private static char readValueS1C(Object array, long offset, int i2) {
        if (array instanceof char[]) {
            return ((char[])array)[(int)(offset - (long)Unsafe.ARRAY_CHAR_BASE_OFFSET >> 1) + i2];
        }
        return (char)TStringOps.readValueS1((byte[])array, offset, i2);
    }

    private static long runCalcStringAttributesUTF16AnyArray(Node location, Object array, long offset, int length, boolean assumeValid) {
        int i2;
        int codeRange = TSCodeRange.get7Bit();
        for (i2 = 0; i2 < length; ++i2) {
            if (TStringOps.readValueS1C(array, offset, i2) > '\u007f') {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }
        while (i2 < length) {
            if (TStringOps.readValueS1C(array, offset, i2) > '\u00ff') {
                codeRange = TSCodeRange.get16Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        if (!TSCodeRange.is16Bit(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get8Bit());
        }
        while (i2 < length) {
            char c2 = TStringOps.readValueS1C(array, offset, i2);
            if (assumeValid ? Encodings.isUTF16HighSurrogate(c2) : Encodings.isUTF16Surrogate(c2)) {
                codeRange = TSCodeRange.getValidMultiByte();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        if (!TSCodeRange.isValidMultiByte(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get16Bit());
        }
        int nCodePoints = length;
        if (assumeValid) {
            while (i2 < length) {
                if (Encodings.isUTF16HighSurrogate(TStringOps.readValueS1C(array, offset, i2))) {
                    --nCodePoints;
                }
                TStringConstants.truffleSafePointPoll(location, i2 + 1);
                ++i2;
            }
            return StringAttributes.create(nCodePoints, TSCodeRange.getValidMultiByte());
        }
        while (i2 < length) {
            char c3 = TStringOps.readValueS1C(array, offset, i2);
            if (Encodings.isUTF16Surrogate(c3)) {
                if (Encodings.isUTF16LowSurrogate(c3) || i2 + 1 >= length || !Encodings.isUTF16LowSurrogate(TStringOps.readValueS1C(array, offset, i2 + 1))) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    ++i2;
                    --nCodePoints;
                }
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
            ++i2;
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static int runCodePointIndexToByteIndexUTF8Valid(Node location, byte[] array, long offset, int length, int index, boolean isNative) {
        int cpi = index;
        for (int i2 = 0; i2 < length; ++i2) {
            if (!Encodings.isUTF8ContinuationByte(TStringOps.readValueS0(array, offset, i2)) && --cpi < 0) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return cpi == 0 ? length : -1;
    }

    private static int runCodePointIndexToByteIndexUTF16Valid(Node location, byte[] array, long offset, int length, int index, boolean isNative) {
        int cpi = index;
        for (int i2 = 0; i2 < length; ++i2) {
            if (!Encodings.isUTF16LowSurrogate(TStringOps.readValueS1(array, offset, i2)) && --cpi < 0) {
                return i2;
            }
            TStringConstants.truffleSafePointPoll(location, i2 + 1);
        }
        return cpi == 0 ? length : -1;
    }

    static long byteLength(Object array) {
        CompilerAsserts.neverPartOfCompilation();
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private static boolean rangeInBounds(int rangeStart, int rangeLength, int arrayLength) {
        return Integer.toUnsignedLong(rangeStart) + Integer.toUnsignedLong(rangeLength) <= (long)arrayLength;
    }

    private static boolean isNativePointer(Object arrayB) {
        return arrayB instanceof AbstractTruffleString.NativePointer;
    }

    private static long nativePointer(Object array) {
        return ((AbstractTruffleString.NativePointer)array).pointer;
    }

    private static int stubStride(int strideA, int strideB) {
        assert (Stride.isStride(strideA));
        assert (Stride.isStride(strideB));
        return strideA * 3 + strideB;
    }

    private static int stubStrideToStrideA(int stubStride) {
        assert (0 <= stubStride && stubStride < 9) : stubStride;
        return stubStride / 3;
    }

    private static int stubStrideToStrideB(int stubStride) {
        assert (0 <= stubStride && stubStride < 9) : stubStride;
        return stubStride % 3;
    }

    private static int uInt(byte value) {
        return Byte.toUnsignedInt(value);
    }

    static void validateRegion(byte[] stubArray, int offset, int length, int stride) {
        if (!TStringOps.validRegion(stubArray, offset, length, stride)) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static void validateRegion(char[] array, int offset, int length) {
        int charOffset = offset >> 1;
        if (Integer.toUnsignedLong(charOffset) + Integer.toUnsignedLong(length) > (long)array.length) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static void validateRegion(int[] array, int offset, int length) {
        int intOffset = offset >> 2;
        if (Integer.toUnsignedLong(intOffset) + Integer.toUnsignedLong(length) > (long)array.length) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static void validateRegionIndex(byte[] stubArray, int offset, int length, int stride, int i2) {
        if (!TStringOps.validRegionIndex(stubArray, offset, length, stride, i2)) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static boolean validRegion(byte[] stubArray, int offset, int length, int stride) {
        return TStringOps.validOffsetOrLength(stubArray, offset, length, stride);
    }

    private static boolean validRegionIndex(byte[] stubArray, int offset, int length, int stride, int i2) {
        return TStringOps.validOffsetOrLength(stubArray, offset, length, stride) && TStringOps.validIndex(length, i2);
    }

    private static boolean validOffsetOrLength(byte[] stubArray, int offset, int length, int stride) {
        if (stubArray == null) {
            return offset >= 0 && length >= 0;
        }
        return Integer.toUnsignedLong(offset) + (Integer.toUnsignedLong(length) << stride) <= (long)stubArray.length;
    }

    private static boolean validIndex(int length, int i2) {
        return Integer.compareUnsigned(i2, length) < 0;
    }
}

