/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.host;

import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostAdapterFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostClassCache;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostFieldDesc;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostInteropReflect;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.UnmodifiableEconomicMap;

final class HostClassDesc {
    private final Class<?> type;
    private final Reference<HostClassCache> cache;
    private volatile Members members;
    private volatile JNIMembers jniMembers;
    private volatile MethodsBySignature methodsBySignature;
    private volatile HostAdapterFactory.AdapterResult adapter;
    private final boolean allowsImplementation;
    private final boolean allowedTargetType;

    @CompilerDirectives.TruffleBoundary
    static HostClassDesc forClass(HostContext context, Class<?> clazz) {
        return context.getHostClassCache().forClass(clazz);
    }

    @CompilerDirectives.TruffleBoundary
    static HostClassDesc forClass(HostClassCache cache, Class<?> clazz) {
        return cache.forClass(clazz);
    }

    HostClassDesc(Reference<HostClassCache> cacheRef, Class<?> type) {
        this.type = type;
        this.cache = cacheRef;
        this.allowsImplementation = HostInteropReflect.isExtensibleType(type) && this.getCache().allowsImplementation(type);
        this.allowedTargetType = this.allowsImplementation && HostInteropReflect.isAbstractType(type) && HostClassDesc.hasDefaultConstructor(type);
    }

    public boolean isAllowsImplementation() {
        return this.allowsImplementation;
    }

    public boolean isAllowedTargetType() {
        return this.allowedTargetType;
    }

    public Class<?> getType() {
        return this.type;
    }

    private static boolean hasDefaultConstructor(Class<?> type) {
        assert (!type.isPrimitive());
        if (type.isInterface()) {
            return true;
        }
        for (Constructor<?> ctor : type.getConstructors()) {
            if (ctor.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    static MethodHandles.Lookup getLookup(Class<?> clazz, HostClassCache hostAccess) {
        try {
            MethodHandles.Lookup lookup = hostAccess.getMethodLookup(clazz);
            lookup.accessClass(clazz);
            return lookup;
        }
        catch (IllegalAccessException e2) {
            return null;
        }
    }

    static boolean isObjectMethodOverride(Method m2) {
        return m2.getParameterCount() == 0 && (m2.getName().equals("hashCode") || m2.getName().equals("toString")) || m2.getParameterCount() == 1 && m2.getName().equals("equals") && m2.getParameterTypes()[0] == Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Members getMembers() {
        Members m2 = this.members;
        if (m2 == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m2 = this.members;
                if (m2 == null) {
                    HostClassCache localCache = this.getCache();
                    this.members = m2 = new Members(localCache, this.type);
                }
            }
        }
        return m2;
    }

    private HostClassCache getCache() {
        HostClassCache localCache = this.cache.get();
        assert (localCache != null) : "cache was collected but should no longer be accessible";
        return localCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JNIMembers getJNIMembers() {
        JNIMembers m2 = this.jniMembers;
        if (m2 == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m2 = this.jniMembers;
                if (m2 == null) {
                    this.jniMembers = m2 = new JNIMembers(this.getMembers());
                }
            }
        }
        return m2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodsBySignature getMethodsBySignature() {
        MethodsBySignature m2 = this.methodsBySignature;
        if (m2 == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m2 = this.methodsBySignature;
                if (m2 == null) {
                    this.methodsBySignature = m2 = new MethodsBySignature(this.getMembers());
                }
            }
        }
        return m2;
    }

    private HostMethodDesc lookupMethod(String name) {
        return this.getMembers().methods.get(name);
    }

    private HostMethodDesc lookupStaticMethod(String name) {
        return this.getMembers().staticMethods.get(name);
    }

    public HostMethodDesc lookupMethod(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticMethod(name) : this.lookupMethod(name);
    }

    HostMethodDesc lookupMethodBySignature(String nameAndSignature, boolean onlyStatic) {
        MethodsBySignature m2 = this.getMethodsBySignature();
        return onlyStatic ? m2.staticMethods.get(nameAndSignature) : m2.methods.get(nameAndSignature);
    }

    public HostMethodDesc lookupMethodByJNIName(String jniName, boolean onlyStatic) {
        JNIMembers m2 = this.getJNIMembers();
        return onlyStatic ? m2.staticMethods.get(jniName) : m2.methods.get(jniName);
    }

    public Collection<String> getMethodNames(boolean onlyStatic, boolean includeInternal) {
        Map<String, HostMethodDesc> methods;
        Map<String, HostMethodDesc> map = methods = onlyStatic ? this.getMembers().staticMethods : this.getMembers().methods;
        if (includeInternal || onlyStatic) {
            return Collections.unmodifiableCollection(methods.keySet());
        }
        ArrayList<String> methodNames = new ArrayList<String>(methods.size());
        for (Map.Entry<String, HostMethodDesc> entry : methods.entrySet()) {
            if (entry.getValue().isInternal()) continue;
            methodNames.add(entry.getKey());
        }
        return methodNames;
    }

    public HostMethodDesc lookupConstructor() {
        return this.getMembers().constructor;
    }

    private HostFieldDesc lookupField(String name) {
        return this.getMembers().fields.get(name);
    }

    private HostFieldDesc lookupStaticField(String name) {
        return this.getMembers().staticFields.get(name);
    }

    public HostFieldDesc lookupField(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticField(name) : this.lookupField(name);
    }

    public Collection<String> getFieldNames(boolean onlyStatic) {
        return Collections.unmodifiableCollection((onlyStatic ? this.getMembers().staticFields : this.getMembers().fields).keySet());
    }

    public HostMethodDesc getFunctionalMethod() {
        return this.getMembers().functionalMethod;
    }

    public HostAdapterFactory.AdapterResult getAdapter(HostContext hostContext) {
        HostAdapterFactory.AdapterResult result = this.adapter;
        if (result == null) {
            result = this.getOrSetAdapter(hostContext);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostAdapterFactory.AdapterResult getOrSetAdapter(HostContext hostContext) {
        CompilerAsserts.neverPartOfCompilation();
        HostClassDesc hostClassDesc = this;
        synchronized (hostClassDesc) {
            HostAdapterFactory.AdapterResult result = this.adapter;
            if (result == null) {
                this.adapter = result = HostAdapterFactory.makeAdapterClassFor(this.getCache(), this.type, hostContext.getClassloader());
            }
            return result;
        }
    }

    public String toString() {
        return "JavaClass[" + this.type.getCanonicalName() + "]";
    }

    private static class Members {
        final Map<String, HostMethodDesc> methods;
        final Map<String, HostMethodDesc> staticMethods;
        final HostMethodDesc constructor;
        final Map<String, HostFieldDesc> fields;
        final Map<String, HostFieldDesc> staticFields;
        final HostMethodDesc functionalMethod;
        private static final BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc> MERGE = new BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc>(){

            @Override
            public HostMethodDesc apply(HostMethodDesc m1, HostMethodDesc m2) {
                return Members.merge(m1, m2);
            }
        };

        Members(HostClassCache hostAccess, Class<?> type) {
            Method implementableAbstractMethod;
            LinkedHashMap<String, HostMethodDesc> methodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostMethodDesc> staticMethodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostFieldDesc> fieldMap = new LinkedHashMap<String, HostFieldDesc>();
            LinkedHashMap<String, HostFieldDesc> staticFieldMap = new LinkedHashMap<String, HostFieldDesc>();
            HostMethodDesc functionalInterfaceMethodImpl = null;
            Members.collectPublicMethods(hostAccess, type, methodMap, staticMethodMap);
            Members.collectPublicFields(hostAccess, type, fieldMap, staticFieldMap);
            HostMethodDesc ctor = Members.collectPublicConstructors(hostAccess, type);
            if (!Modifier.isInterface(type.getModifiers()) && !Modifier.isAbstract(type.getModifiers()) && (implementableAbstractMethod = Members.findFunctionalInterfaceMethod(hostAccess, type)) != null) {
                functionalInterfaceMethodImpl = Members.lookupAbstractMethodImplementation(implementableAbstractMethod, methodMap);
            }
            this.methods = methodMap;
            this.staticMethods = staticMethodMap;
            this.constructor = ctor;
            this.fields = fieldMap;
            this.staticFields = staticFieldMap;
            this.functionalMethod = functionalInterfaceMethodImpl;
        }

        private static MethodHandles.Lookup getLookupForPublicClass(Class<?> declaringClass, HostClassCache hostAccess) {
            if (Modifier.isPublic(declaringClass.getModifiers())) {
                return HostClassDesc.getLookup(declaringClass, hostAccess);
            }
            return null;
        }

        private static HostMethodDesc collectPublicConstructors(HostClassCache hostAccess, Class<?> type) {
            HostMethodDesc.SingleMethod ctor = null;
            MethodHandles.Lookup lookup = Members.getLookupForPublicClass(type, hostAccess);
            if (lookup != null && !Modifier.isAbstract(type.getModifiers())) {
                for (Constructor<?> c2 : type.getConstructors()) {
                    if (!hostAccess.allowsAccess(c2)) continue;
                    boolean scoped = hostAccess.methodScoped(c2);
                    HostMethodDesc.SingleMethod overload = HostMethodDesc.SingleMethod.unreflect(lookup, c2, scoped);
                    ctor = ctor == null ? overload : Members.merge(ctor, overload);
                }
            }
            return ctor;
        }

        private static void collectPublicMethods(HostClassCache hostAccess, Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap) {
            Members.collectPublicMethods(hostAccess, type, methodMap, staticMethodMap, new HashMap<Object, Object>(), type);
        }

        private static void collectPublicMethods(HostClassCache hostAccess, Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap, Map<Object, Object> visited, Class<?> startType) {
            boolean includeInherited;
            boolean isPublicType = Members.getLookupForPublicClass(type, hostAccess) != null && !Proxy.isProxyClass(type);
            boolean bl = includeInherited = hostAccess.allowsPublicAccess || hostAccess.allowsAccessInheritance;
            if (isPublicType || !includeInherited) {
                for (GenericDeclaration genericDeclaration : type.getMethods()) {
                    Class<?> declaringClass = ((Method)genericDeclaration).getDeclaringClass();
                    if (Modifier.isStatic(((Method)genericDeclaration).getModifiers()) && declaringClass != startType && Modifier.isInterface(declaringClass.getModifiers()) || Members.getLookupForPublicClass(declaringClass, hostAccess) == null && !Proxy.isProxyClass(declaringClass) || ((Method)genericDeclaration).isBridge() || !hostAccess.allowsAccess((Method)genericDeclaration)) continue;
                    Members.collectPublicMethod(hostAccess, methodMap, staticMethodMap, visited, (Method)genericDeclaration);
                }
                if (hostAccess.isArrayAccess() && type.isArray()) {
                    HostMethodDesc.SingleMethod.SyntheticArrayCloneMethod arrayCloneMethod = new HostMethodDesc.SingleMethod.SyntheticArrayCloneMethod(type);
                    methodMap.put(((HostMethodDesc.SingleMethod)arrayCloneMethod).getName(), arrayCloneMethod);
                }
            }
            if (includeInherited) {
                if (type.getSuperclass() != null) {
                    Members.collectPublicMethods(hostAccess, type.getSuperclass(), methodMap, staticMethodMap, visited, startType);
                }
                for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                    if (visited.put(genericDeclaration, genericDeclaration) != null) continue;
                    Members.collectPublicMethods(hostAccess, genericDeclaration, methodMap, staticMethodMap, visited, startType);
                }
            }
        }

        private static void collectPublicMethod(HostClassCache hostAccess, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap, Map<Object, Object> visited, Method m2) {
            MethodInfo methodInfo = Members.methodInfo(m2);
            if (!visited.containsKey(methodInfo)) {
                visited.put(methodInfo, methodInfo);
                Members.putMethod(hostAccess, m2, methodMap, staticMethodMap, false);
            } else {
                MethodInfo info = (MethodInfo)visited.get(methodInfo);
                if (info.returnType != methodInfo.returnType) {
                    Members.putMethod(hostAccess, m2, methodMap, staticMethodMap, true);
                }
            }
        }

        private static MethodInfo methodInfo(Method m2) {
            return new MethodInfo(m2);
        }

        private static void putMethod(HostClassCache hostAccess, Method m2, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap, boolean onlyVisibleFromJniName) {
            assert (hostAccess.allowsAccess(m2));
            boolean scoped = hostAccess.methodScoped(m2);
            HostMethodDesc.SingleMethod method = HostMethodDesc.SingleMethod.unreflect(hostAccess.getMethodLookup(m2.getDeclaringClass()), m2, scoped, onlyVisibleFromJniName);
            Map<String, HostMethodDesc> map = Modifier.isStatic(m2.getModifiers()) ? staticMethodMap : methodMap;
            map.merge(m2.getName(), method, MERGE);
        }

        static HostMethodDesc merge(HostMethodDesc existing, HostMethodDesc other) {
            assert (other instanceof HostMethodDesc.SingleMethod);
            if (existing instanceof HostMethodDesc.SingleMethod) {
                return new HostMethodDesc.OverloadedMethod(new HostMethodDesc.SingleMethod[]{(HostMethodDesc.SingleMethod)existing, (HostMethodDesc.SingleMethod)other});
            }
            HostMethodDesc.SingleMethod[] oldOverloads = existing.getOverloads();
            HostMethodDesc.SingleMethod[] newOverloads = Arrays.copyOf(oldOverloads, oldOverloads.length + 1);
            newOverloads[oldOverloads.length] = (HostMethodDesc.SingleMethod)other;
            return new HostMethodDesc.OverloadedMethod(newOverloads);
        }

        private static void collectPublicFields(HostClassCache hostAccess, Class<?> type, Map<String, HostFieldDesc> fieldMap, Map<String, HostFieldDesc> staticFieldMap) {
            MethodHandles.Lookup lookup = Members.getLookupForPublicClass(type, hostAccess);
            if (lookup != null) {
                boolean inheritedPublicInstanceFields = false;
                boolean inheritedPublicInaccessibleFields = false;
                for (Field f2 : type.getFields()) {
                    if (!Modifier.isStatic(f2.getModifiers())) {
                        if (f2.getDeclaringClass() == type) {
                            assert (!fieldMap.containsKey(f2.getName()));
                            if (!hostAccess.allowsAccess(f2)) continue;
                            fieldMap.put(f2.getName(), HostFieldDesc.unreflect(lookup, f2));
                            continue;
                        }
                        if (Members.getLookupForPublicClass(f2.getDeclaringClass(), hostAccess) != null) {
                            inheritedPublicInstanceFields = true;
                            continue;
                        }
                        inheritedPublicInaccessibleFields = true;
                        continue;
                    }
                    if (f2.getDeclaringClass() != type || !hostAccess.allowsAccess(f2)) continue;
                    staticFieldMap.put(f2.getName(), HostFieldDesc.unreflect(lookup, f2));
                }
                if (inheritedPublicInstanceFields) {
                    Members.collectPublicInstanceFields(hostAccess, type, fieldMap, inheritedPublicInaccessibleFields);
                }
                if (hostAccess.isArrayAccess() && type.isArray()) {
                    HostFieldDesc.SyntheticArrayLengthField arrayLengthField = HostFieldDesc.SyntheticArrayLengthField.SINGLETON;
                    fieldMap.put(arrayLengthField.getName(), arrayLengthField);
                }
            } else if (!Modifier.isInterface(type.getModifiers())) {
                Members.collectPublicInstanceFields(hostAccess, type, fieldMap, true);
            }
        }

        private static void collectPublicInstanceFields(HostClassCache hostAccess, Class<?> type, Map<String, HostFieldDesc> fieldMap, boolean mayHaveInaccessibleFields) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (Class<?> superclass = type; superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                boolean inheritedPublicInstanceFields = false;
                for (Field f2 : superclass.getFields()) {
                    if (Modifier.isStatic(f2.getModifiers())) continue;
                    if (f2.getDeclaringClass() != superclass) {
                        if (!Modifier.isPublic(f2.getDeclaringClass().getModifiers())) continue;
                        inheritedPublicInstanceFields = true;
                        continue;
                    }
                    if (mayHaveInaccessibleFields && !fieldNames.add(f2.getName())) continue;
                    MethodHandles.Lookup lookup = Members.getLookupForPublicClass(f2.getDeclaringClass(), hostAccess);
                    if (lookup != null) {
                        if (!hostAccess.allowsAccess(f2)) continue;
                        fieldMap.putIfAbsent(f2.getName(), HostFieldDesc.unreflect(lookup, f2));
                        continue;
                    }
                    assert (mayHaveInaccessibleFields);
                }
                if (!inheritedPublicInstanceFields) break;
            }
        }

        private static Method findFunctionalInterfaceMethod(HostClassCache hostAccess, Class<?> clazz) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (Members.getLookupForPublicClass(iface, hostAccess) == null || !iface.isAnnotationPresent(FunctionalInterface.class)) continue;
                for (Method m2 : iface.getMethods()) {
                    if (!Modifier.isAbstract(m2.getModifiers()) || HostClassDesc.isObjectMethodOverride(m2)) continue;
                    return m2;
                }
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return Members.findFunctionalInterfaceMethod(hostAccess, superclass);
            }
            return null;
        }

        private static HostMethodDesc lookupAbstractMethodImplementation(Method abstractMethod, Map<String, HostMethodDesc> methodMap) {
            HostMethodDesc accessibleMethodDesc = methodMap.get(abstractMethod.getName());
            if (accessibleMethodDesc != null) {
                Class<?>[] searchTypes = abstractMethod.getParameterTypes();
                HostMethodDesc.SingleMethod[] available = accessibleMethodDesc.getOverloads();
                ArrayList<HostMethodDesc.SingleMethod> candidates = new ArrayList<HostMethodDesc.SingleMethod>(available.length);
                block0: for (HostMethodDesc.SingleMethod candidate : available) {
                    Class<?>[] candidateTypes = candidate.getParameterTypes();
                    if (searchTypes.length != candidateTypes.length) continue;
                    for (int i2 = 0; i2 < searchTypes.length; ++i2) {
                        if (!candidateTypes[i2].isAssignableFrom(searchTypes[i2]) && !searchTypes[i2].isAssignableFrom(candidateTypes[i2])) continue block0;
                    }
                    candidates.add(candidate);
                }
                if (candidates.size() == available.length) {
                    return accessibleMethodDesc;
                }
                if (candidates.size() == 1) {
                    return (HostMethodDesc)candidates.get(0);
                }
                if (candidates.size() > 1) {
                    return new HostMethodDesc.OverloadedMethod(candidates.toArray(new HostMethodDesc.SingleMethod[candidates.size()]));
                }
            }
            return null;
        }

        private static class MethodInfo {
            private final boolean isStatic;
            private final String name;
            private final Class<?>[] parameterTypes;
            private final Class<?> returnType;

            MethodInfo(Method m2) {
                this.isStatic = Modifier.isStatic(m2.getModifiers());
                this.name = m2.getName();
                this.parameterTypes = m2.getParameterTypes();
                this.returnType = m2.getReturnType();
            }

            public boolean equals(Object obj) {
                if (obj instanceof MethodInfo) {
                    MethodInfo other = (MethodInfo)obj;
                    return this.isStatic == other.isStatic && this.name.equals(other.name) && Arrays.equals(this.parameterTypes, other.parameterTypes);
                }
                return false;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.isStatic ? 1 : 0);
                result = 31 * result + this.name.hashCode();
                result = 31 * result + Arrays.hashCode(this.parameterTypes);
                return result;
            }
        }
    }

    private static final class JNIMembers {
        final UnmodifiableEconomicMap<String, HostMethodDesc> methods;
        final UnmodifiableEconomicMap<String, HostMethodDesc> staticMethods;

        JNIMembers(Members members) {
            this.methods = JNIMembers.collectJNINamedMethods(members.methods);
            this.staticMethods = JNIMembers.collectJNINamedMethods(members.staticMethods);
        }

        private static UnmodifiableEconomicMap<String, HostMethodDesc> collectJNINamedMethods(Map<String, HostMethodDesc> methods) {
            EconomicMap<String, HostMethodDesc> jniMethods = EconomicMap.create();
            for (HostMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (HostMethodDesc.SingleMethod m2 : method.getOverloads()) {
                    assert (m2.isMethod());
                    jniMethods.put(HostInteropReflect.jniName((Method)m2.getReflectionMethod()), m2);
                }
            }
            return jniMethods;
        }
    }

    private static final class MethodsBySignature {
        final UnmodifiableEconomicMap<String, HostMethodDesc> methods;
        final UnmodifiableEconomicMap<String, HostMethodDesc> staticMethods;

        MethodsBySignature(Members members) {
            this.methods = MethodsBySignature.collectMethodsBySignature(members.methods);
            this.staticMethods = MethodsBySignature.collectMethodsBySignature(members.staticMethods);
        }

        private static UnmodifiableEconomicMap<String, HostMethodDesc> collectMethodsBySignature(Map<String, HostMethodDesc> methods) {
            EconomicMap<String, HostMethodDesc> methodMap = EconomicMap.create();
            for (HostMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (HostMethodDesc.SingleMethod m2 : method.getOverloads()) {
                    assert (m2.isMethod());
                    if (m2.isOnlyVisibleFromJniName()) continue;
                    methodMap.put(HostInteropReflect.toNameAndSignature((Method)m2.getReflectionMethod()), m2);
                }
            }
            return methodMap;
        }
    }
}

