/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.host;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostObject;

@ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
final class HostException
extends AbstractTruffleException {
    private final Throwable original;
    final HostObject delegate;

    private HostException(Throwable original, HostContext context, Node location) {
        super(location);
        this.original = original;
        this.delegate = HostObject.forException(original, context, this);
    }

    Throwable getOriginal() {
        return this.original;
    }

    @Override
    public String getMessage() {
        return this.getOriginal().getMessage();
    }

    static HostException wrap(Throwable original, HostContext context) {
        return HostException.wrap(original, context, null);
    }

    static HostException wrap(Throwable original, HostContext context, Node location) {
        HostException hostException = new HostException(original, context, location);
        HostAccessor.EXCEPTION.setLazyStackTrace(hostException, HostAccessor.LANGUAGE.getOrCreateLazyStackTrace(original));
        return hostException;
    }

    HostException withContext(HostContext context) {
        HostException hostException = new HostException(this.original, context, this.getLocation());
        HostAccessor.EXCEPTION.setLazyStackTrace(this, HostAccessor.EXCEPTION.getLazyStackTrace(hostException));
        return hostException;
    }
}

