/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.host;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostClassCache;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostLanguageService;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodScope;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostToTypeNode;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class HostLanguage
extends TruffleLanguage<HostContext> {
    @CompilerDirectives.CompilationFinal
    HostClassCache hostClassCache;
    final AbstractPolyglotImpl.AbstractHostAccess access;
    final AbstractPolyglotImpl polyglot;
    final AbstractPolyglotImpl.APIAccess api;
    final HostLanguageService service;
    final Class<?> valueClass;
    final Class<?> polyglotExceptionClass;
    final Class<?> byteSequenceClass;
    @CompilerDirectives.CompilationFinal
    private boolean methodScopingEnabled;
    static final TruffleLanguage.LanguageReference<HostLanguage> REFERENCE = TruffleLanguage.LanguageReference.create(HostLanguage.class);

    HostLanguage(AbstractPolyglotImpl polyglot, AbstractPolyglotImpl.AbstractHostAccess hostAccess) {
        this.polyglot = polyglot;
        this.access = hostAccess;
        this.api = polyglot.getAPIAccess();
        this.service = new HostLanguageService(polyglot, this);
        this.valueClass = polyglot.getAPIAccess().getValueClass();
        this.polyglotExceptionClass = polyglot.getAPIAccess().getPolyglotExceptionClass();
        this.byteSequenceClass = polyglot.getAPIAccess().getByteSequenceClass();
    }

    @Override
    protected boolean patchContext(HostContext context, TruffleLanguage.Env newEnv) {
        return true;
    }

    @Override
    protected HostContext createContext(TruffleLanguage.Env env) {
        env.registerService(this.service);
        return new HostContext(this, env);
    }

    static Object unwrapIfScoped(HostLanguage language, Object o2) {
        if (language == null || !language.methodScopingEnabled) {
            return o2;
        }
        return language.unwrapIfScoped(o2);
    }

    @Override
    protected Object getScope(HostContext context) {
        return context.topScope;
    }

    @Override
    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    private Object unwrapIfScoped(Object obj) {
        if (!this.methodScopingEnabled) {
            return obj;
        }
        Object o2 = obj;
        if (o2 instanceof HostMethodScope.ScopedObject) {
            o2 = ((HostMethodScope.ScopedObject)o2).unwrapForGuest();
        }
        return o2;
    }

    void initializeHostAccess(Object hostAccess) {
        if (hostAccess == null) {
            return;
        }
        HostClassCache cache = HostClassCache.findOrInitialize(this.access, this.api, hostAccess);
        if (this.hostClassCache != null) {
            if (!this.hostClassCache.hostAccess.equals(cache.hostAccess)) {
                throw HostAccessor.ENGINE.createPolyglotEngineException(new IllegalStateException("Found different host access configuration for a context with a shared engine. The host access configuration must be the same for all contexts of an engine. Provide the same host access configuration using the Context.Builder.allowHostAccess method when constructing the context."));
            }
        } else {
            this.hostClassCache = cache;
        }
        this.methodScopingEnabled = this.api.isMethodScopingEnabled(hostAccess);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object getLanguageView(HostContext hostContext, Object value) {
        Object wrapped;
        if (value instanceof TruffleObject) {
            InteropLibrary lib = InteropLibrary.getFactory().getUncached(value);
            try {
                assert (!lib.hasLanguage(value) || lib.getLanguage(value) != HostLanguage.class);
            }
            catch (UnsupportedMessageException e2) {
                throw CompilerDirectives.shouldNotReachHere(e2);
            }
            wrapped = HostToTypeNode.convertToObject(lib, hostContext, value, lib);
        } else {
            wrapped = value;
        }
        if (wrapped != null) {
            return HostObject.forObject(wrapped, hostContext);
        }
        return null;
    }

    @Override
    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        final String sourceString = request.getSource().getCharacters().toString();
        return new RootNode(this, this){
            final /* synthetic */ HostLanguage this$0;
            {
                this.this$0 = this$0;
                super(language);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                return this.this$0.service.findDynamicClass(HostContext.get(this), sourceString);
            }
        }.getCallTarget();
    }

    static HostLanguage get(Node node) {
        return REFERENCE.get(node);
    }

    @Override
    protected void disposeContext(HostContext context) {
        context.disposeClassLoader();
    }

    static class HostLanguageException
    extends AbstractTruffleException {
        HostLanguageException(String message) {
            super(message);
        }
    }
}

