/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.AsyncFromSyncIteratorPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetMethodNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorNextNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.ThrowNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.TryCatchNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAsyncFromSyncIteratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class AsyncFromSyncIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<GeneratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncFromSyncIteratorPrototypeBuiltins();

    protected AsyncFromSyncIteratorPrototypeBuiltins() {
        super(JSFunction.ASYNC_FROM_SYNC_ITERATOR_PROTOTYPE_NAME, GeneratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, GeneratorPrototype builtinEnum) {
        assert (context.getEcmaScriptVersion() >= 8);
        switch (builtinEnum.ordinal()) {
            case 0: {
                return AsyncFromSyncIteratorPrototypeBuiltinsFactory.AsyncFromSyncNextNodeGen.create(context, builtin, AsyncFromSyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return AsyncFromSyncIteratorPrototypeBuiltinsFactory.AsyncFromSyncReturnNodeGen.create(context, builtin, AsyncFromSyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return AsyncFromSyncIteratorPrototypeBuiltinsFactory.AsyncFromSyncThrowNodeGen.create(context, builtin, AsyncFromSyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum GeneratorPrototype implements BuiltinEnum<GeneratorPrototype>
    {
        next(0),
        return_(0),
        throw_(0);

        private final int length;

        private GeneratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class AsyncFromSyncNext
    extends AsyncFromSyncBaseNode {
        public AsyncFromSyncNext(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object next(VirtualFrame frame, JSAsyncFromSyncIteratorObject thisObj, Object value, @Cached InlinedConditionProfile valuePresenceProfile) {
            Object nextResult;
            PromiseCapabilityRecord promiseCapability = this.createPromiseCapability();
            IteratorRecord syncIteratorRecord = thisObj.getSyncIteratorRecord();
            try {
                nextResult = valuePresenceProfile.profile(this, JSArguments.getUserArgumentCount(frame.getArguments()) == 0) ? this.iteratorNextNode.execute(syncIteratorRecord) : this.iteratorNextNode.execute(syncIteratorRecord, value);
            }
            catch (AbstractTruffleException e2) {
                this.promiseCapabilityReject(promiseCapability, e2);
                return promiseCapability.getPromise();
            }
            return this.asyncFromSyncIteratorContinuation(nextResult, promiseCapability, syncIteratorRecord, true);
        }
    }

    public static abstract class AsyncFromSyncReturn
    extends AsyncFromSyncMethod {
        @Node.Child
        private GetMethodNode getReturn;
        @Node.Child
        private CreateIterResultObjectNode createIterResult;

        public AsyncFromSyncReturn(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
            this.getReturn = GetMethodNode.create(context, Strings.RETURN);
            this.createIterResult = CreateIterResultObjectNode.create(context);
        }

        @Override
        protected GetMethodNode getMethod() {
            return this.getReturn;
        }

        @Override
        protected Object processUndefinedMethod(VirtualFrame frame, PromiseCapabilityRecord promiseCapability, Object value, Object syncIterator) {
            JSObject iterResult = this.createIterResult.execute(frame, value, true);
            this.promiseCapabilityResolve(promiseCapability, iterResult);
            return promiseCapability.getPromise();
        }
    }

    public static abstract class AsyncFromSyncThrow
    extends AsyncFromSyncMethod {
        @Node.Child
        private GetMethodNode getThrow;

        public AsyncFromSyncThrow(JSContext context, JSBuiltin builtin) {
            super(context, builtin, true);
            this.getThrow = GetMethodNode.create(context, Strings.THROW);
        }

        @Override
        protected GetMethodNode getMethod() {
            return this.getThrow;
        }

        @Override
        protected Object processUndefinedMethod(VirtualFrame frame, PromiseCapabilityRecord promiseCapability, Object value, Object syncIterator) {
            try {
                this.iteratorCloseNode.executeVoid(syncIterator);
            }
            catch (AbstractTruffleException e2) {
                this.promiseCapabilityReject(promiseCapability, e2);
                return promiseCapability.getPromise();
            }
            this.promiseCapabilityReject(promiseCapability, Errors.createTypeError("The iterator doesn't have throw() method."));
            return promiseCapability.getPromise();
        }
    }

    @GenerateCached(value=false)
    protected static abstract class AsyncFromSyncMethod
    extends AsyncFromSyncBaseNode {
        private final boolean closeOnRejection;
        @Node.Child
        private JSFunctionCallNode executeReturnMethod;

        public AsyncFromSyncMethod(JSContext context, JSBuiltin builtin, boolean closeOnRejection) {
            super(context, builtin);
            this.closeOnRejection = closeOnRejection;
            this.executeReturnMethod = JSFunctionCallNode.createCall();
        }

        protected abstract GetMethodNode getMethod();

        protected abstract Object processUndefinedMethod(VirtualFrame var1, PromiseCapabilityRecord var2, Object var3, Object var4);

        @Specialization
        protected final Object doMethod(VirtualFrame frame, JSAsyncFromSyncIteratorObject thisObj, Object value, @Cached InlinedConditionProfile valuePresenceProfile) {
            Object returnResult;
            PromiseCapabilityRecord promiseCapability = this.createPromiseCapability();
            IteratorRecord syncIteratorRecord = thisObj.getSyncIteratorRecord();
            Object syncIterator = syncIteratorRecord.getIterator();
            Object method = this.getMethod().executeWithTarget(syncIterator);
            if (method == Undefined.instance) {
                return this.processUndefinedMethod(frame, promiseCapability, value, syncIterator);
            }
            try {
                returnResult = valuePresenceProfile.profile(this, JSArguments.getUserArgumentCount(frame.getArguments()) == 0) ? this.executeReturnMethod.executeCall(JSArguments.create(syncIterator, method, new Object[0])) : this.executeReturnMethod.executeCall(JSArguments.create(syncIterator, method, value));
            }
            catch (AbstractTruffleException e2) {
                this.promiseCapabilityReject(promiseCapability, e2);
                return promiseCapability.getPromise();
            }
            if (!JSDynamicObject.isJSDynamicObject(returnResult)) {
                this.promiseCapabilityReject(promiseCapability, Errors.createTypeErrorNotAnObject(returnResult));
                return promiseCapability.getPromise();
            }
            return this.asyncFromSyncIteratorContinuation(returnResult, promiseCapability, syncIteratorRecord, this.closeOnRejection);
        }
    }

    @GenerateCached(value=false)
    @ImportStatic(value={JSRuntime.class})
    protected static abstract class AsyncFromSyncBaseNode
    extends JSBuiltinNode {
        static final HiddenKey DONE = new HiddenKey("Done");
        static final HiddenKey SYNC_ITERATOR_RECORD = new HiddenKey("SyncIteratorRecord");
        @Node.Child
        private JSFunctionCallNode executePromiseMethodNode;
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        protected PerformPromiseThenNode performPromiseThenNode;
        @Node.Child
        private PromiseResolveNode promiseResolveNode;
        @Node.Child
        protected IteratorNextNode iteratorNextNode;
        @Node.Child
        protected IteratorValueNode iteratorValueNode;
        @Node.Child
        protected IteratorCompleteNode iteratorCompleteNode;
        @Node.Child
        protected IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private PropertySetNode setDoneNode;
        @Node.Child
        private PropertySetNode setSyncIteratorRecordNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        AsyncFromSyncBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.executePromiseMethodNode = JSFunctionCallNode.createCall();
            this.iteratorNextNode = IteratorNextNode.create();
            this.iteratorCompleteNode = IteratorCompleteNode.create();
            this.iteratorValueNode = IteratorValueNode.create();
            this.iteratorCloseNode = IteratorCloseNode.create(context);
            this.setDoneNode = PropertySetNode.createSetHidden(DONE, context);
            this.setSyncIteratorRecordNode = PropertySetNode.createSetHidden(SYNC_ITERATOR_RECORD, context);
            this.performPromiseThenNode = PerformPromiseThenNode.create(context);
            this.promiseResolveNode = PromiseResolveNode.create(context);
        }

        protected PromiseCapabilityRecord createPromiseCapability() {
            return this.newPromiseCapabilityNode.executeDefault();
        }

        protected void promiseCapabilityReject(PromiseCapabilityRecord promiseCapability, AbstractTruffleException exception) {
            if (this.getErrorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
            }
            Object result = this.getErrorObjectNode.execute(exception);
            this.promiseCapabilityRejectImpl(promiseCapability, result);
        }

        protected void promiseCapabilityRejectImpl(PromiseCapabilityRecord promiseCapability, Object result) {
            this.executePromiseMethodNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), result));
        }

        protected void promiseCapabilityResolve(PromiseCapabilityRecord valueWrapperCapability, Object result) {
            this.executePromiseMethodNode.executeCall(JSArguments.createOneArg(Undefined.instance, valueWrapperCapability.getResolve(), result));
        }

        protected final Object asyncFromSyncIteratorContinuation(Object result, PromiseCapabilityRecord promiseCapability, IteratorRecord syncIteratorRecord, boolean closeOnRejection) {
            JSPromiseObject valueWrapper;
            Object returnValue;
            boolean done;
            try {
                done = this.iteratorCompleteNode.execute(result);
            }
            catch (AbstractTruffleException e2) {
                this.promiseCapabilityReject(promiseCapability, e2);
                return promiseCapability.getPromise();
            }
            try {
                returnValue = this.iteratorValueNode.execute(result);
            }
            catch (AbstractTruffleException e3) {
                this.promiseCapabilityReject(promiseCapability, e3);
                return promiseCapability.getPromise();
            }
            JSRealm realm = this.getRealm();
            if (this.getContext().usePromiseResolve()) {
                try {
                    valueWrapper = (JSPromiseObject)this.promiseResolveNode.execute(realm.getPromiseConstructor(), returnValue);
                }
                catch (AbstractTruffleException e4) {
                    if (!done && closeOnRejection) {
                        this.iteratorCloseNode.executeAbrupt(syncIteratorRecord.getIterator());
                    }
                    this.promiseCapabilityReject(promiseCapability, e4);
                    return promiseCapability.getPromise();
                }
            } else {
                PromiseCapabilityRecord valueWrapperCapability = this.createPromiseCapability();
                this.promiseCapabilityResolve(valueWrapperCapability, returnValue);
                valueWrapper = (JSPromiseObject)valueWrapperCapability.getPromise();
            }
            JSFunctionObject onFulfilled = this.createIteratorValueUnwrapFunction(realm, done);
            JSDynamicObject onRejected = done || !closeOnRejection ? Undefined.instance : this.createIteratorCloseFunction(realm, syncIteratorRecord);
            this.performPromiseThenNode.execute(valueWrapper, onFulfilled, onRejected, promiseCapability);
            return promiseCapability.getPromise();
        }

        protected final JSFunctionObject createIteratorValueUnwrapFunction(JSRealm realm, boolean done) {
            JSContext context = realm.getContext();
            JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncFromSyncIteratorValueUnwrap, c2 -> AsyncFromSyncBaseNode.createIteratorValueUnwrapImpl(c2));
            JSFunctionObject function = JSFunction.create(realm, functionData);
            this.setDoneNode.setValueBoolean(function, done);
            return function;
        }

        private static JSFunctionData createIteratorValueUnwrapImpl(JSContext context) {
            class AsyncFromSyncIteratorValueUnwrapRootNode
            extends JavaScriptRootNode {
                @Node.Child
                private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
                @Node.Child
                private PropertyGetNode isDoneNode = PropertyGetNode.createGetHidden(DONE, this.val$context);
                @Node.Child
                private CreateIterResultObjectNode createIterResult = CreateIterResultObjectNode.create(this.val$context);
                final /* synthetic */ JSContext val$context;

                AsyncFromSyncIteratorValueUnwrapRootNode(JSContext jSContext) {
                    this.val$context = jSContext;
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    boolean done;
                    JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                    Object value = this.valueNode.execute(frame);
                    try {
                        done = this.isDoneNode.getValueBoolean(functionObject);
                    }
                    catch (UnexpectedResultException e2) {
                        throw Errors.shouldNotReachHere();
                    }
                    return this.createIterResult.execute(frame, value, done);
                }
            }
            return JSFunctionData.createCallOnly(context, new AsyncFromSyncIteratorValueUnwrapRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected final JSFunctionObject createIteratorCloseFunction(JSRealm realm, IteratorRecord syncIteratorRecord) {
            JSContext context = realm.getContext();
            JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncFromSyncIteratorCloseIterator, c2 -> AsyncFromSyncBaseNode.createIteratorCloseImpl(c2));
            JSFunctionObject function = JSFunction.create(realm, functionData);
            this.setSyncIteratorRecordNode.setValue(function, syncIteratorRecord);
            return function;
        }

        private static JSFunctionData createIteratorCloseImpl(JSContext context) {
            class AsyncFromSyncIteratorCloseIteratorRootNode
            extends JavaScriptRootNode {
                @Node.Child
                private ThrowNode throwNode;
                @Node.Child
                private PropertyGetNode getSyncIteratorRecordNode;
                @Node.Child
                private IteratorCloseNode iteratorCloseNode;
                final /* synthetic */ JSContext val$context;

                AsyncFromSyncIteratorCloseIteratorRootNode(JSContext jSContext) {
                    this.val$context = jSContext;
                    this.throwNode = ThrowNode.create(AccessIndexedArgumentNode.create(0), this.val$context);
                    this.getSyncIteratorRecordNode = PropertyGetNode.createGetHidden(SYNC_ITERATOR_RECORD, this.val$context);
                    this.iteratorCloseNode = IteratorCloseNode.create(this.val$context);
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                    IteratorRecord syncIteratorRecord = (IteratorRecord)this.getSyncIteratorRecordNode.getValue(functionObject);
                    this.iteratorCloseNode.executeAbrupt(syncIteratorRecord.getIterator());
                    return this.throwNode.execute(frame);
                }
            }
            return JSFunctionData.createCallOnly(context, new AsyncFromSyncIteratorCloseIteratorRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        @Fallback
        protected final Object incompatibleReceiver(Object thisObj, Object value) {
            PromiseCapabilityRecord promiseCapability = this.createPromiseCapability();
            JSException typeError = Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj);
            this.promiseCapabilityReject(promiseCapability, typeError);
            return promiseCapability.getPromise();
        }
    }
}

