/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.AsyncGeneratorPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.AsyncGeneratorEnqueueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAsyncGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Completion;

public final class AsyncGeneratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<AsyncGeneratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncGeneratorPrototypeBuiltins();

    protected AsyncGeneratorPrototypeBuiltins() {
        super(JSAsyncGenerator.PROTOTYPE_NAME, AsyncGeneratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, AsyncGeneratorPrototype builtinEnum) {
        Completion.Type resumeMethod;
        assert (context.getEcmaScriptVersion() >= 8);
        switch (builtinEnum.ordinal()) {
            case 0: {
                resumeMethod = Completion.Type.Normal;
                break;
            }
            case 1: {
                resumeMethod = Completion.Type.Return;
                break;
            }
            case 2: {
                resumeMethod = Completion.Type.Throw;
                break;
            }
            default: {
                return null;
            }
        }
        return AsyncGeneratorPrototypeBuiltinsFactory.AsyncGeneratorResumeNodeGen.create(context, builtin, resumeMethod, AsyncGeneratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
    }

    public static enum AsyncGeneratorPrototype implements BuiltinEnum<AsyncGeneratorPrototype>
    {
        next(1),
        return_(1),
        throw_(1);

        private final int length;

        private AsyncGeneratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class AsyncGeneratorResumeNode
    extends JSBuiltinNode {
        private final Completion.Type resumeType;
        @Node.Child
        private AsyncGeneratorEnqueueNode enqueueNode;

        public AsyncGeneratorResumeNode(JSContext context, JSBuiltin builtin, Completion.Type resumeType) {
            super(context, builtin);
            this.resumeType = resumeType;
            this.enqueueNode = AsyncGeneratorEnqueueNode.create(context);
        }

        @Specialization
        protected Object resume(VirtualFrame frame, Object thisObj, Object value) {
            Completion completion = Completion.create(this.resumeType, value);
            return this.enqueueNode.execute(frame, thisObj, completion);
        }
    }
}

