/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.IteratorFunctionBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.InstanceofNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSWrapForValidIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;

public final class IteratorFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<IteratorFunction> {
    public static final JSBuiltinsContainer BUILTINS = new IteratorFunctionBuiltins();

    IteratorFunctionBuiltins() {
        super(JSIterator.CLASS_NAME, IteratorFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, IteratorFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return IteratorFunctionBuiltinsFactory.JSIteratorFromNodeGen.create(context, builtin, IteratorFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum IteratorFunction implements BuiltinEnum<IteratorFunction>
    {
        from(1);

        private final int length;

        private IteratorFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSIteratorFromNode
    extends JSBuiltinNode {
        @Node.Child
        private GetIteratorFlattenableNode getIteratorFlattenableNode;
        @Node.Child
        private InstanceofNode.OrdinaryHasInstanceNode ordinaryHasInstanceNode;

        public JSIteratorFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIteratorFlattenableNode = GetIteratorFlattenableNode.create(false, false, context);
            this.ordinaryHasInstanceNode = InstanceofNode.OrdinaryHasInstanceNode.create(context);
        }

        @Specialization
        protected Object iteratorFrom(Object arg) {
            IteratorRecord iteratorRecord = this.getIteratorFlattenableNode.execute(arg);
            JSRealm realm = this.getRealm();
            boolean hasInstance = this.ordinaryHasInstanceNode.executeBoolean(iteratorRecord.getIterator(), realm.getIteratorConstructor());
            if (hasInstance) {
                return iteratorRecord.getIterator();
            }
            return JSWrapForValidIterator.create(this.getContext(), realm, iteratorRecord);
        }
    }
}

