/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.IteratorHelperPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.IteratorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSIteratorHelperObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class IteratorHelperPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<HelperIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new IteratorHelperPrototypeBuiltins();
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("IteratorHelper.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Iterator Helper");

    protected IteratorHelperPrototypeBuiltins() {
        super(PROTOTYPE_NAME, HelperIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, HelperIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return IteratorHelperPrototypeBuiltinsFactory.IteratorHelperNextNodeGen.create(context, builtin, IteratorHelperPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return IteratorHelperPrototypeBuiltinsFactory.IteratorHelperReturnNodeGen.create(context, builtin, IteratorHelperPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static boolean isJSIteratorHelper(Object object) {
        return object instanceof JSIteratorHelperObject;
    }

    public static enum HelperIteratorPrototype implements BuiltinEnum<HelperIteratorPrototype>
    {
        next(0),
        return_(0);

        private final int length;

        private HelperIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={IteratorHelperPrototypeBuiltins.class})
    public static abstract class IteratorHelperNextNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

        protected IteratorHelperNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object next(VirtualFrame frame, JSIteratorHelperObject thisObj, @Cached InlinedBranchProfile executingProfile, @Cached InlinedBranchProfile completedProfile) {
            JSFunction.GeneratorState state = thisObj.getGeneratorState();
            if (state == JSFunction.GeneratorState.Executing) {
                executingProfile.enter(this);
                throw Errors.createTypeError("generator is already executing");
            }
            if (state == JSFunction.GeneratorState.Completed) {
                completedProfile.enter(this);
                if (this.createIterResultObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.createIterResultObjectNode = this.insert(CreateIterResultObjectNode.create(this.getContext()));
                }
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            thisObj.setGeneratorState(JSFunction.GeneratorState.Executing);
            try {
                JSFunctionObject next = thisObj.getNextImpl();
                return this.callNode.executeCall(JSArguments.createZeroArg(thisObj, next));
            }
            catch (AbstractTruffleException ex) {
                thisObj.setGeneratorState(JSFunction.GeneratorState.Completed);
                throw ex;
            }
        }

        @Specialization(guards={"!isJSIteratorHelper(thisObj)"})
        protected final Object unsupported(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj);
        }

        @Override
        public boolean isSplitImmediately() {
            return true;
        }
    }

    @ImportStatic(value={IteratorHelperPrototypeBuiltins.class, IteratorPrototypeBuiltins.class, JSFunction.GeneratorState.class})
    public static abstract class IteratorHelperReturnNode
    extends JSBuiltinNode {
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;

        protected IteratorHelperReturnNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.iteratorCloseNode = IteratorCloseNode.create(context);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        }

        @Specialization(guards={"thisObj.getGeneratorState() == Executing"})
        public Object executing(JSIteratorHelperObject thisObj) {
            throw Errors.createTypeError("generator is already executing");
        }

        @Specialization(guards={"thisObj.getGeneratorState() == SuspendedStart"})
        public Object suspendedStart(VirtualFrame frame, JSIteratorHelperObject thisObj) {
            thisObj.setGeneratorState(JSFunction.GeneratorState.Completed);
            IteratorPrototypeBuiltins.IteratorArgs args = thisObj.getIteratorArgs();
            this.iteratorCloseNode.executeVoid(args.iterated.getIterator());
            return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"thisObj.getGeneratorState() == SuspendedYield"})
        public Object suspendedYield(VirtualFrame frame, JSIteratorHelperObject thisObj, @Cached InlinedBranchProfile aliveBranch) {
            thisObj.setGeneratorState(JSFunction.GeneratorState.Executing);
            try {
                IteratorPrototypeBuiltins.IteratorArgs args = thisObj.getIteratorArgs();
                IteratorRecord iterated = args.iterated;
                if (args instanceof IteratorPrototypeBuiltins.IteratorFlatMapNode.IteratorFlatMapArgs) {
                    IteratorPrototypeBuiltins.IteratorFlatMapNode.IteratorFlatMapArgs flatMapArgs = (IteratorPrototypeBuiltins.IteratorFlatMapNode.IteratorFlatMapArgs)args;
                    assert (flatMapArgs.innerAlive);
                    aliveBranch.enter(this);
                    try {
                        this.iteratorCloseNode.executeVoid(flatMapArgs.innerIterator.getIterator());
                    }
                    catch (AbstractTruffleException e2) {
                        this.iteratorCloseNode.executeAbrupt(iterated.getIterator());
                        throw e2;
                    }
                }
                this.iteratorCloseNode.executeVoid(iterated.getIterator());
            }
            finally {
                thisObj.setGeneratorState(JSFunction.GeneratorState.Completed);
            }
            return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
        }

        @Specialization(guards={"thisObj.getGeneratorState() == Completed"})
        public Object completed(VirtualFrame frame, JSIteratorHelperObject thisObj) {
            return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
        }

        @Specialization(guards={"!isJSIteratorHelper(thisObj)"})
        protected final Object unsupported(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj);
        }
    }
}

