/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.commonjs;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleFile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.GlobalBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSErrorType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

public abstract class CommonJSResolveBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    CommonJSResolveBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected TruffleString resolve(TruffleString moduleIdentifier) {
        JSRealm realm = this.getRealm();
        try {
            TruffleFile cwd = CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(realm, realm.getEnv());
            TruffleFile maybeModule = CommonJSResolution.resolve(realm, moduleIdentifier.toJavaStringUncached(), cwd);
            if (maybeModule == null) {
                throw CommonJSResolveBuiltin.fail(moduleIdentifier);
            }
            return Strings.fromJavaString(maybeModule.getAbsoluteFile().normalize().toString());
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException ex) {
            throw Errors.createErrorFromException(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException fail(TruffleString moduleIdentifier) {
        return JSException.create(JSErrorType.TypeError, "Cannot find module: '" + String.valueOf(moduleIdentifier) + "'");
    }

    @Fallback
    protected static Object fallback(Object moduleIdentifier) {
        throw Errors.createTypeErrorNotAString(moduleIdentifier);
    }
}

