/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper;

import java.util.BitSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

public final class StringEscape {
    private static final BitSet dontEscapeSet;

    private StringEscape() {
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString escape(TruffleString s2) {
        int len = Strings.length(s2);
        TruffleStringBuilderUTF16 out = null;
        for (int i2 = 0; i2 < len; ++i2) {
            char ch;
            char c2 = Strings.charAt(s2, i2);
            if (dontEscapeSet.get(c2)) {
                if (out == null) continue;
                Strings.builderAppend(out, c2);
                continue;
            }
            if (out == null) {
                out = StringEscape.allocStringBuilder(s2, i2, len + 16);
            }
            Strings.builderAppend(out, '%');
            if (c2 < '\u0100') {
                ch = StringEscape.hexChar(c2 >> 4 & 0xF);
                Strings.builderAppend(out, ch);
                ch = StringEscape.hexChar(c2 & 0xF);
                Strings.builderAppend(out, ch);
                continue;
            }
            Strings.builderAppend(out, 'u');
            ch = StringEscape.hexChar(c2 >> 12 & 0xF);
            Strings.builderAppend(out, ch);
            ch = StringEscape.hexChar(c2 >> 8 & 0xF);
            Strings.builderAppend(out, ch);
            ch = StringEscape.hexChar(c2 >> 4 & 0xF);
            Strings.builderAppend(out, ch);
            ch = StringEscape.hexChar(c2 & 0xF);
            Strings.builderAppend(out, ch);
        }
        return out != null ? Strings.builderToString(out) : s2;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString unescape(TruffleString string) {
        int len = Strings.length(string);
        TruffleStringBuilderUTF16 sb = null;
        int k2 = 0;
        while (k2 < len) {
            char c2 = Strings.charAt(string, k2);
            if (c2 == '%') {
                if (sb == null) {
                    sb = StringEscape.allocStringBuilder(string, k2, len);
                }
                if (k2 <= len - 6 && StringEscape.unescapeU0000(string, sb, k2)) {
                    k2 += 6;
                    continue;
                }
                if (k2 <= len - 3 && StringEscape.unescape00(string, sb, k2)) {
                    k2 += 3;
                    continue;
                }
            }
            if (sb != null) {
                Strings.builderAppend(sb, c2);
            }
            ++k2;
        }
        return sb != null ? Strings.builderToString(sb) : string;
    }

    private static TruffleStringBuilderUTF16 allocStringBuilder(TruffleString s2, int i2, int estimatedLength) {
        TruffleStringBuilderUTF16 sb = Strings.builderCreate(estimatedLength);
        if (i2 > 0) {
            Strings.builderAppend(sb, s2, 0, i2);
        }
        return sb;
    }

    private static boolean unescapeU0000(TruffleString string, TruffleStringBuilderUTF16 builder, int k2) {
        char c1 = Strings.charAt(string, k2 + 1);
        if (c1 == 'u') {
            char c2 = Strings.charAt(string, k2 + 2);
            char c3 = Strings.charAt(string, k2 + 3);
            char c4 = Strings.charAt(string, k2 + 4);
            char c5 = Strings.charAt(string, k2 + 5);
            if (JSRuntime.isHex(c2) && JSRuntime.isHex(c3) && JSRuntime.isHex(c4) && JSRuntime.isHex(c5)) {
                char newC = (char)(StringEscape.hexVal(c2) * 16 * 16 * 16 + StringEscape.hexVal(c3) * 16 * 16 + StringEscape.hexVal(c4) * 16 + StringEscape.hexVal(c5));
                Strings.builderAppend(builder, newC);
                return true;
            }
        }
        return false;
    }

    private static boolean unescape00(TruffleString string, TruffleStringBuilderUTF16 builder, int k2) {
        char c1 = Strings.charAt(string, k2 + 1);
        char c2 = Strings.charAt(string, k2 + 2);
        if (JSRuntime.isHex(c1) && JSRuntime.isHex(c2)) {
            char newC = (char)(StringEscape.hexVal(c1) * 16 + StringEscape.hexVal(c2));
            Strings.builderAppend(builder, newC);
            return true;
        }
        return false;
    }

    private static char hexChar(int value) {
        if (value < 10) {
            return (char)(48 + value);
        }
        return (char)(65 + value - 10);
    }

    private static int hexVal(char c2) {
        int value = JSRuntime.valueInHex(c2);
        if (value < 0) {
            assert (false) : "not a hex character";
            return 0;
        }
        return value;
    }

    static {
        BitSet unescaped = new BitSet(128);
        unescaped.set(97, 123);
        unescaped.set(65, 91);
        unescaped.set(48, 58);
        unescaped.set(64);
        unescaped.set(42);
        unescaped.set(95);
        unescaped.set(43);
        unescaped.set(45);
        unescaped.set(46);
        unescaped.set(47);
        dontEscapeSet = unescaped;
    }
}

