/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.MathOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;

public abstract class HypotNode
extends MathOperation {
    public HypotNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization(guards={"args.length == 0"})
    protected static double hypot0(Object[] args) {
        return 0.0;
    }

    @Specialization(guards={"args.length == 1"})
    protected final double hypot1(Object[] args) {
        double x2 = this.toDouble(args[0]);
        return Math.abs(x2);
    }

    @Specialization(guards={"args.length == 2"})
    protected final double hypot2(Object[] args) {
        double x2 = this.toDouble(args[0]);
        double y2 = this.toDouble(args[1]);
        return HypotNode.hypot2(x2, y2);
    }

    @Specialization(guards={"args.length >= 3"})
    protected final double hypot(Object[] args) {
        int length = args.length;
        double[] values = new double[length];
        boolean isInfinite = false;
        double max = 0.0;
        for (int i2 = 0; i2 < length; ++i2) {
            double value = this.toDouble(args[i2]);
            double absValue = Math.abs(value);
            isInfinite |= Double.isInfinite(absValue);
            max = Math.max(max, absValue);
            values[i2] = absValue;
        }
        if (isInfinite) {
            return Double.POSITIVE_INFINITY;
        }
        if (max == 0.0 || Double.isNaN(max)) {
            return max;
        }
        double sum = 0.0;
        double compensation = 0.0;
        for (double value : values) {
            double normalizedValue = value / max;
            double square = normalizedValue * normalizedValue;
            double compensatedValue = square - compensation;
            double nextSum = sum + compensatedValue;
            compensation = nextSum - sum - compensatedValue;
            sum = nextSum;
        }
        return Math.sqrt(sum) * max;
    }

    private static double hypot2(double x2, double y2) {
        double absx = Math.abs(x2);
        double absy = Math.abs(y2);
        double max = Math.max(absx, absy);
        double min = Math.min(absx, absy);
        if (Double.isInfinite(x2) || Double.isInfinite(y2)) {
            return Double.POSITIVE_INFINITY;
        }
        if (max == 0.0 || Double.isNaN(max)) {
            return max;
        }
        double normalizedMin = min / max;
        double normalizedMinSquared = normalizedMin * normalizedMin;
        double normalizedMaxSquared = 1.0;
        return Math.sqrt(normalizedMinSquared + normalizedMaxSquared) * max;
    }
}

