/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.SlowPathException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.MathOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.PowNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSNodeUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SuppressFBWarnings;

public abstract class PowNode
extends MathOperation {
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenOne = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenTwo = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenThree = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenZeroPointFive = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenOnePointFive = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenTwoPointFive = false;

    public PowNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    public abstract double execute(Object var1, Object var2);

    @NeverDefault
    protected PowNode create(JSContext context) {
        return PowNodeGen.create(context, null, null);
    }

    @Specialization(rewriteOn={SlowPathException.class})
    protected double pow(double a2, double b2) throws SlowPathException {
        if (this.hasSeenOne && b2 == 1.0) {
            return a2;
        }
        if (this.hasSeenTwo && b2 == 2.0) {
            return a2 * a2;
        }
        if (this.hasSeenThree && b2 == 3.0) {
            return a2 * a2 * a2;
        }
        if ((this.hasSeenZeroPointFive || this.hasSeenOnePointFive || this.hasSeenTwoPointFive) && (a2 < 0.0 || a2 == -0.0)) {
            return PowNode.powIntl(a2, b2);
        }
        if (this.hasSeenZeroPointFive && b2 == 0.5) {
            return Math.sqrt(a2);
        }
        if (this.hasSeenOnePointFive && b2 == 1.5) {
            return a2 * Math.sqrt(a2);
        }
        if (this.hasSeenTwoPointFive && b2 == 2.5) {
            return a2 * a2 * Math.sqrt(a2);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (b2 == 1.0) {
            this.hasSeenOne = true;
        } else if (b2 == 2.0) {
            this.hasSeenTwo = true;
        } else if (b2 == 3.0) {
            this.hasSeenThree = true;
        } else if (b2 == 0.5) {
            this.hasSeenZeroPointFive = true;
        } else if (b2 == 1.5) {
            this.hasSeenOnePointFive = true;
        } else if (b2 == 2.5) {
            this.hasSeenTwoPointFive = true;
        } else {
            throw JSNodeUtil.slowPathException();
        }
        return this.pow(a2, b2);
    }

    private static double positivePow(double operand, int castExponent) {
        int exponent = castExponent;
        double result = 1.0;
        double base = operand;
        while (exponent > 0) {
            if ((exponent & 1) == 1) {
                result *= base;
            }
            exponent >>= 1;
            base *= base;
        }
        return result;
    }

    @Specialization(rewriteOn={SlowPathException.class})
    protected double pow2(double a2, double b2) throws SlowPathException {
        if (JSRuntime.doubleIsRepresentableAsInt(b2, true) && b2 > 0.0) {
            return PowNode.positivePow(a2, (int)b2);
        }
        throw JSNodeUtil.slowPathException();
    }

    @Specialization
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="not necessary in this case")
    protected double pow3(double a2, double b2, @Cached InlinedConditionProfile branch1, @Cached InlinedConditionProfile branch2) {
        int ib = (int)b2;
        if (branch1.profile(this, JSRuntime.doubleIsRepresentableAsInt(b2, true) && b2 > 0.0)) {
            return PowNode.positivePow(a2, ib);
        }
        if (branch2.profile(this, (double)ib + 0.5 == b2 && b2 > 0.0 && a2 > 0.0 && a2 != -0.0)) {
            return PowNode.positivePow(a2, ib) * Math.sqrt(a2);
        }
        return PowNode.powIntl(a2, b2);
    }

    @Specialization
    protected Object pow(Object a2, Object b2, @Cached(value="create(getContext())") PowNode powNode) {
        return JSRuntime.doubleToNarrowestNumber(powNode.execute(this.toDouble(a2), this.toDouble(b2)));
    }

    @CompilerDirectives.TruffleBoundary
    private static double powIntl(double a2, double b2) {
        return Math.pow(a2, b2);
    }
}

