/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.MathOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.math.RoundNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;

public abstract class RoundNode
extends MathOperation {
    private static final int EXP_BIAS = 1023;
    private static final int SIGNIFICAND_WIDTH = 53;
    private static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;

    RoundNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    public static RoundNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return RoundNodeGen.create(context, builtin, RoundNode.createCast(arguments));
    }

    protected static JavaScriptNode[] createCast(JavaScriptNode[] argumentNodes) {
        argumentNodes[0] = JSToNumberNode.create(argumentNodes[0]);
        return argumentNodes;
    }

    protected static boolean isCornercase(double d2) {
        return Double.isNaN(d2) || JSRuntime.isNegativeZero(d2);
    }

    @Specialization
    protected static int roundInt(int a2) {
        return a2;
    }

    @Specialization(guards={"isCornercase(value)"})
    protected static double roundCornercase(double value) {
        return value;
    }

    private static long round(double a2, Node node, InlinedConditionProfile shiftProfile, InlinedBranchProfile negativeLongBitsProfile) {
        long longBits = Double.doubleToRawLongBits(a2);
        long biasedExp = (longBits & 0x7FF0000000000000L) >> 52;
        long shift = 1074L - biasedExp;
        if (shiftProfile.profile(node, (shift & 0xFFFFFFFFFFFFFFC0L) == 0L)) {
            long r2 = longBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (longBits < 0L) {
                negativeLongBitsProfile.enter(node);
                r2 = -r2;
            }
            return (r2 >> (int)shift) + 1L >> 1;
        }
        return (long)a2;
    }

    @Specialization(guards={"!isCornercase(value)", "isDoubleInInt32Range(value)"}, rewriteOn={ArithmeticException.class})
    protected int roundDoubleInt(double value, @Cached @Cached.Shared InlinedConditionProfile shiftProfile, @Cached @Cached.Shared InlinedBranchProfile negativeLongBitsProfile) {
        long longValue = RoundNode.round(value, this, shiftProfile, negativeLongBitsProfile);
        if (longValue == 0L && value < 0.0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new ArithmeticException();
        }
        assert (JSRuntime.longIsRepresentableAsInt(longValue));
        return (int)longValue;
    }

    @Specialization(guards={"!isCornercase(value)"}, replaces={"roundDoubleInt"})
    protected double roundDouble(double value, @Cached @Cached.Exclusive InlinedConditionProfile profileA, @Cached @Cached.Exclusive InlinedConditionProfile profileB, @Cached @Cached.Shared InlinedConditionProfile shiftProfile, @Cached @Cached.Shared InlinedBranchProfile negativeLongBitsProfile) {
        long longValue = RoundNode.round(value, this, shiftProfile, negativeLongBitsProfile);
        if (profileA.profile(this, longValue == Long.MIN_VALUE || longValue == Long.MAX_VALUE)) {
            return value;
        }
        if (profileB.profile(this, longValue == 0L && value < 0.0)) {
            return -0.0;
        }
        return longValue;
    }
}

