/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.sort;

import java.util.Comparator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.ConstantByteArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.ConstantDoubleArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.ConstantIntArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class SortComparator
implements Comparator<Object> {
    private final Object compFnObj;
    private final boolean isFunction;

    public SortComparator(Object compFnObj) {
        this.compFnObj = compFnObj;
        this.isFunction = JSFunction.isJSFunction(compFnObj);
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (arg0 == Undefined.instance) {
            if (arg1 == Undefined.instance) {
                return 0;
            }
            return 1;
        }
        if (arg1 == Undefined.instance) {
            return -1;
        }
        Object retObj = this.isFunction ? JSFunction.call((JSFunctionObject)this.compFnObj, Undefined.instance, new Object[]{arg0, arg1}) : JSRuntime.call(this.compFnObj, Undefined.instance, new Object[]{arg0, arg1});
        return SortComparator.convertResult(retObj);
    }

    private static int convertResult(Object retObj) {
        if (retObj instanceof Integer) {
            return (Integer)retObj;
        }
        double d2 = JSRuntime.toDouble(retObj);
        if (d2 < 0.0) {
            return -1;
        }
        if (d2 > 0.0) {
            return 1;
        }
        return 0;
    }

    public static Comparator<Object> getDefaultComparator(JSContext context, Object thisObj, boolean isTypedArrayImplementation) {
        if (isTypedArrayImplementation) {
            return null;
        }
        if (context.getArrayPrototypeNoElementsAssumption().isValid() && JSArray.isJSFastArray(thisObj)) {
            ScriptArray array = JSAbstractArray.arrayGetArrayType((JSDynamicObject)thisObj);
            if (array instanceof AbstractIntArray || array instanceof ConstantByteArray || array instanceof ConstantIntArray) {
                return JSArray.DEFAULT_JSARRAY_INTEGER_COMPARATOR;
            }
            if (array instanceof AbstractDoubleArray || array instanceof ConstantDoubleArray) {
                return JSArray.DEFAULT_JSARRAY_DOUBLE_COMPARATOR;
            }
        }
        return JSArray.DEFAULT_JSARRAY_COMPARATOR;
    }
}

