/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal;

import java.util.EnumSet;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainYearMonthPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.RoundRelativeDurationNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalYearMonthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalPlainYearMonthPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainYearMonthPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainYearMonthPrototypeBuiltins();

    protected TemporalPlainYearMonthPrototypeBuiltins() {
        super(JSTemporalPlainYearMonth.PROTOTYPE_NAME, TemporalPlainYearMonthPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainYearMonthPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthCalendarGetterNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthGetterNodeGen.create(context, builtin, builtinEnum, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 9: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthAddSubNodeGen.create(context, builtin, 1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 10: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthAddSubNodeGen.create(context, builtin, -1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 11: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthUntilSinceNodeGen.create(context, builtin, 1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 12: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthUntilSinceNodeGen.create(context, builtin, -1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 8: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthWithNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 13: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthEqualsNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 18: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToPlainDateNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 19: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthGetISOFieldsNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 14: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToStringNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: 
            case 16: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToLocaleStringNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 17: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainYearMonthPrototype implements BuiltinEnum<TemporalPlainYearMonthPrototype>
    {
        calendarId(0),
        year(0),
        month(0),
        monthCode(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        with(1),
        add(1),
        subtract(1),
        until(1),
        since(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        toPlainDate(1),
        getISOFields(0);

        private final int length;

        private TemporalPlainYearMonthPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendarId, new TemporalPlainYearMonthPrototype[]{year, month, monthCode, daysInMonth, daysInYear, monthsInYear, inLeapYear}).contains(this);
        }
    }

    public static abstract class JSTemporalPlainYearMonthCalendarGetterNode
    extends JSBuiltinNode {
        protected JSTemporalPlainYearMonthCalendarGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString calendarId(JSTemporalPlainYearMonthObject yearMonth, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return toCalendarIdentifier.executeString(yearMonth.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalYearMonth(yearMonth)"})
        protected static TruffleString invalidReceiver(Object yearMonth) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthGetterNode
    extends JSBuiltinNode {
        protected final TemporalPlainYearMonthPrototype property;

        protected JSTemporalPlainYearMonthGetterNode(JSContext context, JSBuiltin builtin, TemporalPlainYearMonthPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object dateGetter(JSTemporalPlainYearMonthObject temporalYM, @Cached TemporalCalendarGetterNode calendarGetterNode) {
            switch (this.property.ordinal()) {
                case 1: {
                    return TemporalUtil.calendarYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 2: {
                    return TemporalUtil.calendarMonth(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 3: {
                    return TemporalUtil.calendarMonthCode(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 5: {
                    return TemporalUtil.calendarDaysInYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 4: {
                    return TemporalUtil.calendarDaysInMonth(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 6: {
                    return TemporalUtil.calendarMonthsInYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 7: {
                    return TemporalUtil.calendarInLeapYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int operation;

        protected JSTemporalPlainYearMonthAddSubNode(JSContext context, JSBuiltin builtin, int operation) {
            super(context, builtin);
            this.operation = operation;
        }

        @Specialization
        protected JSTemporalPlainYearMonthObject addDurationToOrSubtractDurationFromPlainYearMonth(JSTemporalPlainYearMonthObject yearMonth, Object temporalDurationLike, Object optParam, @Bind(value="this") Node node, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached(value="createDateAdd()") CalendarMethodsRecordLookupNode lookupDateAdd, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createDay()") CalendarMethodsRecordLookupNode lookupDay, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createYearMonthFromFields()") CalendarMethodsRecordLookupNode lookupYearMonthFromFields, @Cached TemporalAddDateNode addDateNode, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached TemporalCalendarGetterNode calendarGetterNode, @Cached JSToIntegerThrowOnInfinityNode toIntNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            int day;
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            JSRealm realm = this.getRealm();
            if (this.operation == -1) {
                duration = JSTemporalDuration.createNegatedTemporalDuration(this.getContext(), realm, duration);
            }
            BigInt norm = TemporalUtil.normalizeTimeDuration(duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
            TimeDurationRecord balanceResult = TemporalUtil.balanceTimeDuration(norm, TemporalUtil.Unit.DAY);
            double days = duration.getDays() + balanceResult.days();
            int sign = TemporalUtil.durationSign(duration.getYears(), duration.getMonths(), duration.getWeeks(), days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Object calendarSlotValue = yearMonth.getCalendar();
            Object dateAddMethod = lookupDateAdd.execute(calendarSlotValue);
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendarSlotValue);
            Object dayMethod = lookupDay.execute(calendarSlotValue);
            Object fieldsMethod = lookupFields.execute(calendarSlotValue);
            Object yearMonthFromFieldsMethod = lookupYearMonthFromFields.execute(calendarSlotValue);
            CalendarMethodsRecord calendarRec = new CalendarMethodsRecord(calendarSlotValue, dateAddMethod, dateFromFieldsMethod, null, dayMethod, fieldsMethod, null, null, yearMonthFromFieldsMethod);
            JSDynamicObject options = this.getOptionsObject(optParam, node, errorBranch, optionUndefined);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), yearMonth, fieldNames, TemporalUtil.listEmpty);
            if (sign < 0) {
                Object dayFromCalendar = TemporalUtil.calendarDaysInMonth(calendarGetterNode, calendarRec.receiver(), yearMonth);
                day = TemporalUtil.toPositiveIntegerConstrainInt(dayFromCalendar, toIntNode, node, errorBranch);
            } else {
                day = 1;
            }
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), fields, TemporalConstants.DAY, day);
            JSTemporalPlainDateObject intermediateDate = dateFromFieldsNode.execute(calendarRec, fields, Undefined.instance);
            JSTemporalDurationObject durationToAdd = JSTemporalDuration.createTemporalDuration(this.getContext(), realm, duration.getYears(), duration.getMonths(), duration.getWeeks(), days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            JSObject optionsCopy = snapshotOwnProperties.snapshot(options, Null.instance);
            JSTemporalPlainDateObject addedDate = addDateNode.execute(calendarRec, intermediateDate, durationToAdd, options);
            JSObject addedDateFields = TemporalUtil.prepareTemporalFields(this.getContext(), addedDate, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendarRec, addedDateFields, optionsCopy);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainYearMonthUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalPlainYearMonth(JSTemporalPlainYearMonthObject thisYearMonth, Object otherParam, Object options, @Bind(value="this") Node node, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached(value="createDateAdd()") CalendarMethodsRecordLookupNode lookupDateAdd, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createDateUntil()") CalendarMethodsRecordLookupNode lookupDateUntil, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached RoundRelativeDurationNode roundRelativeDuration, @Cached ToTemporalYearMonthNode toTemporalYearMonthNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached ToTemporalCalendarObjectNode toCalendarObject, @Cached(value="createCall()") JSFunctionCallNode callDateUntil, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            boolean roundingGranularityIsNoop;
            JSTemporalPlainYearMonthObject other = toTemporalYearMonthNode.execute(otherParam, Undefined.instance);
            Object calendar = thisYearMonth.getCalendar();
            if (!TemporalUtil.calendarEquals(calendar, other.getCalendar(), toCalendarIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSObject resolvedOptions = snapshotOwnProperties.snapshot(this.getOptionsObject(options, node, errorBranch, optionUndefined), Null.instance);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingYearMonthOrAuto, TemporalUtil.unitMappingYearMonth, TemporalUtil.Unit.MONTH, TemporalUtil.Unit.YEAR);
            Object dateAddMethod = lookupDateAdd.execute(calendar);
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendar);
            Object dateUntilMethod = lookupDateUntil.execute(calendar);
            Object fieldsMethod = lookupFields.execute(calendar);
            CalendarMethodsRecord calendarRec = new CalendarMethodsRecord(calendar, dateAddMethod, dateFromFieldsMethod, dateUntilMethod, null, fieldsMethod, null, null, null);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listMCY);
            JSObject otherFields = TemporalUtil.prepareTemporalFields(this.getContext(), other, fieldNames, TemporalUtil.listEmpty);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), otherFields, TemporalConstants.DAY, 1);
            JSTemporalPlainDateObject otherDate = dateFromFieldsNode.execute(calendarRec, otherFields, Undefined.instance);
            JSObject thisFields = TemporalUtil.prepareTemporalFields(this.getContext(), thisYearMonth, fieldNames, TemporalUtil.listEmpty);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), thisFields, TemporalConstants.DAY, 1);
            JSTemporalPlainDateObject thisDate = dateFromFieldsNode.execute(calendarRec, thisFields, Undefined.instance);
            JSObject untilOptions = TemporalUtil.mergeLargestUnitOption(this.getContext(), namesNode, resolvedOptions, settings.largestUnit());
            JSTemporalDurationObject result = TemporalUtil.calendarDateUntil(calendarRec, thisDate, otherDate, untilOptions, toCalendarObject, callDateUntil);
            JSRealm realm = this.getRealm();
            NormalizedDurationRecord duration = TemporalUtil.createNormalizedDurationRecord(result.getYears(), result.getMonths(), 0.0, 0.0, TemporalUtil.zeroTimeDuration());
            double durationYears = duration.years();
            double durationMonths = duration.months();
            boolean bl = roundingGranularityIsNoop = settings.smallestUnit() == TemporalUtil.Unit.MONTH && settings.roundingIncrement() == 1;
            if (!roundingGranularityIsNoop) {
                BigInt destEpochNs = TemporalUtil.getUTCEpochNanoseconds(otherDate.getYear(), otherDate.getMonth(), otherDate.getDay(), 0, 0, 0, 0, 0, 0);
                ISODateTimeRecord dateTime = new ISODateTimeRecord(thisDate.getYear(), thisDate.getMonth(), thisDate.getDay(), 0, 0, 0, 0, 0, 0);
                JSTemporalDurationRecord roundedDuration = roundRelativeDuration.execute(duration, destEpochNs, dateTime, calendarRec, null, settings.largestUnit(), settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode()).duration();
                durationYears = roundedDuration.getYears();
                durationMonths = roundedDuration.getMonths();
            }
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, (double)this.sign * durationYears, (double)this.sign * durationMonths, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherParam, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthWithNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainYearMonthObject with(JSTemporalPlainYearMonthObject yearMonth, Object temporalYearMonthLike, Object options, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createMergeFields()") CalendarMethodsRecordLookupNode lookupMergeFields, @Cached(value="createYearMonthFromFields()") CalendarMethodsRecordLookupNode lookupYearMonthFromFields, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!isPartialTemporalObjectNode.execute(temporalYearMonthLike)) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            JSObject resolvedOptions = snapshotOwnProperties.snapshot(this.getOptionsObject(options, this, errorBranch, optionUndefined), Null.instance);
            Object calendarSlotValue = yearMonth.getCalendar();
            Object fieldsMethod = lookupFields.execute(calendarSlotValue);
            Object mergeFieldsMethod = lookupMergeFields.execute(calendarSlotValue);
            Object yearMonthFromFieldsMethod = lookupYearMonthFromFields.execute(calendarSlotValue);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forFieldsAndMergeFieldsAndYearMonthFromFields(calendarSlotValue, fieldsMethod, mergeFieldsMethod, yearMonthFromFieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listMMCY);
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), yearMonth, fieldNames, TemporalUtil.listEmpty);
            JSObject partialYearMonth = TemporalUtil.prepareTemporalFields(this.getContext(), temporalYearMonthLike, fieldNames, null);
            fields = TemporalUtil.calendarMergeFields(this.getContext(), this.getRealm(), calendarRec, fields, partialYearMonth, this, errorBranch);
            fields = TemporalUtil.prepareTemporalFields(this.getContext(), fields, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendarRec, fields, resolvedOptions);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalYearMonthLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthEqualsNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthEqualsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalPlainYearMonthObject yearMonth, Object otherParam, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached ToTemporalYearMonthNode toTemporalYearMonthNode) {
            JSTemporalPlainYearMonthObject other = toTemporalYearMonthNode.execute(otherParam, Undefined.instance);
            if (yearMonth.getMonth() != other.getMonth()) {
                return false;
            }
            if (yearMonth.getDay() != other.getDay()) {
                return false;
            }
            if (yearMonth.getYear() != other.getYear()) {
                return false;
            }
            return TemporalUtil.calendarEquals(yearMonth.getCalendar(), other.getCalendar(), toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToPlainDateNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToPlainDateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateObject toPlainDate(JSTemporalPlainYearMonthObject yearMonth, Object item, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createMergeFields()") CalendarMethodsRecordLookupNode lookupMergeFields, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch) {
            if (!JSRuntime.isObject(item)) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
            }
            Object calendarSlotValue = yearMonth.getCalendar();
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendarSlotValue);
            Object fieldsMethod = lookupFields.execute(calendarSlotValue);
            Object mergeFieldsMethod = lookupMergeFields.execute(calendarSlotValue);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateFromFieldsAndFieldsAndMergeFields(calendarSlotValue, dateFromFieldsMethod, fieldsMethod, mergeFieldsMethod);
            List<TruffleString> receiverFieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), yearMonth, receiverFieldNames, TemporalUtil.listEmpty);
            List<TruffleString> inputFieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listD);
            JSObject inputFields = TemporalUtil.prepareTemporalFields(this.getContext(), TemporalUtil.toJSDynamicObject(item, this, errorBranch), inputFieldNames, TemporalUtil.listEmpty);
            JSDynamicObject mergedFields = TemporalUtil.calendarMergeFields(this.getContext(), this.getRealm(), calendarRec, fields, inputFields, this, errorBranch);
            List<TruffleString> mergedFieldNames = TemporalUtil.listJoinRemoveDuplicates(receiverFieldNames, inputFieldNames);
            mergedFields = TemporalUtil.prepareTemporalFields(this.getContext(), mergedFields, mergedFieldNames, TemporalUtil.listEmpty);
            JSObject options = JSOrdinary.createWithNullPrototype(this.getContext());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), options, TemporalConstants.OVERFLOW, TemporalConstants.REJECT);
            return dateFromFieldsNode.execute(calendarRec, mergedFields, options);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthGetISOFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthGetISOFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSObject getISOFields(JSTemporalPlainYearMonthObject ym) {
            JSObject obj = JSOrdinary.create(this.getContext(), this.getRealm());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.CALENDAR, ym.getCalendar());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_DAY, ym.getDay());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MONTH, ym.getMonth());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_YEAR, ym.getYear());
            return obj;
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalPlainYearMonthObject yearMonth, Object optParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            return JSTemporalPlainYearMonth.temporalYearMonthToString(yearMonth, showCalendar);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalPlainYearMonthObject yearMonth) {
            return JSTemporalPlainYearMonth.temporalYearMonthToString(yearMonth, TemporalUtil.ShowCalendar.AUTO);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }
}

