/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.DeclareGlobalLexicalVariableNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.DeclareGlobalNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.HasRestrictedGlobalPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.HasRestrictedGlobalPropertyNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Dead;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public abstract class DeclareGlobalLexicalVariableNode
extends DeclareGlobalNode {
    private final boolean isConst;
    @Node.Child
    private HasRestrictedGlobalPropertyNode hasRestrictedGlobalPropertyNode;

    protected DeclareGlobalLexicalVariableNode(TruffleString varName, boolean isConst) {
        super(varName);
        this.isConst = isConst;
        this.hasRestrictedGlobalPropertyNode = HasRestrictedGlobalPropertyNodeGen.create();
    }

    public static DeclareGlobalLexicalVariableNode create(TruffleString varName, boolean isConst) {
        return DeclareGlobalLexicalVariableNodeGen.create(varName, isConst);
    }

    @Override
    public void verify(JSContext context, JSRealm realm) {
        super.verify(context, realm);
        if (this.hasRestrictedGlobalPropertyNode.execute(realm.getGlobalObject(), this.varName)) {
            this.errorProfile.enter();
            throw Errors.createSyntaxErrorVariableAlreadyDeclared(this.varName, this);
        }
    }

    @Override
    public final void executeVoid(VirtualFrame frame, JSContext context, JSRealm realm) {
        JSDynamicObject globalScope = realm.getGlobalScope();
        assert (!JSObject.hasOwnProperty(globalScope, this.varName));
        assert (JSObject.isExtensible(globalScope));
        this.executeVoid(globalScope, context);
    }

    private int getAttributeFlags() {
        return this.isConst ? JSAttributes.notConfigurableEnumerableWritable() | 0x20 : JSAttributes.notConfigurableEnumerableWritable();
    }

    protected abstract void executeVoid(JSDynamicObject var1, JSContext var2);

    @Specialization(guards={"context.getPropertyCacheLimit() > 0"})
    protected void doCached(JSDynamicObject globalScope, JSContext context, @Cached(value="makeDefineOwnPropertyCache(context)") PropertySetNode cache) {
        cache.setValue(globalScope, Dead.instance());
    }

    @Specialization(replaces={"doCached"})
    protected void doUncached(JSDynamicObject globalScope, JSContext context) {
        JSObjectUtil.defineConstantDataProperty(context, globalScope, this.varName, Dead.instance(), this.getAttributeFlags());
    }

    @NeverDefault
    protected final PropertySetNode makeDefineOwnPropertyCache(JSContext context) {
        return PropertySetNode.createImpl(this.varName, false, context, true, true, this.getAttributeFlags(), true);
    }

    @Override
    public boolean isLexicallyDeclared() {
        return true;
    }

    @Override
    protected DeclareGlobalNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return DeclareGlobalLexicalVariableNode.create(this.varName, this.isConst);
    }
}

