/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.ListGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.ListSizeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.HasOnlyShapePropertiesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSShape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.JSClassProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;

@ImportStatic(value={JSConfig.class})
public abstract class EnumerableOwnPropertyNamesNode
extends JavaScriptBaseNode {
    private final boolean keys;
    private final boolean values;
    private final JSContext context;
    @Node.Child
    private JSGetOwnPropertyNode getOwnPropertyNode;
    private final ConditionProfile hasFastShapesProfile = ConditionProfile.create();

    protected EnumerableOwnPropertyNamesNode(JSContext context, boolean keys, boolean values) {
        this.context = context;
        this.keys = keys;
        this.values = values;
    }

    @NeverDefault
    public static EnumerableOwnPropertyNamesNode createKeys(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, true, false);
    }

    @NeverDefault
    public static EnumerableOwnPropertyNamesNode createValues(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, false, true);
    }

    @NeverDefault
    public static EnumerableOwnPropertyNamesNode createKeysValues(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, true, true);
    }

    public abstract UnmodifiableArrayList<? extends Object> execute(Object var1);

    @Specialization
    protected UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(JSDynamicObject thisObj, @Cached JSClassProfile jsclassProfile, @Cached ListSizeNode listSize, @Cached ListGetNode listGet, @Cached HasOnlyShapePropertiesNode hasOnlyShapeProperties, @Cached @Cached.Exclusive InlinedBranchProfile growProfile) {
        JSClass jsclass = jsclassProfile.getJSClass(thisObj);
        if (this.hasFastShapesProfile.profile(this.keys && !this.values && hasOnlyShapeProperties.execute(thisObj, jsclass))) {
            return JSShape.getEnumerablePropertyNames(thisObj.getShape());
        }
        boolean isProxy = JSProxy.isJSProxy(thisObj);
        List<Object> ownKeys = jsclass.ownPropertyKeys(thisObj);
        int ownKeysSize = listSize.execute(ownKeys);
        SimpleArrayList<TruffleString> properties = new SimpleArrayList<TruffleString>();
        for (int i2 = 0; i2 < ownKeysSize; ++i2) {
            Object element;
            TruffleString name;
            PropertyDescriptor desc;
            Object key = listGet.execute(ownKeys, i2);
            if (!(key instanceof TruffleString) || (desc = this.getOwnProperty(thisObj, name = (TruffleString)key)) == null || !desc.getEnumerable()) continue;
            if (this.keys && !this.values) {
                element = name;
            } else {
                Object value;
                Object object = value = desc.isAccessorDescriptor() || isProxy ? jsclass.get(thisObj, name) : desc.getValue();
                if (!this.keys && this.values) {
                    element = value;
                } else {
                    assert (this.keys && this.values);
                    element = this.createKeyValuePair(name, value);
                }
            }
            properties.add((TruffleString)element, this, growProfile);
        }
        return new UnmodifiableArrayList<Object>(properties.toArray());
    }

    private Object createKeyValuePair(Object key, Object value) {
        return JSArray.createConstant(this.context, this.getRealm(), new Object[]{key, value});
    }

    protected PropertyDescriptor getOwnProperty(JSDynamicObject thisObj, Object key) {
        if (this.getOwnPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getOwnPropertyNode = this.insert(JSGetOwnPropertyNode.create(this.values, true, false, false, false));
        }
        return this.getOwnPropertyNode.execute(thisObj, key);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(obj)"}, limit="InteropLibraryLimit")
    protected UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNamesForeign(Object obj, @Bind(value="this") Node node, @CachedLibrary(value="obj") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary members, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary asString, @Cached ImportValueNode importValue, @Cached @Cached.Exclusive InlinedBranchProfile errorBranch, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        try {
            long arraySize = 0L;
            if (interop.hasArrayElements(obj)) {
                arraySize = interop.getArraySize(obj);
            }
            Object keysObj = null;
            long memberCount = 0L;
            if (interop.hasMembers(obj)) {
                keysObj = interop.getMembers(obj);
                memberCount = members.getArraySize(keysObj);
            }
            long size = arraySize + memberCount;
            if (arraySize < 0L || memberCount < 0L || size < 0L || size >= Integer.MAX_VALUE) {
                errorBranch.enter(node);
                throw Errors.createRangeErrorInvalidArrayLength(this);
            }
            if (size > 0L) {
                Object element;
                TruffleString key;
                SimpleArrayList<Object> list = new SimpleArrayList<Object>((int)size);
                for (long i2 = 0L; i2 < arraySize; ++i2) {
                    key = Strings.fromLong(i2);
                    if (this.values) {
                        Object value = importValue.executeWithTarget(interop.readArrayElement(obj, i2));
                        element = this.keys ? this.createKeyValuePair(key, value) : value;
                    } else {
                        element = key;
                    }
                    list.addUnchecked(element);
                }
                int i3 = 0;
                while ((long)i3 < memberCount) {
                    Object objectKey = members.readArrayElement(keysObj, i3);
                    assert (InteropLibrary.getUncached().isString(objectKey));
                    key = Strings.interopAsTruffleString(objectKey, asString, switchEncodingNode);
                    if (this.values) {
                        String javaStringKey = Strings.toJavaString(toJavaStringNode, key);
                        Object value = importValue.executeWithTarget(interop.readMember(obj, javaStringKey));
                        element = this.keys ? this.createKeyValuePair(key, value) : value;
                    } else {
                        element = key;
                    }
                    list.addUnchecked(element);
                    ++i3;
                }
                return new UnmodifiableArrayList<Object>(list.toArray());
            }
        }
        catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException interopException) {
            // empty catch block
        }
        return new UnmodifiableArrayList<Object>(ScriptArray.EMPTY_OBJECT_ARRAY);
    }
}

