/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateAsyncFromSyncIteratorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetMethodNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@ImportStatic(value={Symbol.class, Strings.class})
public abstract class GetIteratorFlattenableNode
extends JavaScriptBaseNode {
    protected final boolean rejectStrings;
    protected final boolean async;
    protected final JSContext context;

    protected GetIteratorFlattenableNode(boolean rejectStrings, boolean async, JSContext context) {
        this.rejectStrings = rejectStrings;
        this.async = async;
        this.context = context;
    }

    public abstract IteratorRecord execute(Object var1);

    public static GetIteratorFlattenableNode create(boolean rejectStrings, boolean async, JSContext context) {
        return GetIteratorFlattenableNodeGen.create(rejectStrings, async, context);
    }

    @Specialization
    protected final IteratorRecord getIteratorFlattenable(Object iteratedObject, @Cached IsObjectNode isObjectNode, @Cached IsObjectNode isIteratorObjectNode, @Cached IsCallableNode isCallableNode, @Cached(value="create(context, SYMBOL_ASYNC_ITERATOR)") GetMethodNode getAsyncIteratorMethodNode, @Cached(value="create(context, SYMBOL_ITERATOR)") GetMethodNode getIteratorMethodNode, @Cached(value="createCall()") JSFunctionCallNode iteratorCallNode, @Cached(value="create(NEXT, context)") PropertyGetNode getNextMethodNode, @Cached CreateAsyncFromSyncIteratorNode createAsyncFromSyncIteratorNode, @Cached InlinedBranchProfile errorBranch) {
        Object iterator;
        if (!(isObjectNode.executeBoolean(iteratedObject) || !this.rejectStrings && iteratedObject instanceof TruffleString)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAnObject(iteratedObject, this);
        }
        boolean alreadyAsync = false;
        Object method = Undefined.instance;
        if (this.async) {
            method = getAsyncIteratorMethodNode.executeWithTarget(iteratedObject);
            alreadyAsync = true;
        }
        if (!this.async || !isCallableNode.executeBoolean(method)) {
            method = getIteratorMethodNode.executeWithTarget(iteratedObject);
            alreadyAsync = false;
        }
        if (method == Undefined.instance) {
            iterator = iteratedObject;
            alreadyAsync = true;
        } else {
            iterator = iteratorCallNode.executeCall(JSArguments.create(iteratedObject, method, new Object[0]));
        }
        if (!isIteratorObjectNode.executeBoolean(iterator)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAnObject(iterator, this);
        }
        Object nextMethod = getNextMethodNode.getValue(iterator);
        if (!isCallableNode.executeBoolean(nextMethod)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAFunction(nextMethod, this);
        }
        IteratorRecord iteratorRecord = IteratorRecord.create(iterator, nextMethod, false);
        if (this.async && !alreadyAsync) {
            return createAsyncFromSyncIteratorNode.execute(this, iteratorRecord);
        }
        return iteratorRecord;
    }
}

