/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.CompilableFunction;

public class GetPrototypeFromConstructorNode
extends JavaScriptNode {
    private final CompilableFunction<JSRealm, JSDynamicObject> intrinsicDefaultProto;
    @Node.Child
    private JavaScriptNode constructorNode;
    @Node.Child
    private PropertyGetNode getPrototypeNode;
    @Node.Child
    private IsJSObjectNode isObjectNode;

    protected GetPrototypeFromConstructorNode(JSContext context, JavaScriptNode constructorNode, CompilableFunction<JSRealm, JSDynamicObject> intrinsicDefaultProto) {
        this.constructorNode = constructorNode;
        this.intrinsicDefaultProto = intrinsicDefaultProto;
        this.getPrototypeNode = PropertyGetNode.create(JSObject.PROTOTYPE, false, context);
        this.isObjectNode = IsJSObjectNode.create();
    }

    public static GetPrototypeFromConstructorNode create(JSContext context, JavaScriptNode constructorNode, CompilableFunction<JSRealm, JSDynamicObject> intrinsicDefaultProto) {
        return new GetPrototypeFromConstructorNode(context, constructorNode, intrinsicDefaultProto);
    }

    @Override
    public JSDynamicObject execute(VirtualFrame frame) {
        Object constructor = this.constructorNode.execute(frame);
        return this.executeWithConstructor((JSDynamicObject)constructor);
    }

    public JSDynamicObject executeWithConstructor(JSDynamicObject constructor) {
        assert (JSRuntime.isCallable(constructor));
        Object proto = this.getPrototypeNode.getValue(constructor);
        if (this.isObjectNode.executeBoolean(proto)) {
            assert (JSRuntime.isObject(proto));
            return (JSDynamicObject)proto;
        }
        JSRealm realm = JSRuntime.getFunctionRealm(constructor, this.getRealm());
        return (JSDynamicObject)this.intrinsicDefaultProto.apply(realm);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == JSDynamicObject.class;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new GetPrototypeFromConstructorNode(this.getPrototypeNode.getContext(), GetPrototypeFromConstructorNode.cloneUninitialized(this.constructorNode, materializedTags), this.intrinsicDefaultProto);
    }
}

