/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Assumption;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Property;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GlobalScopeLookupNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Dead;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSProperty;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSShape;

public abstract class GlobalScopeLookupNode
extends JavaScriptBaseNode {
    final TruffleString varName;
    final boolean write;

    GlobalScopeLookupNode(TruffleString varName, boolean write) {
        this.varName = varName;
        this.write = write;
    }

    public static GlobalScopeLookupNode create(TruffleString varName, boolean write) {
        return GlobalScopeLookupNodeGen.create(varName, write);
    }

    public abstract boolean execute(Object var1);

    @Specialization(assumptions={"assumption"})
    static boolean doAbsent(JSDynamicObject scope, @Cached(value="getAbsentPropertyAssumption(scope.getShape())") Assumption assumption) {
        return false;
    }

    @Specialization(guards={"scope.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="cacheLimit", replaces={"doAbsent"})
    final boolean doCached(JSDynamicObject scope, @Cached(value="scope.getShape()") Shape cachedShape, @Cached(value="cachedShape.hasProperty(varName)") boolean exists, @Cached(value="isDead(cachedShape)") boolean dead, @Cached(value="isConstAssignment(cachedShape)") boolean constAssignment, @Cached(value="getPropertyCacheLimit()") int cacheLimit) {
        assert (!exists || dead == (JSDynamicObject.getOrNull(scope, this.varName) == Dead.instance()));
        if (dead) {
            throw Errors.createReferenceErrorNotDefined(this.varName, this);
        }
        if (constAssignment) {
            throw Errors.createTypeErrorConstReassignment(this.varName, this);
        }
        return exists;
    }

    protected int getPropertyCacheLimit() {
        return this.getLanguage().getJSContext().getPropertyCacheLimit();
    }

    @Specialization(replaces={"doCached"})
    final boolean doUncached(JSDynamicObject scope, @Cached InlinedBranchProfile errorBranch) {
        Property property = scope.getShape().getProperty(this.varName);
        if (property != null) {
            if (JSDynamicObject.getOrNull(scope, this.varName) == Dead.instance()) {
                errorBranch.enter(this);
                throw Errors.createReferenceErrorNotDefined(this.varName, this);
            }
            if (this.write && JSProperty.isConst(property)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorConstReassignment(this.varName, this);
            }
            return true;
        }
        return false;
    }

    final boolean isDead(Shape shape) {
        Property property = shape.getProperty(this.varName);
        assert (property == null || !property.getLocation().isConstant() || property.getLocation().getConstantValue() == Dead.instance());
        return property != null && property.getLocation().isConstant();
    }

    final boolean isConstAssignment(Shape shape) {
        if (this.write) {
            Property property = shape.getProperty(this.varName);
            return property != null && JSProperty.isConst(property);
        }
        return false;
    }

    @NeverDefault
    final Assumption getAbsentPropertyAssumption(Shape shape) {
        Property property = shape.getProperty(this.varName);
        if (property == null) {
            return JSShape.getPropertyAssumption(shape, this.varName);
        }
        return Assumption.NEVER_VALID;
    }
}

