/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Executed;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.StandardTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSGuardDisconnectedArgumentWriteNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.WriteElementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.WriteNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArgumentsArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArgumentsArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;

public abstract class JSGuardDisconnectedArgumentWrite
extends JavaScriptNode
implements WriteNode {
    private final int argumentIndex;
    @Node.Child
    @Executed
    JavaScriptNode argumentsArrayNode;
    @Node.Child
    @Executed
    JavaScriptNode rhsNode;
    @Node.Child
    private WriteElementNode writeArgumentsElementNode;
    private final TruffleString name;

    JSGuardDisconnectedArgumentWrite(int index, WriteElementNode argumentsArrayAccess, JavaScriptNode argumentsArray, JavaScriptNode rhs, TruffleString name) {
        this.argumentIndex = index;
        this.argumentsArrayNode = argumentsArray;
        this.rhsNode = rhs;
        this.writeArgumentsElementNode = argumentsArrayAccess;
        this.name = name;
    }

    public static JSGuardDisconnectedArgumentWrite create(int index, WriteElementNode argumentsArrayAccess, JavaScriptNode argumentsArray, JavaScriptNode rhs, TruffleString name) {
        return JSGuardDisconnectedArgumentWriteNodeGen.create(index, argumentsArrayAccess, argumentsArray, rhs, name);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.WriteVariableTag.class || tag == StandardTags.WriteVariableTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor("name", this.name);
        descriptor.addProperty("writeVariableName", this.name);
        return descriptor;
    }

    @Specialization(guards={"!isArgumentsDisconnected(argumentsArray)"})
    public Object doObject(JSArgumentsObject argumentsArray, Object value, @Cached @Cached.Shared InlinedConditionProfile unconnected) {
        assert (JSArgumentsArray.isJSArgumentsObject(argumentsArray));
        if (unconnected.profile(this, this.argumentIndex >= JSAbstractArgumentsArray.getConnectedArgumentCount(argumentsArray))) {
            JSAbstractArgumentsArray.disconnectIndex(argumentsArray, this.argumentIndex, value);
        } else {
            this.writeArgumentsElementNode.executeWithTargetAndIndexAndValue((Object)argumentsArray, this.argumentIndex, value);
        }
        return value;
    }

    @Specialization(guards={"isArgumentsDisconnected(argumentsArray)"})
    public Object doObjectDisconnected(JSArgumentsObject argumentsArray, Object value, @Cached @Cached.Exclusive InlinedConditionProfile wasDisconnected, @Cached @Cached.Shared InlinedConditionProfile unconnected) {
        assert (JSArgumentsArray.isJSArgumentsObject(argumentsArray));
        if (wasDisconnected.profile(this, JSAbstractArgumentsArray.wasIndexDisconnected(argumentsArray, this.argumentIndex))) {
            JSAbstractArgumentsArray.setDisconnectedIndexValue(argumentsArray, this.argumentIndex, value);
        } else if (unconnected.profile(this, this.argumentIndex >= JSAbstractArgumentsArray.getConnectedArgumentCount(argumentsArray))) {
            JSAbstractArgumentsArray.disconnectIndex(argumentsArray, this.argumentIndex, value);
        } else {
            this.writeArgumentsElementNode.executeWithTargetAndIndexAndValue((Object)argumentsArray, this.argumentIndex, value);
        }
        return value;
    }

    @Override
    public final void executeWrite(VirtualFrame frame, Object value) {
        this.executeWrite(frame, this.argumentsArrayNode.execute(frame), value);
    }

    protected abstract void executeWrite(VirtualFrame var1, Object var2, Object var3);

    @Override
    public JavaScriptNode getRhs() {
        return this.rhsNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSGuardDisconnectedArgumentWriteNodeGen.create(this.argumentIndex, JSGuardDisconnectedArgumentWrite.cloneUninitialized(this.writeArgumentsElementNode, materializedTags), JSGuardDisconnectedArgumentWrite.cloneUninitialized(this.argumentsArrayNode, materializedTags), JSGuardDisconnectedArgumentWrite.cloneUninitialized(this.rhsNode, materializedTags), this.name);
    }
}

