/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;

@ImportStatic(value={JSArray.class, JSConfig.class})
@GenerateInline(value=true)
@GenerateCached(value=false)
public abstract class ArrayBufferByteLengthNode
extends JavaScriptBaseNode {
    public abstract int execute(Node var1, JSArrayBufferObject var2, JSContext var3);

    @Specialization
    protected static int heapArrayBuffer(JSArrayBufferObject.Heap thisObj, JSContext context) {
        if (!context.getTypedArrayNotDetachedAssumption().isValid() && thisObj.getByteArray() == null) {
            return 0;
        }
        return thisObj.getByteLength();
    }

    @Specialization
    protected static int directArrayBuffer(JSArrayBufferObject.Direct thisObj, JSContext context) {
        if (!context.getTypedArrayNotDetachedAssumption().isValid() && thisObj.getByteBuffer() == null) {
            return 0;
        }
        return thisObj.getByteLength();
    }

    @Specialization
    protected static int sharedArrayBuffer(JSArrayBufferObject.Shared thisObj, JSContext context) {
        return thisObj.getByteLength();
    }

    @Specialization
    protected static int interopArrayBuffer(JSArrayBufferObject.Interop thisObj, JSContext context, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
        Object buffer = thisObj.getInteropBuffer();
        if (!context.getTypedArrayNotDetachedAssumption().isValid() && buffer == null) {
            return 0;
        }
        try {
            long bufferSize = interop.getBufferSize(buffer);
            assert (JSRuntime.longIsRepresentableAsInt(bufferSize)) : bufferSize;
            return (int)bufferSize;
        }
        catch (UnsupportedMessageException e2) {
            return 0;
        }
    }
}

