/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.ArrayCreateNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@ImportStatic(value={JSRuntime.class, Integer.class})
public abstract class ArrayCreateNode
extends JavaScriptBaseNode {
    private final JSContext context;

    protected ArrayCreateNode(JSContext context) {
        this.context = context;
    }

    @NeverDefault
    public static ArrayCreateNode create(JSContext context) {
        return ArrayCreateNodeGen.create(context);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length <= MAX_VALUE"})
    protected final JSArrayObject doDefault(long length, JSRealm realm, JSDynamicObject proto) {
        return JSArray.createEmptyChecked(this.context, realm, proto, length);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length > MAX_VALUE"})
    protected final JSArrayObject doLargeLength(long length, JSRealm realm, JSDynamicObject proto) {
        return JSArray.createSparseArray(this.context, realm, proto, length);
    }

    @Specialization(guards={"!isValidArrayLength(length)"})
    protected final JSArrayObject doInvalidLength(long length, JSRealm realm, JSDynamicObject proto) {
        throw Errors.createRangeErrorInvalidArrayLength(this);
    }

    public final JSArrayObject execute(long length) {
        JSRealm realm = this.getRealm();
        return this.execute(length, realm, realm.getArrayPrototype());
    }

    public abstract JSArrayObject execute(long var1, JSRealm var3, JSDynamicObject var4);
}

