/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSArrayElementIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSArrayPreviousElementIndexNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;

public abstract class JSArrayPreviousElementIndexNode
extends JSArrayElementIndexNode {
    protected JSArrayPreviousElementIndexNode(JSContext context) {
        super(context);
    }

    @NeverDefault
    public static JSArrayPreviousElementIndexNode create(JSContext context) {
        return JSArrayPreviousElementIndexNodeGen.create(context);
    }

    public final long executeLong(Object object, long currentIndex) {
        return this.executeLong(object, currentIndex, this.isArray(object));
    }

    public abstract long executeLong(Object var1, long var2, boolean var4);

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "getArrayType(object) == cachedArrayType", "!cachedArrayType.hasHoles(object)"}, limit="MAX_CACHED_ARRAY_TYPES")
    public long doWithoutHolesCached(JSDynamicObject object, long currentIndex, boolean isArray, @Cached(value="getArrayTypeIfArray(object, isArray)") ScriptArray cachedArrayType) {
        assert (JSArrayPreviousElementIndexNode.isSupportedArray(object) && cachedArrayType == JSArrayPreviousElementIndexNode.getArrayType(object));
        return cachedArrayType.previousElementIndex(object, currentIndex);
    }

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "!hasHoles(object)"}, replaces={"doWithoutHolesCached"})
    public long doWithoutHolesUncached(JSDynamicObject object, long currentIndex, boolean isArray) {
        assert (JSArrayPreviousElementIndexNode.isSupportedArray(object));
        return JSArrayPreviousElementIndexNode.getArrayType(object).previousElementIndex(object, currentIndex);
    }

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "getArrayType(object) == cachedArrayType", "cachedArrayType.hasHoles(object)"}, limit="MAX_CACHED_ARRAY_TYPES")
    public long previousWithHolesCached(JSDynamicObject object, long currentIndex, boolean isArray, @Bind(value="this") Node node, @Cached(value="getArrayTypeIfArray(object, isArray)") ScriptArray cachedArrayType, @Cached(value="create(context)") @Cached.Shared JSArrayPreviousElementIndexNode previousElementIndexNode, @Cached @Cached.Shared InlinedConditionProfile isMinusOne) {
        assert (JSArrayPreviousElementIndexNode.isSupportedArray(object) && cachedArrayType == JSArrayPreviousElementIndexNode.getArrayType(object));
        return this.holesArrayImpl(object, currentIndex, isArray, cachedArrayType, node, previousElementIndexNode, isMinusOne);
    }

    @Specialization(guards={"isArray", "hasPrototypeElements(object) || hasHoles(object)"}, replaces={"previousWithHolesCached"})
    public long previousWithHolesUncached(JSDynamicObject object, long currentIndex, boolean isArray, @Cached(value="create(context)") @Cached.Shared JSArrayPreviousElementIndexNode previousElementIndexNode, @Cached @Cached.Shared InlinedConditionProfile isMinusOne, @Cached InlinedExactClassProfile arrayTypeProfile) {
        assert (JSArrayPreviousElementIndexNode.isSupportedArray(object));
        ScriptArray arrayType = arrayTypeProfile.profile(this, JSArrayPreviousElementIndexNode.getArrayType(object));
        return this.holesArrayImpl(object, currentIndex, isArray, arrayType, this, previousElementIndexNode, isMinusOne);
    }

    private long holesArrayImpl(JSDynamicObject object, long currentIndex, boolean isArray, ScriptArray array, Node node, JSArrayPreviousElementIndexNode previousElementIndexNode, InlinedConditionProfile isMinusOne) {
        long minusOne;
        long previousIndex = array.previousElementIndex(object, currentIndex);
        if (isMinusOne.profile(node, previousIndex == (minusOne = currentIndex - 1L))) {
            return previousIndex;
        }
        if (!this.context.getArrayPrototypeNoElementsAssumption().isValid()) {
            JSDynamicObject prototype = JSObject.getPrototype(object);
            while (prototype != Null.instance) {
                long candidate = previousElementIndexNode.executeLong(prototype, currentIndex);
                if (minusOne >= candidate && candidate >= -1L) {
                    previousIndex = Math.max(previousIndex, candidate);
                }
                prototype = JSObject.getPrototype(prototype);
            }
        }
        return previousIndex;
    }

    @Specialization(guards={"!isArray", "isSuitableForEnumBasedProcessingUsingOwnKeys(object, currentIndex)"})
    public long previousObjectViaEnumeration(JSDynamicObject object, long currentIndex, boolean isArray, @Cached @Cached.Shared JSHasPropertyNode hasPropertyNode) {
        long currentIndexMinusOne = currentIndex - 1L;
        if (hasPropertyNode.executeBoolean((Object)object, currentIndexMinusOne)) {
            return currentIndexMinusOne;
        }
        return JSArrayPreviousElementIndexNode.previousObjectViaEnumerationIntl(object, currentIndex);
    }

    @Specialization(guards={"!isArray", "!isSuitableForEnumBasedProcessingUsingOwnKeys(object, currentIndex)", "isSuitableForEnumBasedProcessing(object, currentIndex)"})
    public long previousObjectViaFullEnumeration(JSDynamicObject object, long currentIndex, boolean isArray, @Cached @Cached.Shared JSHasPropertyNode hasPropertyNode) {
        long currentIndexMinusOne = currentIndex - 1L;
        if (hasPropertyNode.executeBoolean((Object)object, currentIndexMinusOne)) {
            return currentIndexMinusOne;
        }
        return JSArrayPreviousElementIndexNode.previousObjectViaFullEnumerationIntl(object, currentIndex);
    }

    @Specialization(guards={"!isArray", "!isSuitableForEnumBasedProcessing(object, currentIndex)"})
    public long previousObjectViaIteration(Object object, long currentIndex, boolean isArray, @Cached @Cached.Shared JSHasPropertyNode hasPropertyNode) {
        long index;
        for (index = currentIndex - 1L; index >= 0L && !hasPropertyNode.executeBoolean(object, index); --index) {
        }
        return index;
    }

    @CompilerDirectives.TruffleBoundary
    private static long previousObjectViaEnumerationIntl(JSDynamicObject object, long currentIndex) {
        long result = -1L;
        for (Object key : JSObject.ownPropertyKeys(object)) {
            TruffleString indexStr;
            long candidate;
            if (key == null || !(key instanceof TruffleString) || (candidate = JSRuntime.propertyNameToIntegerIndex(indexStr = (TruffleString)key)) >= currentIndex || candidate <= result) continue;
            result = candidate;
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static long previousObjectViaFullEnumerationIntl(JSDynamicObject object, long currentIndex) {
        long result = -1L;
        JSDynamicObject chainObject = object;
        do {
            result = Math.max(result, JSArrayPreviousElementIndexNode.previousObjectViaEnumerationIntl(chainObject, currentIndex));
        } while ((chainObject = JSObject.getPrototype(chainObject)) != Null.instance);
        return result;
    }
}

