/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ReadElementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

public abstract class JSArrayToDenseObjectArrayNode
extends JavaScriptBaseNode {
    protected JSArrayToDenseObjectArrayNode() {
    }

    public abstract Object[] executeObjectArray(JSArrayObject var1, ScriptArray var2, long var3);

    @Specialization(guards={"cachedArrayType.isInstance(arrayType)", "!cachedArrayType.isHolesType()"}, limit="5")
    protected static Object[] fromDenseArray(JSArrayObject array, ScriptArray arrayType, long length, @Cached(value="arrayType") ScriptArray cachedArrayType, @Cached(value="create(getJSContext())") @Cached.Shared ReadElementNode readNode) {
        assert (JSRuntime.longIsRepresentableAsInt(length));
        long start = cachedArrayType.firstElementIndex(array);
        long end = cachedArrayType.lastElementIndex(array) + 1L;
        Object[] arr = new Object[(int)(end - start)];
        int toIndex = 0;
        for (long fromIndex = start; fromIndex < end; ++fromIndex) {
            assert (cachedArrayType.hasElement(array, fromIndex));
            Object value = readNode.executeWithTargetAndIndex((Object)array, fromIndex);
            arr[toIndex++] = value;
        }
        return arr;
    }

    @Specialization(guards={"cachedArrayType.isInstance(arrayType)", "cachedArrayType.isHolesType()"}, limit="5")
    protected static Object[] fromSparseArray(JSArrayObject array, ScriptArray arrayType, long length, @Cached(value="arrayType") ScriptArray cachedArrayType, @Bind(value="this") Node node, @Cached(value="create(getJSContext())") @Cached.Shared JSArrayNextElementIndexNode nextElementIndexNode, @Cached @Cached.Shared InlinedBranchProfile growProfile) {
        long pos = cachedArrayType.firstElementIndex(array);
        SimpleArrayList<Object> list = new SimpleArrayList<Object>();
        while (pos <= cachedArrayType.lastElementIndex(array)) {
            assert (cachedArrayType.hasElement(array, pos));
            list.add(cachedArrayType.getElement(array, pos), node, growProfile);
            pos = nextElementIndexNode.executeLong(array, pos, length);
        }
        return list.toArray(new Object[list.size()]);
    }

    @Specialization(replaces={"fromDenseArray", "fromSparseArray"})
    protected Object[] doUncached(JSArrayObject array, ScriptArray arrayType, long length, @Cached(value="create(getJSContext())") @Cached.Shared JSArrayNextElementIndexNode nextElementIndexNode, @Cached(value="create(getJSContext())") @Cached.Shared ReadElementNode readNode, @Cached @Cached.Shared InlinedBranchProfile growProfile) {
        if (arrayType.isHolesType()) {
            return JSArrayToDenseObjectArrayNode.fromSparseArray(array, arrayType, length, arrayType, this, nextElementIndexNode, growProfile);
        }
        return JSArrayToDenseObjectArrayNode.fromDenseArray(array, arrayType, length, arrayType, readNode);
    }
}

