/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.Truncatable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBitwiseAndConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBitwiseAndNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName="&")
public abstract class JSBitwiseAndNode
extends JSBinaryNode {
    protected JSBitwiseAndNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
            return JSBitwiseAndConstantNode.create(left, rightValue);
        }
        Truncatable.truncate(right);
        return JSBitwiseAndNodeGen.create(left, right);
    }

    public abstract Object executeObject(Object var1, Object var2);

    @Specialization
    protected int doInteger(int a2, int b2) {
        return a2 & b2;
    }

    @Specialization
    protected int doSafeIntegerInt(SafeInteger a2, int b2) {
        return this.doInteger(a2.intValue(), b2);
    }

    @Specialization
    protected int doIntSafeInteger(int a2, SafeInteger b2) {
        return this.doInteger(a2, b2.intValue());
    }

    @Specialization
    protected int doSafeInteger(SafeInteger a2, SafeInteger b2) {
        return this.doInteger(a2.intValue(), b2.intValue());
    }

    @Specialization
    protected int doDouble(double a2, double b2, @Cached JSToInt32Node leftInt32, @Cached JSToInt32Node rightInt32) {
        return this.doInteger(leftInt32.executeInt(a2), rightInt32.executeInt(b2));
    }

    @Specialization
    protected BigInt doBigInt(BigInt a2, BigInt b2) {
        return a2.and(b2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_AMPERSAND;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doInteger", "doIntSafeInteger", "doSafeIntegerInt", "doSafeInteger", "doDouble", "doBigInt"})
    protected static Object doGeneric(Object a2, Object b2, @Bind(value="this") Node node, @Cached JSToNumericNode leftNumeric, @Cached JSToNumericNode rightNumeric, @Cached(value="createInner()") JSBitwiseAndNode and, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object left = leftNumeric.execute(a2);
        Object right = rightNumeric.execute(b2);
        JSBitwiseAndNode.ensureBothSameNumericType(left, right, node, mixedNumericTypes);
        return and.executeObject(left, right);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSBitwiseAndNodeGen.create(JSBitwiseAndNode.cloneUninitialized(this.getLeft(), materializedTags), JSBitwiseAndNode.cloneUninitialized(this.getRight(), materializedTags));
    }

    public static final JSBitwiseAndNode createInner() {
        return JSBitwiseAndNodeGen.create(null, null);
    }
}

