/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSCompareNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSEqualNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.LongToBigIntNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSIsNullOrUndefinedNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;

@NodeInfo(shortName="==")
@ImportStatic(value={JSRuntime.class, JSInteropUtil.class, JSConfig.class})
public abstract class JSEqualNode
extends JSCompareNode {
    protected JSEqualNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @NeverDefault
    public static JSEqualNode create() {
        return JSEqualNodeGen.create(null, null);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        boolean rightIs;
        boolean leftIs = left instanceof JSConstantNode.JSConstantUndefinedNode || left instanceof JSConstantNode.JSConstantNullNode;
        boolean bl = rightIs = right instanceof JSConstantNode.JSConstantUndefinedNode || right instanceof JSConstantNode.JSConstantNullNode;
        if (leftIs) {
            if (rightIs) {
                return JSConstantNode.createBoolean(true);
            }
            return JSIsNullOrUndefinedNode.createFromEquals(left, right);
        }
        if (rightIs) {
            return JSIsNullOrUndefinedNode.createFromEquals(left, right);
        }
        return JSEqualNodeGen.create(left, right);
    }

    public static JavaScriptNode createUnoptimized(JavaScriptNode left, JavaScriptNode right) {
        return JSEqualNodeGen.create(left, right);
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    @Specialization
    protected static boolean doInt(int a2, int b2) {
        return a2 == b2;
    }

    @Specialization
    protected static boolean doIntBoolean(int a2, boolean b2) {
        return a2 == (b2 ? 1 : 0);
    }

    @Specialization
    protected static boolean doLong(long a2, long b2) {
        return a2 == b2;
    }

    @Specialization
    protected static boolean doDouble(double a2, double b2) {
        return a2 == b2;
    }

    @Specialization
    protected static boolean doBigInt(BigInt a2, BigInt b2) {
        return a2.compareTo(b2) == 0;
    }

    @Specialization
    protected static boolean doDoubleString(double a2, TruffleString b2, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSEqualNode.doDouble(a2, stringToDouble.execute(b2));
    }

    @Specialization
    protected static boolean doDoubleBoolean(double a2, boolean b2) {
        return JSEqualNode.doDouble(a2, b2 ? 1.0 : 0.0);
    }

    @Specialization
    protected static boolean doBoolean(boolean a2, boolean b2) {
        return a2 == b2;
    }

    @Specialization
    protected static boolean doBooleanInt(boolean a2, int b2) {
        return (a2 ? 1 : 0) == b2;
    }

    @Specialization
    protected static boolean doBooleanDouble(boolean a2, double b2) {
        return JSEqualNode.doDouble(a2 ? 1.0 : 0.0, b2);
    }

    @Specialization
    protected static boolean doBooleanString(boolean a2, TruffleString b2, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSEqualNode.doBooleanDouble(a2, stringToDouble.execute(b2));
    }

    @Specialization(guards={"isReferenceEquals(a, b)"})
    protected static boolean doStringIdentity(TruffleString a2, TruffleString b2) {
        return true;
    }

    @Specialization(replaces={"doStringIdentity"})
    protected static boolean doString(TruffleString a2, TruffleString b2, @Cached TruffleString.EqualNode equalsNode) {
        return Strings.equals(equalsNode, a2, b2);
    }

    @Specialization
    protected static boolean doStringDouble(TruffleString a2, double b2, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSEqualNode.doDouble(stringToDouble.execute(a2), b2);
    }

    @Specialization
    protected static boolean doStringBoolean(TruffleString a2, boolean b2, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSEqualNode.doDoubleBoolean(stringToDouble.execute(a2), b2);
    }

    @Specialization
    protected static boolean doStringBigInt(TruffleString a2, BigInt b2) {
        BigInt aBigInt = JSRuntime.stringToBigInt(a2);
        return aBigInt != null ? aBigInt.compareTo(b2) == 0 : false;
    }

    @Specialization
    protected static boolean doBigIntString(BigInt a2, TruffleString b2) {
        return JSEqualNode.doStringBigInt(b2, a2);
    }

    @Specialization
    protected static boolean doBooleanBigInt(boolean a2, BigInt b2) {
        return JSEqualNode.doBigInt(a2 ? BigInt.ONE : BigInt.ZERO, b2);
    }

    @Specialization
    protected static boolean doBigIntBoolean(BigInt a2, boolean b2) {
        return JSEqualNode.doBooleanBigInt(b2, a2);
    }

    @Specialization(guards={"isNullOrUndefined(a)", "isNullOrUndefined(b)"})
    protected static boolean doBothNullOrUndefined(Object a2, Object b2) {
        return true;
    }

    @Specialization(guards={"isNullOrUndefined(a)"})
    protected static boolean doLeftNullOrUndefined(Object a2, Object b2, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary bInterop) {
        return JSEqualNode.isNullish(b2, bInterop);
    }

    @Specialization(guards={"isNullOrUndefined(b)"})
    protected static boolean doRightNullOrUndefined(Object a2, Object b2, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary aInterop) {
        return JSEqualNode.isNullish(a2, aInterop);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected static boolean doOverloaded(Object a2, Object b2, @Bind(value="this") Node node, @Cached(value="createHintDefault(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
        if (a2 == b2) {
            return true;
        }
        return toBooleanNode.executeBoolean(node, overloadedOperatorNode.execute(a2, b2));
    }

    protected static TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_EQUALS_EQUALS;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"})
    protected static boolean doJSObject(JSObject a2, JSDynamicObject b2) {
        return a2 == b2;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"})
    protected static boolean doJSObject(JSDynamicObject a2, JSObject b2) {
        return a2 == b2;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!hasOverloadedOperators(a)", "isPrimitiveNode.executeBoolean(b)"})
    protected static boolean doJSObjectVsPrimitive(JSObject a2, Object b2, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary bInterop, @Cached.Shared @Cached(value="createHintDefault()") JSToPrimitiveNode toPrimitiveNode, @Cached.Shared @Cached IsPrimitiveNode isPrimitiveNode, @Cached.Shared @Cached JSEqualNode nestedEqualNode) {
        if (JSEqualNode.isNullish(b2, bInterop)) {
            return false;
        }
        return nestedEqualNode.executeBoolean(toPrimitiveNode.execute(a2), b2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!hasOverloadedOperators(b)", "isPrimitiveNode.executeBoolean(a)"})
    protected static boolean doJSObjectVsPrimitive(Object a2, JSObject b2, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary aInterop, @Cached.Shared @Cached(value="createHintDefault()") JSToPrimitiveNode toPrimitiveNode, @Cached.Shared @Cached IsPrimitiveNode isPrimitiveNode, @Cached.Shared @Cached JSEqualNode nestedEqualNode) {
        if (JSEqualNode.isNullish(a2, aInterop)) {
            return false;
        }
        return nestedEqualNode.executeBoolean(a2, toPrimitiveNode.execute(b2));
    }

    @Specialization
    protected static boolean doBigIntAndInt(BigInt a2, int b2) {
        return a2.compareValueTo(b2) == 0;
    }

    @Specialization
    protected static boolean doBigIntAndNumber(BigInt a2, double b2) {
        if (Double.isNaN(b2)) {
            return false;
        }
        return a2.compareValueTo(b2) == 0;
    }

    @Specialization
    protected static boolean doIntAndBigInt(int a2, BigInt b2) {
        return b2.compareValueTo(a2) == 0;
    }

    @Specialization
    protected static boolean doNumberAndBigInt(double a2, BigInt b2) {
        return JSEqualNode.doBigIntAndNumber(b2, a2);
    }

    @Specialization
    protected static boolean doSymbol(Symbol a2, Symbol b2) {
        return a2 == b2;
    }

    @Specialization(guards={"!isSymbol(b)", "!isObjectNode.executeBoolean(b)"})
    protected static boolean doSymbolNotSymbol(Symbol a2, Object b2, @Cached.Shared @Cached IsObjectNode isObjectNode) {
        return false;
    }

    @Specialization(guards={"!isSymbol(a)", "!isObjectNode.executeBoolean(a)"})
    protected static boolean doSymbolNotSymbol(Object a2, Symbol b2, @Cached.Shared @Cached IsObjectNode isObjectNode) {
        return false;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isAForeign || isBForeign"})
    protected final boolean doForeign(Object a2, Object b2, @Bind(value="isForeignObjectOrNumber(a)") boolean isAForeign, @Bind(value="isForeignObjectOrNumber(b)") boolean isBForeign, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary aInterop, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary bInterop, @Cached.Shared @Cached(value="createHintDefault()") JSToPrimitiveNode toPrimitiveNode, @Cached.Shared @Cached IsPrimitiveNode isPrimitiveNode, @Cached.Shared @Cached JSEqualNode nestedEqualNode, @Cached LongToBigIntNode longToBigIntA, @Cached LongToBigIntNode longToBigIntB) {
        Object primB;
        assert (a2 != null && b2 != null);
        if (JSEqualNode.isNullish(a2, aInterop)) {
            return JSEqualNode.isNullish(b2, bInterop);
        }
        if (JSEqualNode.isNullish(b2, bInterop)) {
            assert (!JSEqualNode.isNullish(a2, bInterop));
            return false;
        }
        boolean isAPrimitive = isPrimitiveNode.executeBoolean(a2);
        boolean isBPrimitive = isPrimitiveNode.executeBoolean(b2);
        if (!isAPrimitive && !isBPrimitive) {
            return aInterop.isIdentical(a2, b2, bInterop);
        }
        Object primA = !isAPrimitive || isAForeign ? toPrimitiveNode.execute(a2) : a2;
        Object object = primB = !isBPrimitive || isBForeign ? toPrimitiveNode.execute(b2) : b2;
        assert (!JSGuards.isForeignObject(primA) && !JSGuards.isForeignObject(primB));
        primA = longToBigIntA.execute(this, primA);
        primB = longToBigIntB.execute(this, primB);
        return nestedEqualNode.executeBoolean(primA, primB);
    }

    @Fallback
    protected static boolean doFallback(Object a2, Object b2) {
        assert (!JSRuntime.equal(a2, b2)) : String.valueOf(a2) + " (" + String.valueOf(a2 == null ? "null" : a2.getClass()) + "), " + String.valueOf(b2) + " (" + String.valueOf(b2 == null ? "null" : b2.getClass()) + ")";
        return false;
    }

    protected static boolean isNullish(Object value, InteropLibrary interop) {
        return JSRuntime.isNullOrUndefined(value) || interop.isNull(value);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSEqualNodeGen.create(JSEqualNode.cloneUninitialized(this.getLeft(), materializedTags), JSEqualNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

