/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSExponentiateNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName="**")
public abstract class JSExponentiateNode
extends JSBinaryNode {
    protected JSExponentiateNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSExponentiateNodeGen.create(left, right);
    }

    public static JSExponentiateNode create() {
        return (JSExponentiateNode)JSExponentiateNode.create(null, null);
    }

    public abstract Object execute(Object var1, Object var2);

    @Specialization
    protected double doDouble(double a2, double b2) {
        return Math.pow(a2, b2);
    }

    @Specialization(guards={"isBigIntNegativeVal(b)"})
    protected void doBigIntNegativeExponent(BigInt a2, BigInt b2) {
        throw Errors.createRangeError("Exponent must be positve");
    }

    @Specialization(guards={"isBigIntZero(a)", "!isBigIntZero(b)", "!isBigIntNegativeVal(b)"})
    protected BigInt doBigIntZero(BigInt a2, BigInt b2) {
        return BigInt.ZERO;
    }

    @Specialization(guards={"isBigIntZero(b)"})
    protected BigInt doBigIntZeroPowZero(BigInt a2, BigInt b2) {
        return BigInt.ONE;
    }

    @Specialization(guards={"!isBigIntZero(a)", "!isBigIntZero(b)", "!isBigIntNegativeVal(b)"})
    @CompilerDirectives.TruffleBoundary
    protected BigInt doBigInt(BigInt a2, BigInt b2) {
        if (b2.compareTo(BigInt.MAX_INT) < 0) {
            try {
                return a2.pow(b2.intValue());
            }
            catch (ArithmeticException ae) {
                throw Errors.createRangeErrorBigIntMaxSizeExceeded();
            }
        }
        if (a2.compareTo(BigInt.ONE) == 0) {
            return BigInt.ONE;
        }
        if (a2.compareTo(BigInt.NEGATIVE_ONE) == 0) {
            return b2.testBit(0) ? BigInt.NEGATIVE_ONE : BigInt.ONE;
        }
        throw Errors.createRangeErrorBigIntMaxSizeExceeded();
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_STAR_STAR;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doDouble"})
    protected static Object doGeneric(Object a2, Object b2, @Bind(value="this") Node node, @Cached JSExponentiateNode nestedExponentiateNode, @Cached JSToNumericNode toNumeric1Node, @Cached JSToNumericNode toNumeric2Node, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object operandA = toNumeric1Node.execute(a2);
        Object operandB = toNumeric2Node.execute(b2);
        JSExponentiateNode.ensureBothSameNumericType(operandA, operandB, node, mixedNumericTypes);
        return nestedExponentiateNode.execute(operandA, operandB);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSExponentiateNodeGen.create(JSExponentiateNode.cloneUninitialized(this.getLeft(), materializedTags), JSExponentiateNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

