/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSCompareNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSLessThanNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringOrNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName="<")
public abstract class JSLessThanNode
extends JSCompareNode {
    protected JSLessThanNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JSLessThanNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSLessThanNodeGen.create(left, right);
    }

    public static JSLessThanNode create() {
        return JSLessThanNodeGen.create(null, null);
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    @Specialization
    protected static boolean doInt(int a2, int b2) {
        return a2 < b2;
    }

    @Specialization
    protected static boolean doSafeInteger(int a2, SafeInteger b2) {
        return (long)a2 < b2.longValue();
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger a2, int b2) {
        return a2.longValue() < (long)b2;
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger a2, SafeInteger b2) {
        return a2.longValue() < b2.longValue();
    }

    @Specialization
    protected static boolean doLong(long a2, long b2) {
        return a2 < b2;
    }

    @Specialization
    protected static boolean doDouble(double a2, double b2) {
        return a2 < b2;
    }

    @Specialization
    protected static boolean doString(TruffleString a2, TruffleString b2, @Cached TruffleString.CompareCharsUTF16Node compareNode) {
        return Strings.compareTo(compareNode, a2, b2) < 0;
    }

    @Specialization
    protected static boolean doStringDouble(TruffleString a2, double b2, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSLessThanNode.doDouble(stringToDouble.execute(a2), b2);
    }

    @Specialization
    protected static boolean doDoubleString(double a2, TruffleString b2, @Cached.Shared @Cached JSStringToNumberNode stringToDouble) {
        return JSLessThanNode.doDouble(a2, stringToDouble.execute(b2));
    }

    @Specialization
    protected static boolean doStringBigInt(TruffleString a2, BigInt b2) {
        BigInt aBigInt = JSRuntime.stringToBigInt(a2);
        return aBigInt == null ? false : JSLessThanNode.doBigInt(aBigInt, b2);
    }

    @Specialization
    protected static boolean doBigIntString(BigInt a2, TruffleString b2) {
        BigInt bBigInt = JSRuntime.stringToBigInt(b2);
        return bBigInt == null ? false : JSLessThanNode.doBigInt(a2, bBigInt);
    }

    @Specialization
    protected static boolean doBigInt(BigInt a2, BigInt b2) {
        return a2.compareTo(b2) < 0;
    }

    @Specialization
    protected static boolean doBigIntAndInt(BigInt a2, int b2) {
        return a2.compareValueTo(b2) < 0;
    }

    @Specialization
    protected static boolean doBigIntAndNumber(BigInt a2, double b2) {
        if (Double.isNaN(b2)) {
            return false;
        }
        return a2.compareValueTo(b2) < 0;
    }

    @Specialization
    protected static boolean doIntAndBigInt(int a2, BigInt b2) {
        return b2.compareValueTo(a2) > 0;
    }

    @Specialization
    protected static boolean doNumberAndBigInt(double a2, BigInt b2) {
        if (Double.isNaN(a2)) {
            return false;
        }
        return b2.compareValueTo(a2) > 0;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected static boolean doOverloaded(Object a2, Object b2, @Bind(value="this") Node node, @Cached(value="createHintNumberLeftToRight(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
        return toBooleanNode.executeBoolean(node, overloadedOperatorNode.execute(a2, b2));
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_OPEN;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doString", "doStringDouble", "doDoubleString", "doStringBigInt", "doBigIntString", "doBigInt", "doBigIntAndInt", "doIntAndBigInt", "doBigIntAndNumber", "doNumberAndBigInt"})
    protected static boolean doGeneric(Object a2, Object b2, @Cached JSToStringOrNumberNode toStringOrNumber1, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitive1, @Cached JSToStringOrNumberNode toStringOrNumber2, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitive2, @Cached JSLessThanNode lessThanNode) {
        return lessThanNode.executeBoolean(toStringOrNumber1.execute(toPrimitive1.execute(a2)), toStringOrNumber2.execute(toPrimitive2.execute(b2)));
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSLessThanNodeGen.create(JSLessThanNode.cloneUninitialized(this.getLeft(), materializedTags), JSLessThanNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

