/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanUnaryNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSNotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSNotNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;

@NodeInfo(shortName="!!")
@ImportStatic(value={JSConfig.class})
public abstract class JSToBooleanUnaryNode
extends JSUnaryNode {
    protected JSToBooleanUnaryNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        Object constantOperand;
        JSConstantNode replacement = null;
        if (child.isResultAlwaysOfType(Boolean.TYPE)) {
            return child;
        }
        if (child instanceof JSConstantNode.JSConstantIntegerNode) {
            int value = ((JSConstantNode.JSConstantIntegerNode)child).executeInt(null);
            replacement = JSConstantNode.createBoolean(value != 0);
        } else if (child instanceof JSConstantNode.JSConstantBigIntNode) {
            BigInt value = ((JSConstantNode.JSConstantBigIntNode)child).executeBigInt(null);
            replacement = JSConstantNode.createBoolean(value.compareTo(BigInt.ZERO) != 0);
        } else if (child instanceof JSConstantNode && (constantOperand = ((JSConstantNode)child).getValue()) != null && JSRuntime.isJSPrimitive(constantOperand)) {
            replacement = JSConstantNode.createBoolean(JSRuntime.toBoolean(constantOperand));
        }
        if (replacement == null) {
            return JSToBooleanUnaryNodeGen.create(child);
        }
        JavaScriptNode.transferSourceSectionAndTags(child, replacement);
        return replacement;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public abstract boolean executeBoolean(VirtualFrame var1);

    @Specialization
    protected static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static boolean doNull(Object value) {
        return false;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static boolean doUndefined(Object value) {
        return false;
    }

    @Specialization
    protected static boolean doInt(int value) {
        return value != 0;
    }

    @Specialization
    protected static boolean doLong(long value) {
        return value != 0L;
    }

    @Specialization
    protected static boolean doDouble(double value) {
        return value != 0.0 && !Double.isNaN(value);
    }

    @Specialization
    protected static boolean doBigInt(BigInt value) {
        return value.compareTo(BigInt.ZERO) != 0;
    }

    @Specialization
    protected static boolean doString(TruffleString value) {
        return Strings.length(value) != 0;
    }

    @Specialization(guards={"isJSObject(value)"})
    protected static boolean doObject(Object value) {
        return true;
    }

    @Specialization
    protected static boolean doSymbol(Symbol value) {
        return true;
    }

    @Specialization(guards={"isForeignObject(value)"})
    protected static boolean doForeignObject(Object value, @Bind(value="this") Node node, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
        return toBooleanNode.executeBoolean(node, value);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSToBooleanUnaryNodeGen.create(JSToBooleanUnaryNode.cloneUninitialized(this.getOperand(), materializedTags));
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.UnaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.UnaryOperationTag.class)) {
            JavaScriptNode newOperand = JSToBooleanUnaryNode.cloneUninitialized(this.getOperand(), materializedTags);
            JSNotNode innerNot = JSNotNodeGen.create(newOperand);
            JSNotNode outerNot = JSNotNodeGen.create(innerNot);
            JSToBooleanUnaryNode.transferSourceSectionAddExpressionTag(this, innerNot);
            JSToBooleanUnaryNode.transferSourceSectionAndTags(this, outerNot);
            return outerNot;
        }
        return this;
    }
}

