/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;

@ImportStatic(value={JSGuards.class})
public abstract class JSToIntegerWithoutRoundingNode
extends JavaScriptBaseNode {
    public final double execute(Object value) {
        return this.executeDouble(value);
    }

    public abstract double executeDouble(Object var1);

    @Specialization
    protected static double doInteger(int value) {
        return value;
    }

    @Specialization
    protected static double doLong(long value) {
        return value;
    }

    @Specialization
    protected static double doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected static double doSafeInteger(SafeInteger value) {
        return value.longValue();
    }

    @Specialization
    protected final double doDoubleInfinite(double value, @Cached InlinedBranchProfile errorBranch) {
        if (Double.isNaN(value) || value == 0.0) {
            return 0.0;
        }
        if (!JSRuntime.isIntegralNumber(value)) {
            errorBranch.enter(this);
            throw Errors.createRangeError("integral number expected");
        }
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static double doNull(Object value) {
        return 0.0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static double doUndefined(Object value) {
        return 0.0;
    }

    @Specialization
    protected final double doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected final double doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization
    protected double doString(TruffleString value, @Cached.Shared @Cached JSToIntegerWithoutRoundingNode toIntOrInf, @Cached JSStringToNumberNode stringToNumberNode) {
        return toIntOrInf.executeDouble(stringToNumberNode.execute(value));
    }

    @Specialization(guards={"isJSObject(value) || isForeignObject(value)"})
    protected double doJSOrForeignObject(Object value, @Cached.Shared @Cached JSToIntegerWithoutRoundingNode toIntOrInf, @Cached JSToNumberNode toNumberNode) {
        return toIntOrInf.executeDouble(toNumberNode.executeNumber(value));
    }
}

