/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control;

import java.util.List;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleStackTraceElement;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.DirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.TryCatchNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.YieldException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.AbstractFunctionRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.AsyncRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Completion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class AsyncFunctionBodyNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContext;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapability;
    private final AsyncFunctionRootNode resumptionRootNode;
    @Node.Child
    private volatile DirectCallNode asyncCallNode;

    public AsyncFunctionBodyNode(JSContext context, JSWriteFrameSlotNode writeAsyncContext, AsyncFunctionRootNode resumptionRootNode) {
        this.context = context;
        this.writeAsyncContext = writeAsyncContext;
        this.resumptionRootNode = resumptionRootNode;
        this.newPromiseCapability = NewPromiseCapabilityNode.create(context);
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeAsyncContext, JSReadFrameSlotNode readAsyncContext, JSWriteFrameSlotNode writeAsyncResult, SourceSection functionSourceSection, TruffleString functionName, ScriptOrModule activeScriptOrModule) {
        AsyncFunctionRootNode resumptionRootNode = new AsyncFunctionRootNode(context, body, writeAsyncResult, readAsyncContext, functionSourceSection, functionName, activeScriptOrModule);
        return new AsyncFunctionBodyNode(context, writeAsyncContext, resumptionRootNode);
    }

    private JSContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.AsyncFunction.name());
    }

    private void initializeAsyncCallTarget() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.asyncCallNode = this.insert(DirectCallNode.create(this.resumptionRootNode.getCallTarget()));
    }

    private void ensureAsyncCallTargetInitialized() {
        if (this.asyncCallNode == null) {
            this.initializeAsyncCallTarget();
        }
    }

    private void asyncFunctionStart(VirtualFrame frame, PromiseCapabilityRecord promiseCapability) {
        MaterializedFrame materializedFrame = frame.materialize();
        this.ensureAsyncCallTargetInitialized();
        this.writeAsyncContext.executeWrite(frame, AsyncRootNode.createAsyncContext(this.asyncCallNode.getCallTarget(), promiseCapability, materializedFrame));
        Object unusedInitialResult = null;
        this.asyncCallNode.call(JSArguments.createResumeArguments(materializedFrame, promiseCapability, Completion.Type.Normal, unusedInitialResult));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability.executeDefault();
        this.asyncFunctionStart(frame, promiseCapability);
        return promiseCapability.getPromise();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new AsyncFunctionBodyNode(this.getContext(), AsyncFunctionBodyNode.cloneUninitialized(this.writeAsyncContext, materializedTags), this.resumptionRootNode);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (!materializedTags.isEmpty()) {
            this.resumptionRootNode.getCallTarget();
        }
        return this;
    }

    public static final class AsyncFunctionRootNode
    extends AbstractFunctionRootNode
    implements AsyncRootNode {
        private final JSContext context;
        private final TruffleString functionName;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSReadFrameSlotNode readAsyncContext;
        @Node.Child
        private JSWriteFrameSlotNode writeAsyncResult;
        @Node.Child
        private JSFunctionCallNode callResolveNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        AsyncFunctionRootNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncResult, JSReadFrameSlotNode readAsyncContext, SourceSection functionSourceSection, TruffleString functionName, ScriptOrModule activeScriptOrModule) {
            super(context.getLanguage(), functionSourceSection, null, activeScriptOrModule);
            this.context = context;
            this.functionBody = new FunctionBodyNode(body);
            this.readAsyncContext = readAsyncContext;
            this.writeAsyncResult = asyncResult;
            this.callResolveNode = JSFunctionCallNode.createCall();
            this.functionName = functionName;
            JavaScriptNode.transferSourceSection(body, this.functionBody);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object executeInRealm(VirtualFrame frame) {
            boolean enterContext;
            JSRealm realm;
            Object[] arguments = frame.getArguments();
            MaterializedFrame asyncFrame = JSArguments.getResumeExecutionContext(arguments);
            PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)JSArguments.getResumeGeneratorOrPromiseCapability(arguments);
            Completion resumptionValue = JSArguments.getResumeCompletion(arguments);
            this.writeAsyncResult.executeWrite(asyncFrame, resumptionValue);
            JSRealm currentRealm = this.getRealm();
            if (this.context.neverCreatedChildRealms()) {
                assert (currentRealm == JSFunction.getRealm(JSFrameUtil.getFunctionObject(asyncFrame)));
                realm = currentRealm;
                enterContext = false;
            } else {
                realm = JSFunction.getRealm(JSFrameUtil.getFunctionObject(asyncFrame));
                enterContext = realm != currentRealm;
            }
            Object prev = null;
            TruffleContext childContext = null;
            if (enterContext) {
                childContext = realm.getTruffleContext();
                prev = childContext.enter(this);
            }
            try {
                Object result = this.functionBody.execute(asyncFrame);
                this.promiseCapabilityResolve(promiseCapability, result);
            }
            catch (YieldException e2) {
                assert (e2.isAwait());
            }
            catch (AbstractTruffleException e3) {
                this.promiseCapabilityReject(promiseCapability, e3);
            }
            finally {
                if (enterContext) {
                    childContext.leave(this, prev);
                }
            }
            return Undefined.instance;
        }

        private void promiseCapabilityResolve(PromiseCapabilityRecord promiseCapability, Object result) {
            this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), result));
        }

        private void promiseCapabilityReject(PromiseCapabilityRecord promiseCapability, AbstractTruffleException e2) {
            if (this.getErrorObjectNode == null || this.callRejectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.callRejectNode = this.insert(JSFunctionCallNode.createCall());
            }
            Object error = this.getErrorObjectNode.execute(e2);
            this.callRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), error));
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        @Override
        public String getName() {
            if (this.functionName != null && !this.functionName.isEmpty()) {
                return Strings.toJavaString(this.functionName);
            }
            return ":async";
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public JSDynamicObject getAsyncFunctionPromise(Frame asyncFrame, Object promiseCapability) {
            Object[] initialState = (Object[])this.readAsyncContext.execute((VirtualFrame)asyncFrame);
            assert (((RootCallTarget)initialState[0]).getRootNode() == this);
            assert (promiseCapability == initialState[1]);
            return ((PromiseCapabilityRecord)promiseCapability).getPromise();
        }

        public List<TruffleStackTraceElement> getSavedStackTrace(Frame asyncFrame) {
            Object[] initialState = (Object[])this.readAsyncContext.execute((VirtualFrame)asyncFrame);
            return (List)initialState[3];
        }

        @Override
        protected List<TruffleStackTraceElement> findAsynchronousFrames(Frame frame) {
            if (!this.context.isOptionAsyncStackTraces() || this.context.getLanguage().getAsyncStackDepth() == 0) {
                return null;
            }
            VirtualFrame asyncFrame = frame.getFrameDescriptor() == this.getFrameDescriptor() ? JSArguments.getResumeExecutionContext(frame.getArguments()) : (VirtualFrame)ScopeFrameNode.getNonBlockScopeParentFrame(frame);
            return this.getSavedStackTrace(asyncFrame);
        }
    }
}

