/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.DefaultNumberOptionNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;

public abstract class DefaultNumberOptionNode
extends JavaScriptBaseNode {
    protected DefaultNumberOptionNode() {
    }

    public abstract int executeInt(Object var1, int var2, int var3, int var4);

    public static DefaultNumberOptionNode create() {
        return DefaultNumberOptionNodeGen.create();
    }

    @Specialization(guards={"!isUndefined(value)"})
    public int getOption(Object value, int minimum, int maximum, int fallback, @Cached JSToNumberNode toNumberNode, @Cached InlinedBranchProfile errorBranch) {
        Number numValue = toNumberNode.executeNumber(value);
        double doubleValue = JSRuntime.doubleValue(numValue);
        if (Double.isNaN(doubleValue) || doubleValue < (double)minimum || (double)maximum < doubleValue) {
            errorBranch.enter(this);
            throw this.createRangeError(doubleValue, minimum, maximum);
        }
        return (int)doubleValue;
    }

    @CompilerDirectives.TruffleBoundary
    private JSException createRangeError(double value, int minimum, int maximum) throws JSException {
        return Errors.createRangeErrorFormat("invalid value %f found where only values between %d and %d are allowed", this, value, minimum, maximum);
    }

    @Specialization(guards={"isUndefined(value)"})
    public int getOptionFromUndefined(Object value, int minimum, int maximum, int fallback) {
        return fallback;
    }
}

