/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.InitializeLocaleNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class InitializeLocaleNode
extends JavaScriptBaseNode {
    private static final String MON = "mon";
    private static final String TUE = "tue";
    private static final String WED = "wed";
    private static final String THU = "thu";
    private static final String FRI = "fri";
    private static final String SAT = "sat";
    private static final String SUN = "sun";
    private static final List<String> FIRST_DAY_OF_WEEK_OPTION_VALUES = List.of("mon", "tue", "wed", "thu", "fri", "sat", "sun", "0", "1", "2", "3", "4", "5", "6", "7");
    @Node.Child
    CoerceOptionsToObjectNode coerceOptionsToObjectNode;
    @Node.Child
    GetStringOptionNode getLanguageOption;
    @Node.Child
    GetStringOptionNode getScriptOption;
    @Node.Child
    GetStringOptionNode getRegionOption;
    @Node.Child
    GetStringOptionNode getCalendarOption;
    @Node.Child
    GetStringOptionNode getCollationOption;
    @Node.Child
    GetStringOptionNode getFirstDayOfWeekOption;
    @Node.Child
    GetStringOptionNode getHourCycleOption;
    @Node.Child
    GetStringOptionNode getCaseFirstOption;
    @Node.Child
    GetBooleanOptionNode getNumericOption;
    @Node.Child
    GetStringOptionNode getNumberingSystemOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeLocaleNode(JSContext context) {
        this.coerceOptionsToObjectNode = CoerceOptionsToObjectNodeGen.create(context);
        this.getLanguageOption = GetStringOptionNode.create(context, IntlUtil.KEY_LANGUAGE, null, null);
        this.getScriptOption = GetStringOptionNode.create(context, IntlUtil.KEY_SCRIPT, null, null);
        this.getRegionOption = GetStringOptionNode.create(context, IntlUtil.KEY_REGION, null, null);
        this.getCalendarOption = GetStringOptionNode.create(context, IntlUtil.KEY_CALENDAR, null, null);
        this.getCollationOption = GetStringOptionNode.create(context, IntlUtil.KEY_COLLATION, null, null);
        this.getFirstDayOfWeekOption = GetStringOptionNode.create(context, IntlUtil.KEY_FIRST_DAY_OF_WEEK, FIRST_DAY_OF_WEEK_OPTION_VALUES, null);
        this.getHourCycleOption = GetStringOptionNode.create(context, IntlUtil.KEY_HOUR_CYCLE, GetStringOptionNode.HOUR_CYCLE_OPTION_VALUES, null);
        this.getCaseFirstOption = GetStringOptionNode.create(context, IntlUtil.KEY_CASE_FIRST, GetStringOptionNode.CASE_FIRST_OPTION_VALUES, null);
        this.getNumericOption = GetBooleanOptionNode.create(context, IntlUtil.KEY_NUMERIC, null);
        this.getNumberingSystemOption = GetStringOptionNode.create(context, IntlUtil.KEY_NUMBERING_SYSTEM, null, null);
    }

    public abstract JSLocaleObject executeInit(JSLocaleObject var1, Object var2, Object var3);

    public static InitializeLocaleNode createInitalizeLocaleNode(JSContext context) {
        return InitializeLocaleNodeGen.create(context);
    }

    @Specialization
    public JSLocaleObject initializeLocaleUsingString(JSLocaleObject localeObject, TruffleString tagArg, Object optionsArg) {
        return this.initializeLocaleUsingJString(localeObject, Strings.toJavaString(tagArg), optionsArg);
    }

    private JSLocaleObject initializeLocaleUsingJString(JSLocaleObject localeObject, String tagArg, Object optionsArg) {
        try {
            String optFirstDayOfWeek;
            String optCollation;
            Object options = this.coerceOptionsToObjectNode.execute(optionsArg);
            String tag = this.applyOptionsToTag(tagArg, options);
            String optCalendar = this.getCalendarOption.executeValue(options);
            if (optCalendar != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(optCalendar, this.errorBranch);
            }
            if ((optCollation = this.getCollationOption.executeValue(options)) != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(optCollation, this.errorBranch);
            }
            if ((optFirstDayOfWeek = this.getFirstDayOfWeekOption.executeValue(options)) != null) {
                optFirstDayOfWeek = InitializeLocaleNode.weekDayToString(optFirstDayOfWeek);
            }
            String optHourCycle = this.getHourCycleOption.executeValue(options);
            String optCaseFirst = this.getCaseFirstOption.executeValue(options);
            Boolean optNumeric = this.getNumericOption.executeValue(options);
            String optNumberingSystem = this.getNumberingSystemOption.executeValue(options);
            if (optNumberingSystem != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(optNumberingSystem, this.errorBranch);
            }
            Locale locale = InitializeLocaleNode.applyUnicodeExtensionToTag(tag, optCalendar, optCollation, optFirstDayOfWeek, optHourCycle, optCaseFirst, optNumeric, optNumberingSystem);
            JSLocale.InternalState state = localeObject.getInternalState();
            JSLocale.setupInternalState(state, locale);
        }
        catch (MissingResourceException e2) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e2);
        }
        return localeObject;
    }

    @Specialization
    public JSLocaleObject initializeLocaleUsingLocale(JSLocaleObject localeObject, JSLocaleObject tagArg, Object optionsArg) {
        JSLocale.InternalState state = tagArg.getInternalState();
        return this.initializeLocaleUsingJString(localeObject, state.getLocale(), optionsArg);
    }

    @Specialization(guards={"!isJSLocale(tagArg)"})
    public JSLocaleObject initializeLocaleUsingObject(JSLocaleObject localeObject, JSObject tagArg, Object optionsArg, @Cached JSToStringNode toStringNode) {
        return this.initializeLocaleUsingString(localeObject, toStringNode.executeString(tagArg), optionsArg);
    }

    @Specialization(guards={"!isJSObject(tagArg)", "!isString(tagArg)"})
    public JSLocaleObject initializeLocaleOther(JSLocaleObject localeObject, Object tagArg, Object optionsArg) {
        throw Errors.createTypeError("Tag should be a string or an object.");
    }

    private String applyOptionsToTag(String tag, Object options) {
        String optRegion;
        String optScript;
        String canonicalizedTag = IntlUtil.validateAndCanonicalizeLanguageTag(tag);
        String optLanguage = this.getLanguageOption.executeValue(options);
        if (optLanguage != null) {
            IntlUtil.ensureIsStructurallyValidLanguageSubtag(optLanguage);
        }
        if ((optScript = this.getScriptOption.executeValue(options)) != null) {
            IntlUtil.ensureIsStructurallyValidScriptSubtag(optScript);
        }
        if ((optRegion = this.getRegionOption.executeValue(options)) != null) {
            IntlUtil.ensureIsStructurallyValidRegionSubtag(optRegion);
        }
        return IntlUtil.validateAndCanonicalizeLanguageTag(InitializeLocaleNode.applyOptionsToTag(canonicalizedTag, optLanguage, optScript, optRegion));
    }

    @CompilerDirectives.TruffleBoundary
    private static String applyOptionsToTag(String tag, String optLanguage, String optScript, String optRegion) {
        Locale.Builder builder = new Locale.Builder().setLanguageTag(tag);
        if (optLanguage != null) {
            builder.setLanguage(optLanguage);
        }
        if (optScript != null) {
            builder.setScript(optScript);
        }
        if (optRegion != null) {
            builder.setRegion(optRegion);
        }
        return IntlUtil.maybeAppendMissingLanguageSubTag(builder.build().toLanguageTag());
    }

    @CompilerDirectives.TruffleBoundary
    private static Locale applyUnicodeExtensionToTag(String tag, String optCalendar, String optCollation, String optFirstDayOfWeek, String optHourCycle, String optCaseFirst, Boolean optNumeric, String optNumberingSystem) {
        Locale.Builder builder = new Locale.Builder().setLanguageTag(tag);
        if (optCalendar != null) {
            InitializeLocaleNode.setUnicodeLocaleKeywordHelper(builder, "ca", IntlUtil.normalizeCAType(optCalendar));
        }
        if (optCollation != null) {
            InitializeLocaleNode.setUnicodeLocaleKeywordHelper(builder, "co", optCollation);
        }
        if (optFirstDayOfWeek != null) {
            InitializeLocaleNode.setUnicodeLocaleKeywordHelper(builder, "fw", optFirstDayOfWeek);
        }
        if (optHourCycle != null) {
            InitializeLocaleNode.setUnicodeLocaleKeywordHelper(builder, "hc", optHourCycle);
        }
        if (optCaseFirst != null) {
            InitializeLocaleNode.setUnicodeLocaleKeywordHelper(builder, "kf", optCaseFirst);
        }
        if (optNumeric != null) {
            InitializeLocaleNode.setUnicodeLocaleKeywordHelper(builder, "kn", optNumeric.toString());
        }
        if (optNumberingSystem != null) {
            InitializeLocaleNode.setUnicodeLocaleKeywordHelper(builder, "nu", optNumberingSystem);
        }
        return builder.build();
    }

    private static void setUnicodeLocaleKeywordHelper(Locale.Builder builder, String key, String type) {
        builder.setUnicodeLocaleKeyword(key, "true".equals(type) ? "" : type);
    }

    private static String weekDayToString(String fw) {
        return switch (fw) {
            case "0" -> SUN;
            case "1" -> MON;
            case "2" -> TUE;
            case "3" -> WED;
            case "4" -> THU;
            case "5" -> FRI;
            case "6" -> SAT;
            case "7" -> SUN;
            default -> fw;
        };
    }

    public static int weekDayToNumber(String fw) {
        if (fw == null) {
            return -1;
        }
        return switch (fw) {
            case MON -> 1;
            case TUE -> 2;
            case WED -> 3;
            case THU -> 4;
            case FRI -> 5;
            case SAT -> 6;
            case SUN -> 7;
            default -> throw Errors.shouldNotReachHere(fw);
        };
    }
}

