/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.DefaultNumberOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetNumberOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.SetNumberFormatDigitOptionsNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class SetNumberFormatDigitOptionsNode
extends JavaScriptBaseNode {
    private static final List<String> ROUNDING_MODE_OPTION_VALUES = List.of("ceil", "floor", "expand", "trunc", "halfCeil", "halfFloor", "halfExpand", "halfTrunc", "halfEven");
    private static final List<String> ROUNDING_PRIORITY_OPTIONS_VALUES = List.of("auto", "morePrecision", "lessPrecision");
    private static final List<String> TRAILING_ZERO_DISPLAY_OPTION_VALUES = List.of("auto", "stripIfInteger");
    @Node.Child
    GetNumberOptionNode getMinIntDigitsOption;
    @Node.Child
    PropertyGetNode getMinFracDigitsOption;
    @Node.Child
    PropertyGetNode getMaxFracDigitsOption;
    @Node.Child
    PropertyGetNode getMinSignificantDigitsOption;
    @Node.Child
    PropertyGetNode getMaxSignificantDigitsOption;
    @Node.Child
    DefaultNumberOptionNode getMnsdDNO;
    @Node.Child
    DefaultNumberOptionNode getMxsdDNO;
    @Node.Child
    DefaultNumberOptionNode getMnfdDNO;
    @Node.Child
    DefaultNumberOptionNode getMxfdDNO;
    @Node.Child
    GetNumberOptionNode getRoundingIncrementOption;
    @Node.Child
    GetStringOptionNode getRoundingModeOption;
    @Node.Child
    GetStringOptionNode getRoundingPriorityOption;
    @Node.Child
    GetStringOptionNode getTrailingZeroDisplayOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected SetNumberFormatDigitOptionsNode(JSContext context) {
        this.getMinIntDigitsOption = GetNumberOptionNode.create(context, IntlUtil.KEY_MINIMUM_INTEGER_DIGITS);
        this.getMinFracDigitsOption = PropertyGetNode.create(IntlUtil.KEY_MINIMUM_FRACTION_DIGITS, context);
        this.getMaxFracDigitsOption = PropertyGetNode.create(IntlUtil.KEY_MAXIMUM_FRACTION_DIGITS, context);
        this.getMinSignificantDigitsOption = PropertyGetNode.create(IntlUtil.KEY_MINIMUM_SIGNIFICANT_DIGITS, context);
        this.getMaxSignificantDigitsOption = PropertyGetNode.create(IntlUtil.KEY_MAXIMUM_SIGNIFICANT_DIGITS, context);
        this.getMnsdDNO = DefaultNumberOptionNode.create();
        this.getMxsdDNO = DefaultNumberOptionNode.create();
        this.getMnfdDNO = DefaultNumberOptionNode.create();
        this.getMxfdDNO = DefaultNumberOptionNode.create();
        this.getRoundingIncrementOption = GetNumberOptionNode.create(context, IntlUtil.KEY_ROUNDING_INCREMENT);
        this.getRoundingModeOption = GetStringOptionNode.create(context, IntlUtil.KEY_ROUNDING_MODE, ROUNDING_MODE_OPTION_VALUES, "halfExpand");
        this.getRoundingPriorityOption = GetStringOptionNode.create(context, IntlUtil.KEY_ROUNDING_PRIORITY, ROUNDING_PRIORITY_OPTIONS_VALUES, "auto");
        this.getTrailingZeroDisplayOption = GetStringOptionNode.create(context, IntlUtil.KEY_TRAILING_ZERO_DISPLAY, TRAILING_ZERO_DISPLAY_OPTION_VALUES, "auto");
    }

    public static SetNumberFormatDigitOptionsNode create(JSContext context) {
        return SetNumberFormatDigitOptionsNodeGen.create(context);
    }

    public abstract Object execute(JSNumberFormat.BasicInternalState var1, Object var2, int var3, int var4, boolean var5);

    @Specialization
    public Object setNumberFormatDigitOptions(JSNumberFormat.BasicInternalState intlObj, Object options, int mnfdDefault, int mxfdDefaultParam, boolean compactNotation) {
        boolean needFd;
        int mnid = this.getMinIntDigitsOption.executeInt(options, 1, 21, 1);
        Object mnfdValue = this.getMinFracDigitsOption.getValue(options);
        Object mxfdValue = this.getMaxFracDigitsOption.getValue(options);
        Object mnsdValue = this.getMinSignificantDigitsOption.getValue(options);
        Object mxsdValue = this.getMaxSignificantDigitsOption.getValue(options);
        intlObj.setMinimumIntegerDigits(mnid);
        int roundingIncrement = this.getRoundingIncrementOption.executeInt(options, 1, 5000, 1);
        if (!SetNumberFormatDigitOptionsNode.isValidRoundingIncrement(roundingIncrement)) {
            this.errorBranch.enter();
            throw Errors.createRangeError("roundingIncrement value is out of range.");
        }
        String roundingMode = this.getRoundingModeOption.executeValue(options);
        String roundingPriority = this.getRoundingPriorityOption.executeValue(options);
        String trailingZeroDisplay = this.getTrailingZeroDisplayOption.executeValue(options);
        int mxfdDefault = roundingIncrement == 1 ? mxfdDefaultParam : mnfdDefault;
        intlObj.setRoundingIncrement(roundingIncrement);
        intlObj.setRoundingMode(roundingMode);
        intlObj.setTrailingZeroDisplay(trailingZeroDisplay);
        boolean hasSd = mnsdValue != Undefined.instance || mxsdValue != Undefined.instance;
        boolean hasFd = mnfdValue != Undefined.instance || mxfdValue != Undefined.instance;
        boolean autoRoundingPriority = "auto".equals(roundingPriority);
        boolean needSd = hasSd || !autoRoundingPriority;
        boolean bl = needFd = !hasSd && (hasFd || !compactNotation) || !autoRoundingPriority;
        if (needSd) {
            if (hasSd) {
                int mnsd = this.getMnsdDNO.executeInt(mnsdValue, 1, 21, 1);
                int mxsd = this.getMxsdDNO.executeInt(mxsdValue, mnsd, 21, 21);
                intlObj.setMinimumSignificantDigits(mnsd);
                intlObj.setMaximumSignificantDigits(mxsd);
            } else {
                intlObj.setMinimumSignificantDigits(1);
                intlObj.setMaximumSignificantDigits(21);
            }
        }
        if (needFd) {
            if (hasFd) {
                int mnfd = this.getMnfdDNO.executeInt(mnfdValue, 0, 100, -1);
                int mxfd = this.getMxfdDNO.executeInt(mxfdValue, 0, 100, -1);
                if (mnfd == -1) {
                    mnfd = Math.min(mnfdDefault, mxfd);
                } else if (mxfd == -1) {
                    mxfd = Math.max(mxfdDefault, mnfd);
                } else if (mnfd > mxfd) {
                    this.errorBranch.enter();
                    throw Errors.createRangeError("minimumFractionDigits higher than maximumFractionDigits");
                }
                intlObj.setMinimumFractionDigits(mnfd);
                intlObj.setMaximumFractionDigits(mxfd);
            } else {
                intlObj.setMinimumFractionDigits(mnfdDefault);
                intlObj.setMaximumFractionDigits(mxfdDefault);
            }
        }
        if (needSd || needFd) {
            if ("morePrecision".equals(roundingPriority) || "lessPrecision".equals(roundingPriority)) {
                intlObj.setRoundingType(roundingPriority);
            } else if (hasSd) {
                intlObj.setRoundingType("significantDigits");
            } else {
                intlObj.setRoundingType("fractionDigits");
            }
        } else {
            intlObj.setRoundingType("morePrecision");
            intlObj.setMinimumFractionDigits(0);
            intlObj.setMaximumFractionDigits(0);
            intlObj.setMinimumSignificantDigits(1);
            intlObj.setMaximumSignificantDigits(2);
        }
        if (roundingIncrement != 1) {
            if (!"fractionDigits".equals(intlObj.getRoundingType())) {
                this.errorBranch.enter();
                throw Errors.createTypeError("roundingIncrement can be used with fractionDigits rounding type only");
            }
            if (intlObj.getMinimumFractionDigits().intValue() != intlObj.getMaximumFractionDigits().intValue()) {
                this.errorBranch.enter();
                throw Errors.createRangeError("roundingIncrement can be used when minimumFractionDigits and maximumFractionDigits are equal only");
            }
        }
        return Undefined.instance;
    }

    private static boolean isValidRoundingIncrement(int roundingIncrement) {
        switch (roundingIncrement) {
            case 1: 
            case 2: 
            case 5: 
            case 10: 
            case 20: 
            case 25: 
            case 50: 
            case 100: 
            case 200: 
            case 250: 
            case 500: 
            case 1000: 
            case 2000: 
            case 2500: 
            case 5000: {
                return true;
            }
        }
        return false;
    }
}

