/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.math.BigDecimal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.ToIntlMathematicalValueNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;

public abstract class ToIntlMathematicalValue
extends JavaScriptBaseNode {
    final boolean partOfRange;
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal EIGHT = BigDecimal.valueOf(8L);
    private static final BigDecimal SIXTEEN = BigDecimal.valueOf(16L);

    protected ToIntlMathematicalValue(boolean partOfRange) {
        this.partOfRange = partOfRange;
    }

    @NeverDefault
    public static ToIntlMathematicalValue create(boolean partOfRange) {
        return ToIntlMathematicalValueNodeGen.create(partOfRange);
    }

    public abstract Number executeNumber(Object var1);

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Number doDouble(double value) {
        if (this.partOfRange && Double.isFinite(value) && !JSRuntime.isNegativeZero(value)) {
            return BigDecimal.valueOf(value);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Number doBigInt(BigInt value) {
        return new BigDecimal(value.bigIntegerValue());
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Number doLong(long value) {
        return new BigDecimal(value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Number doString(TruffleString value) {
        return ToIntlMathematicalValue.parseStringNumericLiteral(Strings.toJavaString(JSRuntime.trimJSWhiteSpace(value)));
    }

    @Specialization
    protected Number doBoolean(boolean value) {
        return value ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected Number doUndefined(Object value) {
        return Double.NaN;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected Number doNull(Object value) {
        return BigDecimal.ZERO;
    }

    @Specialization
    protected Number doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization(replaces={"doDouble", "doBigInt", "doString", "doBoolean", "doUndefined", "doNull", "doSymbol"})
    protected Number doGeneric(Object value, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitiveNode, @Cached(value="create(partOfRange)") ToIntlMathematicalValue nestedToIntlMVNode) {
        Object primValue = toPrimitiveNode.execute(value);
        return nestedToIntlMVNode.executeNumber(primValue);
    }

    private static Number parseStringNumericLiteral(String s2) {
        if (s2.isEmpty()) {
            return BigDecimal.ZERO;
        }
        try {
            Number result = ToIntlMathematicalValue.parseStrNumericLiteral(s2);
            return result == null ? (Number)Double.NaN : (Number)result;
        }
        catch (ArithmeticException | NumberFormatException ex) {
            return Double.NaN;
        }
    }

    private static Number parseStrNumericLiteral(String s2) {
        assert (s2.length() >= 1);
        char ch0 = s2.charAt(0);
        switch (ch0) {
            case '+': {
                return ToIntlMathematicalValue.parseStrUnsignedDecimalLiteral(s2.substring(1));
            }
            case '-': {
                Number o2 = ToIntlMathematicalValue.parseStrUnsignedDecimalLiteral(s2.substring(1));
                if (o2 instanceof BigDecimal) {
                    if (((BigDecimal)o2).signum() == 0) {
                        return -0.0;
                    }
                    return ((BigDecimal)o2).negate();
                }
                if (o2 instanceof Double) {
                    return -((Double)o2).doubleValue();
                }
                assert (o2 == null);
                return null;
            }
            case '0': {
                if (s2.length() == 1) {
                    return BigDecimal.ZERO;
                }
                char ch1 = s2.charAt(1);
                switch (ch1) {
                    case 'B': 
                    case 'b': {
                        return ToIntlMathematicalValue.parseBinaryIntegerLiteral(s2.substring(2));
                    }
                    case 'O': 
                    case 'o': {
                        return ToIntlMathematicalValue.parseOctalIntegerLiteral(s2.substring(2));
                    }
                    case 'X': 
                    case 'x': {
                        return ToIntlMathematicalValue.parseHexIntegerLiteral(s2.substring(2));
                    }
                }
            }
        }
        return ToIntlMathematicalValue.parseStrUnsignedDecimalLiteral(s2);
    }

    private static BigDecimal parseBinaryIntegerLiteral(String s2) {
        if (s2.isEmpty()) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if ('0' > c2 || c2 > '1') {
                return null;
            }
            result = result.multiply(TWO).add(BigDecimal.valueOf(c2 - 48));
        }
        return result;
    }

    private static BigDecimal parseOctalIntegerLiteral(String s2) {
        if (s2.isEmpty()) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if ('0' > c2 || c2 > '7') {
                return null;
            }
            result = result.multiply(EIGHT).add(BigDecimal.valueOf(c2 - 48));
        }
        return result;
    }

    private static BigDecimal parseHexIntegerLiteral(String s2) {
        if (s2.isEmpty()) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            int digit;
            char c2 = s2.charAt(i2);
            if ('0' <= c2 && c2 <= '9') {
                digit = c2 - 48;
            } else if ('a' <= c2 && c2 <= 'f') {
                digit = 10 + (c2 - 97);
            } else if ('A' <= c2 && c2 <= 'F') {
                digit = 10 + (c2 - 65);
            } else {
                return null;
            }
            result = result.multiply(SIXTEEN).add(BigDecimal.valueOf(digit));
        }
        return result;
    }

    private static Number parseStrUnsignedDecimalLiteral(String s2) {
        Object digits;
        int fractionalPartLength;
        if (s2.isEmpty()) {
            return null;
        }
        if ("Infinity".equals(s2)) {
            return Double.POSITIVE_INFINITY;
        }
        int dotIndex = s2.indexOf(46);
        int exponentIndex = Math.max(s2.indexOf(101, dotIndex + 1), s2.indexOf(69, dotIndex + 1));
        if (dotIndex == -1) {
            fractionalPartLength = 0;
            digits = exponentIndex == -1 ? s2 : s2.substring(0, exponentIndex);
        } else {
            String integerPart = s2.substring(0, dotIndex);
            String fractionalPart = exponentIndex == -1 ? s2.substring(dotIndex + 1) : s2.substring(dotIndex + 1, exponentIndex);
            fractionalPartLength = fractionalPart.length();
            digits = integerPart + fractionalPart;
        }
        BigDecimal result = ToIntlMathematicalValue.parseDecimalDigits((String)digits);
        if (result == null) {
            return null;
        }
        result = result.movePointLeft(fractionalPartLength);
        if (exponentIndex != -1) {
            String exponentPart = s2.substring(exponentIndex + 1);
            int exponent = ToIntlMathematicalValue.parseSignedInteger(exponentPart);
            result = result.movePointRight(exponent);
        }
        return result;
    }

    private static BigDecimal parseDecimalDigits(String s2) {
        if (s2.isEmpty()) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if ('0' > c2 || c2 > '9') {
                return null;
            }
            result = result.multiply(BigDecimal.TEN).add(BigDecimal.valueOf(c2 - 48));
        }
        return result;
    }

    private static int parseSignedInteger(String s2) {
        return Integer.parseInt(s2);
    }
}

