/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.GraalJSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContextOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.PromiseRejectionTracker;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class BuiltinPromiseRejectionTracker
implements PromiseRejectionTracker {
    private final JSContext context;
    private final JSContextOptions.UnhandledRejectionsTrackingMode mode;
    private final Set<JSDynamicObject> pendingUnhandledRejections = new LinkedHashSet<JSDynamicObject>();
    private final Deque<PromiseChainInfoRecord> asyncHandledRejections = new LinkedList<PromiseChainInfoRecord>();
    private final Map<JSDynamicObject, PromiseChainInfoRecord> maybeUnhandledPromises = new WeakHashMap<JSDynamicObject, PromiseChainInfoRecord>();

    public BuiltinPromiseRejectionTracker(JSContext context, JSContextOptions.UnhandledRejectionsTrackingMode mode) {
        assert (mode != JSContextOptions.UnhandledRejectionsTrackingMode.NONE);
        this.context = context;
        this.mode = mode;
    }

    @Override
    public void promiseRejected(JSDynamicObject promise, Object reason) {
        CompilerAsserts.neverPartOfCompilation();
        this.maybeUnhandledPromises.put(promise, new PromiseChainInfoRecord(reason, false));
        this.pendingUnhandledRejections.add(promise);
        this.context.getLanguage().getPromiseJobsQueueEmptyAssumption().invalidate("Potential unhandled rejection");
    }

    @Override
    public void promiseRejectionHandled(JSDynamicObject promise) {
        CompilerAsserts.neverPartOfCompilation();
        PromiseChainInfoRecord promiseInfo = this.maybeUnhandledPromises.get(promise);
        if (promiseInfo != null) {
            this.maybeUnhandledPromises.remove(promise);
            this.pendingUnhandledRejections.remove(promise);
            if (promiseInfo.warned) {
                this.asyncHandledRejections.add(promiseInfo);
            }
        }
    }

    @Override
    public void promiseRejectedAfterResolved(JSDynamicObject promise, Object value) {
    }

    @Override
    public void promiseResolvedAfterResolved(JSDynamicObject promise, Object value) {
    }

    @Override
    public void promiseReactionJobsProcessed() {
        CompilerAsserts.neverPartOfCompilation();
        JSRealm realm = JSRealm.get(null);
        assert (realm.getContext() == this.context);
        while (!this.asyncHandledRejections.isEmpty()) {
            PromiseChainInfoRecord info = this.asyncHandledRejections.removeFirst();
            if (this.mode != JSContextOptions.UnhandledRejectionsTrackingMode.WARN) continue;
            PrintWriter out = realm.getErrorWriter();
            out.println("[GraalVM JavaScript Warning] Promise rejection was handled asynchronously: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
            out.flush();
        }
        ArrayList<AbstractTruffleException> errors = new ArrayList<AbstractTruffleException>();
        while (!this.pendingUnhandledRejections.isEmpty()) {
            JSDynamicObject unhandledPromise = this.pendingUnhandledRejections.iterator().next();
            this.pendingUnhandledRejections.remove(unhandledPromise);
            PromiseChainInfoRecord info = this.maybeUnhandledPromises.get(unhandledPromise);
            if (info == null) continue;
            info.warned = true;
            if (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.HANDLER) {
                Object handler = realm.getUnhandledPromiseRejectionHandler();
                if (handler == null) continue;
                JSRuntime.call(handler, Undefined.instance, new Object[]{info.reason, unhandledPromise});
                continue;
            }
            if (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.WARN) {
                PrintWriter out = realm.getErrorWriter();
                out.println("[GraalVM JavaScript Warning] Unhandled promise rejection: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
                out.flush();
                continue;
            }
            assert (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.THROW);
            InteropLibrary interop = InteropLibrary.getUncached(info.reason);
            if (interop.isException(info.reason)) {
                try {
                    interop.throwException(info.reason);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                }
                catch (AbstractTruffleException e3) {
                    errors.add(e3);
                    continue;
                }
            }
            errors.add(Errors.createError("Unhandled promise rejection: " + BuiltinPromiseRejectionTracker.formatError(info.reason)));
        }
        if (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.THROW && !errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (AbstractTruffleException)errors.get(0);
            }
            throw Errors.createAggregateError(JSArray.createConstant(this.context, realm, errors.stream().map(e2 -> {
                Object object;
                if (e2 instanceof GraalJSException) {
                    GraalJSException ex = (GraalJSException)e2;
                    object = ex.getErrorObject();
                } else {
                    object = e2;
                }
                return object;
            }).toArray()), "Unhandled promise rejections", null);
        }
    }

    private static String formatError(Object error) {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary interopExc = InteropLibrary.getUncached(error);
        InteropLibrary interopStr = InteropLibrary.getUncached();
        return JSInteropUtil.formatError(error, interopExc, interopStr);
    }

    private static class PromiseChainInfoRecord {
        private final Object reason;
        private boolean warned;

        PromiseChainInfoRecord(Object reason, boolean warned) {
            this.reason = reason;
            this.warned = warned;
        }
    }
}

