/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromise;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class PromiseResolveNode
extends JavaScriptBaseNode {
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapability;
    @Node.Child
    private JSFunctionCallNode callResolve;
    @Node.Child
    private PropertyGetNode getConstructor;

    protected PromiseResolveNode(JSContext context) {
        this.newPromiseCapability = NewPromiseCapabilityNode.create(context);
        this.callResolve = JSFunctionCallNode.createCall();
        this.getConstructor = PropertyGetNode.create(JSObject.CONSTRUCTOR, false, context);
    }

    public static PromiseResolveNode create(JSContext context) {
        return new PromiseResolveNode(context);
    }

    public JSDynamicObject execute(JSDynamicObject constructor, Object value) {
        Object otherConstructor;
        assert (JSRuntime.isObject(constructor));
        if (JSPromise.isJSPromise(value) && (otherConstructor = this.getConstructor.getValue(value)) == constructor) {
            return (JSPromiseObject)value;
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability.execute(constructor);
        this.callResolve.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), value));
        return promiseCapability.getPromise();
    }

    public JSPromiseObject executeDefault(Object value) {
        return (JSPromiseObject)this.execute(this.getRealm().getPromiseConstructor(), value);
    }
}

