/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

@ImportStatic(value={TemporalConstants.class})
public abstract class DifferenceZonedDateTimeNode
extends JavaScriptBaseNode {
    protected DifferenceZonedDateTimeNode() {
    }

    public abstract NormalizedDurationRecord execute(BigInt var1, BigInt var2, TimeZoneMethodsRecord var3, CalendarMethodsRecord var4, TemporalUtil.Unit var5, JSDynamicObject var6, JSTemporalPlainDateTimeObject var7);

    @Specialization
    final NormalizedDurationRecord differenceZonedDateTime(BigInt ns1, BigInt ns2, TimeZoneMethodsRecord timeZoneRec, CalendarMethodsRecord calendarRec, TemporalUtil.Unit largestUnit, JSDynamicObject options, JSTemporalPlainDateTimeObject startDateTime, @Cached TemporalDifferenceDateNode differenceDateNode, @Cached(value="createKeys(getJSContext())") EnumerableOwnPropertyNamesNode namesNode) {
        int sign = ns2.compareTo(ns1);
        if (sign == 0) {
            return new NormalizedDurationRecord(0.0, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
        }
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        JSTemporalInstantObject endInstant = JSTemporalInstant.create(ctx, realm, ns2);
        JSTemporalPlainDateTimeObject endDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, endInstant, calendarRec.receiver());
        int maxDayCorrection = sign == 1 ? 2 : 1;
        int dayCorrection = 0;
        BigInt timeDuration = TemporalUtil.differenceTime(startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond(), startDateTime.getMillisecond(), startDateTime.getMicrosecond(), startDateTime.getNanosecond(), endDateTime.getHour(), endDateTime.getMinute(), endDateTime.getSecond(), endDateTime.getMillisecond(), endDateTime.getMicrosecond(), endDateTime.getNanosecond());
        int normalizedTimeDurationSign = TemporalUtil.normalizedTimeDurationSign(timeDuration);
        if (normalizedTimeDurationSign == -sign) {
            ++dayCorrection;
        }
        JSTemporalPlainDateTimeObject intermediateDateTime = null;
        BigInt norm = null;
        boolean success = false;
        while (dayCorrection <= maxDayCorrection) {
            ISODateRecord intermediateDate = TemporalUtil.balanceISODate(endDateTime.getYear(), endDateTime.getMonth(), endDateTime.getDay() - dayCorrection * sign);
            intermediateDateTime = JSTemporalPlainDateTime.create(ctx, realm, intermediateDate.year(), intermediateDate.month(), intermediateDate.day(), startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond(), startDateTime.getMillisecond(), startDateTime.getMicrosecond(), startDateTime.getNanosecond(), calendarRec.receiver());
            JSTemporalInstantObject intermediateInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, intermediateDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            BigInt intermediateNs = intermediateInstant.getNanoseconds();
            norm = TemporalUtil.normalizedTimeDurationFromEpochNanosecondsDifference(ns2, intermediateNs);
            int timeSign = TemporalUtil.normalizedTimeDurationSign(norm);
            if (sign != -timeSign) {
                success = true;
                break;
            }
            ++dayCorrection;
        }
        if (success) {
            JSTemporalPlainDateObject date1 = JSTemporalPlainDate.create(ctx, realm, startDateTime.getYear(), startDateTime.getMonth(), startDateTime.getDay(), calendarRec.receiver(), null, InlinedBranchProfile.getUncached());
            JSTemporalPlainDateObject date2 = JSTemporalPlainDate.create(ctx, realm, intermediateDateTime.getYear(), intermediateDateTime.getMonth(), intermediateDateTime.getDay(), calendarRec.receiver(), null, InlinedBranchProfile.getUncached());
            TemporalUtil.Unit dateLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(largestUnit, TemporalUtil.Unit.DAY);
            JSObject untilOptions = TemporalUtil.mergeLargestUnitOption(ctx, namesNode, options, dateLargestUnit);
            JSTemporalDurationObject dateDifference = differenceDateNode.execute(calendarRec, date1, date2, dateLargestUnit, untilOptions);
            return TemporalUtil.createNormalizedDurationRecord(dateDifference.getYears(), dateDifference.getMonths(), dateDifference.getWeeks(), dateDifference.getDays(), norm);
        }
        throw Errors.createRangeError("custom calendar or time zone methods returned inconsistent values");
    }
}

