/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalGetOptionNode
extends JavaScriptBaseNode {
    protected TemporalGetOptionNode() {
    }

    public abstract Object execute(JSDynamicObject var1, TruffleString var2, TemporalUtil.OptionType var3, List<?> var4, Object var5);

    @Specialization
    protected Object getOption(JSDynamicObject options, TruffleString property, TemporalUtil.OptionType types, List<?> values, Object fallback, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isFallbackProfile, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached JSToStringNode toStringNode, @Cached JSToNumberNode toNumberNode) {
        assert (JSRuntime.isObject(options));
        Object value = JSObject.get(options, property);
        if (isFallbackProfile.profile(this, value == Undefined.instance)) {
            return fallback;
        }
        TemporalUtil.OptionType type = value instanceof Boolean && types.allowsBoolean() ? TemporalUtil.OptionType.BOOLEAN : (Strings.isTString(value) && types.allowsString() ? TemporalUtil.OptionType.STRING : (JSRuntime.isNumber(value) && types.allowsNumber() ? TemporalUtil.OptionType.NUMBER : types.getLast()));
        if (type.allowsBoolean()) {
            value = toBooleanNode.executeBoolean(this, value);
        } else if (type.allowsNumber()) {
            if (JSRuntime.isNaN(value = toNumberNode.executeNumber(value))) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorNumberIsNaN();
            }
        } else if (type.allowsString()) {
            value = toStringNode.executeString(value);
        }
        if (value != Undefined.instance && values != null && !Boundaries.listContainsUnchecked(values, value)) {
            errorBranch.enter(this);
            throw TemporalErrors.createRangeErrorOptionsNotContained(values, value);
        }
        return value;
    }
}

