/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarSlotValueWithISODefaultNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneSlotValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToRelativeTemporalObjectNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getRelativeToNode;
    @Node.Child
    private PropertyGetNode getOffsetNode;
    @Node.Child
    private PropertyGetNode getTimeZoneNode;

    protected ToRelativeTemporalObjectNode() {
        JSContext ctx = JavaScriptLanguage.get(null).getJSContext();
        this.getRelativeToNode = PropertyGetNode.create(TemporalConstants.RELATIVE_TO, ctx);
        this.getOffsetNode = PropertyGetNode.create(TemporalConstants.OFFSET, ctx);
        this.getTimeZoneNode = PropertyGetNode.create(TemporalConstants.TIME_ZONE, ctx);
    }

    public abstract Result execute(JSDynamicObject var1);

    @Specialization
    protected Result toRelativeTemporalObject(JSDynamicObject options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile valueIsObject, @Cached InlinedConditionProfile valueIsUndefined, @Cached InlinedBranchProfile valueIsPlainDate, @Cached InlinedBranchProfile valueIsZonedDateTime, @Cached InlinedConditionProfile valueIsPlainDateTime, @Cached InlinedConditionProfile timeZoneAvailable, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord, @Cached IsObjectNode isObjectNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached ToTemporalTimeZoneSlotValueNode toTimeZoneSlotValue, @Cached GetTemporalCalendarSlotValueWithISODefaultNode getTemporalCalendarWithISODefaultNode, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached TemporalGetOptionNode getOptionNode) {
        Object offsetString;
        JSTemporalDateTimeRecord result;
        Object calendar;
        Object value = this.getRelativeToNode.getValue(options);
        if (valueIsUndefined.profile(this, value == Undefined.instance)) {
            return ToRelativeTemporalObjectNode.none();
        }
        Object timeZone = Undefined.instance;
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (value instanceof JSTemporalPlainDateObject) {
            JSTemporalPlainDateObject plainDate = (JSTemporalPlainDateObject)value;
            valueIsPlainDate.enter(this);
            return ToRelativeTemporalObjectNode.plainDate(plainDate);
        }
        if (value instanceof JSTemporalZonedDateTimeObject) {
            JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)value;
            valueIsZonedDateTime.enter(this);
            return ToRelativeTemporalObjectNode.zonedDateTime(zonedDateTime, createTimeZoneMethodsRecord.executeFull(zonedDateTime.getTimeZone()));
        }
        if (valueIsObject.profile(this, isObjectNode.executeBoolean(value))) {
            if (valueIsPlainDateTime.profile(this, value instanceof JSTemporalPlainDateTimeObject)) {
                JSTemporalPlainDateTimeObject pd = (JSTemporalPlainDateTimeObject)value;
                return ToRelativeTemporalObjectNode.plainDate(JSTemporalPlainDate.create(ctx, realm, pd.getYear(), pd.getMonth(), pd.getDay(), pd.getCalendar(), this, errorBranch));
            }
            calendar = getTemporalCalendarWithISODefaultNode.execute(value);
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendar);
            Object fieldsMethod = lookupFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateFromFieldsAndFields(calendar, dateFromFieldsMethod, fieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, Boundaries.listEditableCopy(TemporalUtil.listDMMCY));
            ToRelativeTemporalObjectNode.addFieldNames(fieldNames);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, value, fieldNames, TemporalUtil.listEmpty);
            JSObject dateOptions = JSOrdinary.createWithNullPrototype(ctx);
            JSObjectUtil.putDataProperty(dateOptions, TemporalConstants.OVERFLOW, TemporalConstants.CONSTRAIN);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendarRec, fields, dateOptions, getOptionNode, dateFromFieldsNode);
            offsetString = this.getOffsetNode.getValue(fields);
            Object timeZoneTemp = this.getTimeZoneNode.getValue(fields);
            if (timeZoneTemp != Undefined.instance) {
                timeZone = toTimeZoneSlotValue.execute(timeZoneTemp);
            }
            if (offsetString == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            }
        } else if (value instanceof TruffleString) {
            TruffleString string = (TruffleString)value;
            ParseISODateTimeResult resultZDT = TemporalUtil.parseTemporalRelativeToString(string);
            result = resultZDT;
            offsetString = resultZDT.getTimeZoneResult().getOffsetString();
            TruffleString timeZoneName = resultZDT.getTimeZoneResult().getName();
            if (timeZoneName != null) {
                if ((timeZoneName = TemporalUtil.canonicalizeTimeZoneName(timeZoneName)) == null) {
                    errorBranch.enter(this);
                    throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
                }
                timeZone = TemporalUtil.createTemporalTimeZone(ctx, realm, timeZoneName);
            }
            if (resultZDT.getTimeZoneResult().isZ()) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.EXACT;
            } else if (offsetString == null) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            }
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
            calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar((TruffleString)calendar)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorCalendarNotSupported();
            }
        } else {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAString(value);
        }
        if (timeZoneAvailable.profile(this, timeZone != Undefined.instance)) {
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            long offsetNs = offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION ? TemporalUtil.parseTimeZoneOffsetString((TruffleString)offsetString) : 0L;
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNs, timeZoneRec, TemporalUtil.Disambiguation.COMPATIBLE, TemporalUtil.OffsetOption.REJECT, matchBehaviour);
            return ToRelativeTemporalObjectNode.zonedDateTime(JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar), timeZoneRec);
        }
        return ToRelativeTemporalObjectNode.plainDate(JSTemporalPlainDate.create(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), calendar, this, errorBranch));
    }

    @CompilerDirectives.TruffleBoundary
    private static void addFieldNames(List<TruffleString> fieldNames) {
        fieldNames.add(TemporalConstants.HOUR);
        fieldNames.add(TemporalConstants.MICROSECOND);
        fieldNames.add(TemporalConstants.MILLISECOND);
        fieldNames.add(TemporalConstants.MINUTE);
        fieldNames.add(TemporalConstants.NANOSECOND);
        fieldNames.add(TemporalConstants.OFFSET);
        fieldNames.add(TemporalConstants.SECOND);
        fieldNames.add(TemporalConstants.TIME_ZONE);
    }

    private static Result none() {
        return new Result(null, null, null);
    }

    private static Result plainDate(JSTemporalPlainDateObject plainDate) {
        return new Result(plainDate, null, null);
    }

    private static Result zonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, TimeZoneMethodsRecord timeZoneRec) {
        return new Result(null, zonedDateTime, timeZoneRec);
    }

    public record Result(JSTemporalPlainDateObject plainRelativeTo, JSTemporalZonedDateTimeObject zonedRelativeTo, TimeZoneMethodsRecord timeZoneRec) {
        public JSTemporalCalendarHolder relativeTo() {
            return this.zonedRelativeTo != null ? this.zonedRelativeTo : this.plainRelativeTo;
        }

        public CalendarMethodsRecord createCalendarMethodsRecord(CalendarMethodsRecordLookupNode lookupDateAddNode, CalendarMethodsRecordLookupNode lookupDateUntilNode) {
            JSTemporalCalendarHolder relativeTo = this.relativeTo();
            if (relativeTo == null) {
                return null;
            }
            Object calendar = this.relativeTo().getCalendar();
            Object dateAdd = lookupDateAddNode == null ? null : lookupDateAddNode.execute(calendar);
            Object dateUntil = lookupDateUntilNode == null ? null : lookupDateUntilNode.execute(calendar);
            return CalendarMethodsRecord.forDateAddDateUntil(calendar, dateAdd, dateUntil);
        }
    }
}

