/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarSlotValueWithISODefaultNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalDateTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalDateTimeNode() {
    }

    public abstract JSTemporalPlainDateTimeObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalPlainDateTimeObject toTemporalDateTime(Object item, JSDynamicObject options, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isPlainDateTimeProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached InlinedConditionProfile isPlainDateProfile, @Cached InlinedBranchProfile errorBranch, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached IsObjectNode isObjectNode, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached GetTemporalCalendarSlotValueWithISODefaultNode getTemporalCalendarNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
        JSTemporalDateTimeRecord result;
        Object calendar;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSObject resolvedOptions = snapshotOwnProperties.snapshot(options, Null.instance);
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            if (isPlainDateTimeProfile.profile(this, item instanceof JSTemporalPlainDateTimeObject)) {
                return (JSTemporalPlainDateTimeObject)item;
            }
            if (isZonedDateTimeProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(item))) {
                TemporalUtil.toTemporalOverflow(resolvedOptions, getOptionNode);
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)item;
                JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, zdt.getNanoseconds());
                TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(zdt.getTimeZone());
                return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, zdt.getCalendar());
            }
            if (isPlainDateProfile.profile(this, item instanceof JSTemporalPlainDateObject)) {
                TemporalUtil.toTemporalOverflow(resolvedOptions, getOptionNode);
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)item;
                return JSTemporalPlainDateTime.create(ctx, realm, date.getYear(), date.getMonth(), date.getDay(), 0, 0, 0, 0, 0, 0, date.getCalendar(), this, errorBranch);
            }
            calendar = getTemporalCalendarNode.execute(item);
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendar);
            Object fieldsMethod = lookupFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateFromFieldsAndFields(calendar, dateFromFieldsMethod, fieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, Boundaries.listEditableCopy(TemporalUtil.listDMMCY));
            ToTemporalDateTimeNode.addFieldNames(fieldNames);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, item, fieldNames, TemporalUtil.listEmpty);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendarRec, fields, resolvedOptions, getOptionNode, dateFromFieldsNode);
        } else if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            result = TemporalUtil.parseTemporalDateTimeString(string);
            assert (TemporalUtil.isValidISODate(result.getYear(), result.getMonth(), result.getDay()));
            assert (TemporalUtil.isValidTime(result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond()));
            calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar((TruffleString)calendar)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorCalendarNotSupported();
            }
            TemporalUtil.toTemporalOverflow(resolvedOptions, getOptionNode);
        } else {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAString(item);
        }
        return JSTemporalPlainDateTime.create(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), calendar, this, errorBranch);
    }

    @CompilerDirectives.TruffleBoundary
    private static void addFieldNames(List<TruffleString> fieldNames) {
        fieldNames.add(TemporalConstants.HOUR);
        fieldNames.add(TemporalConstants.MICROSECOND);
        fieldNames.add(TemporalConstants.MILLISECOND);
        fieldNames.add(TemporalConstants.MINUTE);
        fieldNames.add(TemporalConstants.NANOSECOND);
        fieldNames.add(TemporalConstants.SECOND);
    }
}

