/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarSlotValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalMonthDayNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getCalendarNode;

    protected ToTemporalMonthDayNode() {
    }

    public abstract JSTemporalPlainMonthDayObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalPlainMonthDayObject toTemporalMonthDay(Object item, JSDynamicObject optionsParam, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile returnPlainMonthDay, @Cached InlinedConditionProfile getCalendarPath, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached IsObjectNode isObjectNode, @Cached(value="createWithISO8601()") ToTemporalCalendarSlotValueNode toCalendarSlotValue, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createMonthDayFromFields()") CalendarMethodsRecordLookupNode lookupMonthDayFromFields, @Cached TemporalGetOptionNode temporalGetOptionNode, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
        JSDynamicObject options;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSDynamicObject jSDynamicObject = options = optionsParam == Undefined.instance ? optionsParam : snapshotOwnProperties.snapshot(optionsParam, Null.instance);
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            Object calendar;
            JSDynamicObject itemObj = (JSDynamicObject)item;
            if (JSTemporalPlainMonthDay.isJSTemporalPlainMonthDay(itemObj)) {
                return (JSTemporalPlainMonthDayObject)itemObj;
            }
            if (getCalendarPath.profile(this, JSTemporalPlainDate.isJSTemporalPlainDate(itemObj) || JSTemporalPlainDateTime.isJSTemporalPlainDateTime(itemObj) || JSTemporalPlainTime.isJSTemporalPlainTime(itemObj) || JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(itemObj) || TemporalUtil.isTemporalZonedDateTime(itemObj))) {
                calendar = ((JSTemporalCalendarHolder)itemObj).getCalendar();
            } else {
                Object calendarLike = this.getCalendar(itemObj);
                calendar = toCalendarSlotValue.execute(calendarLike);
            }
            Object fieldsMethod = lookupFields.execute(calendar);
            Object monthDayFromFieldsMethod = lookupMonthDayFromFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forFieldsAndMonthDayFromFields(calendar, fieldsMethod, monthDayFromFieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listDMMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, itemObj, fieldNames, TemporalUtil.listEmpty);
            return monthDayFromFieldsNode.execute(calendarRec, fields, options);
        }
        if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalMonthDayString(string);
            TruffleString calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar(calendar)) {
                throw Errors.createRangeError("built-in calendar expected");
            }
            TemporalUtil.toTemporalOverflow(options, temporalGetOptionNode);
            if (returnPlainMonthDay.profile(this, result.getYear() == Integer.MIN_VALUE)) {
                int referenceISOYear = 1972;
                return JSTemporalPlainMonthDay.create(ctx, realm, result.getMonth(), result.getDay(), calendar, referenceISOYear, this, errorBranch);
            }
            JSTemporalPlainMonthDayObject result2 = JSTemporalPlainMonthDay.create(ctx, realm, result.getMonth(), result.getDay(), calendar, result.getYear(), this, errorBranch);
            Object monthDayFromFieldsMethod = lookupMonthDayFromFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forMonthDayFromFieldsMethod(calendar, monthDayFromFieldsMethod);
            return monthDayFromFieldsNode.execute(calendarRec, result2, Undefined.instance);
        }
        errorBranch.enter(this);
        throw Errors.createTypeErrorNotAString(item);
    }

    private Object getCalendar(JSDynamicObject obj) {
        if (this.getCalendarNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarNode = this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, this.getLanguage().getJSContext()));
        }
        return this.getCalendarNode.getValue(obj);
    }
}

