/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ObjectImplementsTemporalTimeZoneProtocolNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalTimeZoneSlotValueNode
extends JavaScriptBaseNode {
    protected ToTemporalTimeZoneSlotValueNode() {
    }

    public abstract Object execute(Object var1);

    @Specialization
    protected Object toTemporalTimeZoneSlotValue(Object temporalTimeZoneLike, @Cached IsObjectNode isObjectNode, @Cached ObjectImplementsTemporalTimeZoneProtocolNode objectImplementsTimeZoneProtocol, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isTimeZoneProfile) {
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(temporalTimeZoneLike))) {
            if (isTimeZoneProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(temporalTimeZoneLike))) {
                return ((JSTemporalZonedDateTimeObject)temporalTimeZoneLike).getTimeZone();
            }
            if (objectImplementsTimeZoneProtocol.execute(temporalTimeZoneLike)) {
                return temporalTimeZoneLike;
            }
            errorBranch.enter(this);
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
        if (temporalTimeZoneLike instanceof TruffleString) {
            TruffleString identifier = (TruffleString)temporalTimeZoneLike;
            JSTemporalTimeZoneRecord parseResult = TemporalUtil.parseTemporalTimeZoneString(identifier);
            TruffleString offsetMinutes = parseResult.getOffsetString();
            TruffleString name = parseResult.getName();
            if (offsetMinutes != null && name == null) {
                return TemporalUtil.formatTimeZoneOffsetString(TemporalUtil.parseTimeZoneOffsetString(offsetMinutes));
            }
            TruffleString timeZoneName = TemporalUtil.canonicalizeTimeZoneName(name);
            if (timeZoneName == null) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
            }
            return timeZoneName;
        }
        errorBranch.enter(this);
        throw Errors.createTypeErrorNotAString(temporalTimeZoneLike);
    }
}

